/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "wizard_options.h"

WizardOptions::WizardOptions (bool init /* = true */) :
    mOptions (WizardOptions::OptionNum),
    mNotify (WizardOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
WizardOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    CompOption::Value::Vector list;
    CompOption::Value value;

    // toggle
    mOptions[WizardOptions::Toggle].setName ("toggle", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super>w");
    mOptions[WizardOptions::Toggle].value().set (action);
    if (screen) screen->addAction (&mOptions[WizardOptions::Toggle].value ().action ());

    // gx
    mOptions[WizardOptions::Gx].setName ("gx", CompOption::TypeFloat);
    mOptions[WizardOptions::Gx].rest ().set (-0.01, 0.01, 0.00001);
    mOptions[WizardOptions::Gx].value().set((float) 0.0);

    // gy
    mOptions[WizardOptions::Gy].setName ("gy", CompOption::TypeFloat);
    mOptions[WizardOptions::Gy].rest ().set (-0.01, 0.01, 0.00001);
    mOptions[WizardOptions::Gy].value().set((float) 0.0005);

    // g_strength
    mOptions[WizardOptions::GStrength].setName ("g_strength", CompOption::TypeList);
    mOptions[WizardOptions::GStrength].rest ().set (-1000, 1000);
    list.clear ();
    value.set((int) 200);
    list.push_back (value);
    mOptions[WizardOptions::GStrength].value().set (CompOption::TypeInt, list);

    // g_posx
    mOptions[WizardOptions::GPosx].setName ("g_posx", CompOption::TypeList);
    mOptions[WizardOptions::GPosx].rest ().set (0, 3000);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    mOptions[WizardOptions::GPosx].value().set (CompOption::TypeInt, list);

    // g_posy
    mOptions[WizardOptions::GPosy].setName ("g_posy", CompOption::TypeList);
    mOptions[WizardOptions::GPosy].rest ().set (0, 2000);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    mOptions[WizardOptions::GPosy].value().set (CompOption::TypeInt, list);

    // g_speed
    mOptions[WizardOptions::GSpeed].setName ("g_speed", CompOption::TypeList);
    mOptions[WizardOptions::GSpeed].rest ().set (0, 1000);
    list.clear ();
    value.set((int) 100);
    list.push_back (value);
    mOptions[WizardOptions::GSpeed].value().set (CompOption::TypeInt, list);

    // g_angle
    mOptions[WizardOptions::GAngle].setName ("g_angle", CompOption::TypeList);
    mOptions[WizardOptions::GAngle].rest ().set (0, 360);
    list.clear ();
    value.set((int) 20);
    list.push_back (value);
    mOptions[WizardOptions::GAngle].value().set (CompOption::TypeInt, list);

    // g_movement
    mOptions[WizardOptions::GMovement].setName ("g_movement", CompOption::TypeList);
    mOptions[WizardOptions::GMovement].rest ().set (0, 4);
    list.clear ();
    value.set((int) 2);
    list.push_back (value);
    mOptions[WizardOptions::GMovement].value().set (CompOption::TypeInt, list);

    // e_active
    mOptions[WizardOptions::EActive].setName ("e_active", CompOption::TypeList);
    list.clear ();
    value.set(false);
    list.push_back (value);
    value.set(false);
    list.push_back (value);
    value.set(true);
    list.push_back (value);
    value.set(true);
    list.push_back (value);
    value.set(false);
    list.push_back (value);
    value.set(true);
    list.push_back (value);
    value.set(true);
    list.push_back (value);
    value.set(true);
    list.push_back (value);
    value.set(true);
    list.push_back (value);
    value.set(true);
    list.push_back (value);
    mOptions[WizardOptions::EActive].value().set (CompOption::TypeBool, list);

    // e_name
    mOptions[WizardOptions::EName].setName ("e_name", CompOption::TypeList);
    list.clear ();
    value.set(CompString ("Fire Ball"));
    list.push_back (value);
    value.set(CompString ("Flame Pointer"));
    list.push_back (value);
    value.set(CompString ("Magic Pointer"));
    list.push_back (value);
    value.set(CompString ("Magic Rain (On/Off)"));
    list.push_back (value);
    value.set(CompString ("Magic Rain with Gravity Particles"));
    list.push_back (value);
    value.set(CompString ("Random Red Explosion"));
    list.push_back (value);
    value.set(CompString ("Random Yellow Explosion"));
    list.push_back (value);
    value.set(CompString ("Random Green Explosion"));
    list.push_back (value);
    value.set(CompString ("Random Blue Explosion"));
    list.push_back (value);
    value.set(CompString ("Random Purple Explosion"));
    list.push_back (value);
    mOptions[WizardOptions::EName].value().set (CompOption::TypeString, list);

    // e_trigger
    mOptions[WizardOptions::ETrigger].setName ("e_trigger", CompOption::TypeList);
    mOptions[WizardOptions::ETrigger].rest ().set (0, 5);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 1);
    list.push_back (value);
    value.set((int) 3);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 2);
    list.push_back (value);
    value.set((int) 2);
    list.push_back (value);
    value.set((int) 2);
    list.push_back (value);
    value.set((int) 2);
    list.push_back (value);
    value.set((int) 2);
    list.push_back (value);
    mOptions[WizardOptions::ETrigger].value().set (CompOption::TypeInt, list);

    // e_posx
    mOptions[WizardOptions::EPosx].setName ("e_posx", CompOption::TypeList);
    mOptions[WizardOptions::EPosx].rest ().set (0, 3000);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 1000);
    list.push_back (value);
    value.set((int) 1000);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    mOptions[WizardOptions::EPosx].value().set (CompOption::TypeInt, list);

    // e_posy
    mOptions[WizardOptions::EPosy].setName ("e_posy", CompOption::TypeList);
    mOptions[WizardOptions::EPosy].rest ().set (0, 2000);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    mOptions[WizardOptions::EPosy].value().set (CompOption::TypeInt, list);

    // e_speed
    mOptions[WizardOptions::ESpeed].setName ("e_speed", CompOption::TypeList);
    mOptions[WizardOptions::ESpeed].rest ().set (0, 1000);
    list.clear ();
    value.set((int) 100);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 1000);
    list.push_back (value);
    value.set((int) 1000);
    list.push_back (value);
    value.set((int) 1000);
    list.push_back (value);
    value.set((int) 1000);
    list.push_back (value);
    value.set((int) 1000);
    list.push_back (value);
    mOptions[WizardOptions::ESpeed].value().set (CompOption::TypeInt, list);

    // e_angle
    mOptions[WizardOptions::EAngle].setName ("e_angle", CompOption::TypeList);
    mOptions[WizardOptions::EAngle].rest ().set (0, 360);
    list.clear ();
    value.set((int) 326);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 13);
    list.push_back (value);
    value.set((int) 33);
    list.push_back (value);
    value.set((int) 53);
    list.push_back (value);
    value.set((int) 73);
    list.push_back (value);
    value.set((int) 93);
    list.push_back (value);
    mOptions[WizardOptions::EAngle].value().set (CompOption::TypeInt, list);

    // e_movement
    mOptions[WizardOptions::EMovement].setName ("e_movement", CompOption::TypeList);
    mOptions[WizardOptions::EMovement].rest ().set (0, 3);
    list.clear ();
    value.set((int) 2);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 3);
    list.push_back (value);
    value.set((int) 3);
    list.push_back (value);
    value.set((int) 3);
    list.push_back (value);
    value.set((int) 3);
    list.push_back (value);
    value.set((int) 3);
    list.push_back (value);
    value.set((int) 3);
    list.push_back (value);
    value.set((int) 3);
    list.push_back (value);
    mOptions[WizardOptions::EMovement].value().set (CompOption::TypeInt, list);

    // e_count
    mOptions[WizardOptions::ECount].setName ("e_count", CompOption::TypeList);
    mOptions[WizardOptions::ECount].rest ().set (1, 1000);
    list.clear ();
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 20);
    list.push_back (value);
    value.set((int) 40);
    list.push_back (value);
    value.set((int) 20);
    list.push_back (value);
    value.set((int) 20);
    list.push_back (value);
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 200);
    list.push_back (value);
    mOptions[WizardOptions::ECount].value().set (CompOption::TypeInt, list);

    // e_h
    mOptions[WizardOptions::EH].setName ("e_h", CompOption::TypeList);
    mOptions[WizardOptions::EH].rest ().set (0, 1000);
    list.clear ();
    value.set((int) 67);
    list.push_back (value);
    value.set((int) 100);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 167);
    list.push_back (value);
    value.set((int) 333);
    list.push_back (value);
    value.set((int) 667);
    list.push_back (value);
    value.set((int) 833);
    list.push_back (value);
    mOptions[WizardOptions::EH].value().set (CompOption::TypeInt, list);

    // e_dh
    mOptions[WizardOptions::EDh].setName ("e_dh", CompOption::TypeList);
    mOptions[WizardOptions::EDh].rest ().set (0, 500);
    list.clear ();
    value.set((int) 100);
    list.push_back (value);
    value.set((int) 150);
    list.push_back (value);
    value.set((int) 500);
    list.push_back (value);
    value.set((int) 500);
    list.push_back (value);
    value.set((int) 500);
    list.push_back (value);
    value.set((int) 133);
    list.push_back (value);
    value.set((int) 133);
    list.push_back (value);
    value.set((int) 133);
    list.push_back (value);
    value.set((int) 133);
    list.push_back (value);
    value.set((int) 133);
    list.push_back (value);
    mOptions[WizardOptions::EDh].value().set (CompOption::TypeInt, list);

    // e_l
    mOptions[WizardOptions::EL].setName ("e_l", CompOption::TypeList);
    mOptions[WizardOptions::EL].rest ().set (0, 1000);
    list.clear ();
    value.set((int) 450);
    list.push_back (value);
    value.set((int) 600);
    list.push_back (value);
    value.set((int) 650);
    list.push_back (value);
    value.set((int) 650);
    list.push_back (value);
    value.set((int) 650);
    list.push_back (value);
    value.set((int) 650);
    list.push_back (value);
    value.set((int) 650);
    list.push_back (value);
    value.set((int) 650);
    list.push_back (value);
    value.set((int) 650);
    list.push_back (value);
    value.set((int) 650);
    list.push_back (value);
    mOptions[WizardOptions::EL].value().set (CompOption::TypeInt, list);

    // e_dl
    mOptions[WizardOptions::EDl].setName ("e_dl", CompOption::TypeList);
    mOptions[WizardOptions::EDl].rest ().set (0, 1000);
    list.clear ();
    value.set((int) 250);
    list.push_back (value);
    value.set((int) 100);
    list.push_back (value);
    value.set((int) 150);
    list.push_back (value);
    value.set((int) 150);
    list.push_back (value);
    value.set((int) 150);
    list.push_back (value);
    value.set((int) 150);
    list.push_back (value);
    value.set((int) 150);
    list.push_back (value);
    value.set((int) 150);
    list.push_back (value);
    value.set((int) 150);
    list.push_back (value);
    value.set((int) 150);
    list.push_back (value);
    mOptions[WizardOptions::EDl].value().set (CompOption::TypeInt, list);

    // e_a
    mOptions[WizardOptions::EA].setName ("e_a", CompOption::TypeList);
    mOptions[WizardOptions::EA].rest ().set (0, 1000);
    list.clear ();
    value.set((int) 500);
    list.push_back (value);
    value.set((int) 400);
    list.push_back (value);
    value.set((int) 700);
    list.push_back (value);
    value.set((int) 700);
    list.push_back (value);
    value.set((int) 700);
    list.push_back (value);
    value.set((int) 700);
    list.push_back (value);
    value.set((int) 700);
    list.push_back (value);
    value.set((int) 700);
    list.push_back (value);
    value.set((int) 700);
    list.push_back (value);
    value.set((int) 700);
    list.push_back (value);
    mOptions[WizardOptions::EA].value().set (CompOption::TypeInt, list);

    // e_da
    mOptions[WizardOptions::EDa].setName ("e_da", CompOption::TypeList);
    mOptions[WizardOptions::EDa].rest ().set (0, 1000);
    list.clear ();
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 200);
    list.push_back (value);
    mOptions[WizardOptions::EDa].value().set (CompOption::TypeInt, list);

    // e_dx
    mOptions[WizardOptions::EDx].setName ("e_dx", CompOption::TypeList);
    mOptions[WizardOptions::EDx].rest ().set (0, 1500);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 1000);
    list.push_back (value);
    value.set((int) 1000);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    mOptions[WizardOptions::EDx].value().set (CompOption::TypeInt, list);

    // e_dy
    mOptions[WizardOptions::EDy].setName ("e_dy", CompOption::TypeList);
    mOptions[WizardOptions::EDy].rest ().set (0, 1000);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    mOptions[WizardOptions::EDy].value().set (CompOption::TypeInt, list);

    // e_dcirc
    mOptions[WizardOptions::EDcirc].setName ("e_dcirc", CompOption::TypeList);
    mOptions[WizardOptions::EDcirc].rest ().set (0, 1000);
    list.clear ();
    value.set((int) 30);
    list.push_back (value);
    value.set((int) 5);
    list.push_back (value);
    value.set((int) 20);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 5);
    list.push_back (value);
    value.set((int) 5);
    list.push_back (value);
    value.set((int) 5);
    list.push_back (value);
    value.set((int) 5);
    list.push_back (value);
    value.set((int) 5);
    list.push_back (value);
    mOptions[WizardOptions::EDcirc].value().set (CompOption::TypeInt, list);

    // e_vx
    mOptions[WizardOptions::EVx].setName ("e_vx", CompOption::TypeList);
    mOptions[WizardOptions::EVx].rest ().set (-1000, 1000);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    mOptions[WizardOptions::EVx].value().set (CompOption::TypeInt, list);

    // e_vy
    mOptions[WizardOptions::EVy].setName ("e_vy", CompOption::TypeList);
    mOptions[WizardOptions::EVy].rest ().set (-1000, 1000);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    value.set((int) -200);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    mOptions[WizardOptions::EVy].value().set (CompOption::TypeInt, list);

    // e_vt
    mOptions[WizardOptions::EVt].setName ("e_vt", CompOption::TypeList);
    mOptions[WizardOptions::EVt].rest ().set (-1000, -1);
    list.clear ();
    value.set((int) -30);
    list.push_back (value);
    value.set((int) -30);
    list.push_back (value);
    value.set((int) -5);
    list.push_back (value);
    value.set((int) -5);
    list.push_back (value);
    value.set((int) -5);
    list.push_back (value);
    value.set((int) -10);
    list.push_back (value);
    value.set((int) -10);
    list.push_back (value);
    value.set((int) -10);
    list.push_back (value);
    value.set((int) -10);
    list.push_back (value);
    value.set((int) -10);
    list.push_back (value);
    mOptions[WizardOptions::EVt].value().set (CompOption::TypeInt, list);

    // e_vphi
    mOptions[WizardOptions::EVphi].setName ("e_vphi", CompOption::TypeList);
    mOptions[WizardOptions::EVphi].rest ().set (-1000, 1000);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    mOptions[WizardOptions::EVphi].value().set (CompOption::TypeInt, list);

    // e_dvx
    mOptions[WizardOptions::EDvx].setName ("e_dvx", CompOption::TypeList);
    mOptions[WizardOptions::EDvx].rest ().set (-1000, 1000);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    mOptions[WizardOptions::EDvx].value().set (CompOption::TypeInt, list);

    // e_dvy
    mOptions[WizardOptions::EDvy].setName ("e_dvy", CompOption::TypeList);
    mOptions[WizardOptions::EDvy].rest ().set (-1000, 1000);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    mOptions[WizardOptions::EDvy].value().set (CompOption::TypeInt, list);

    // e_dvcirc
    mOptions[WizardOptions::EDvcirc].setName ("e_dvcirc", CompOption::TypeList);
    mOptions[WizardOptions::EDvcirc].rest ().set (0, 1000);
    list.clear ();
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 100);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 500);
    list.push_back (value);
    value.set((int) 500);
    list.push_back (value);
    value.set((int) 500);
    list.push_back (value);
    value.set((int) 500);
    list.push_back (value);
    value.set((int) 500);
    list.push_back (value);
    mOptions[WizardOptions::EDvcirc].value().set (CompOption::TypeInt, list);

    // e_dvt
    mOptions[WizardOptions::EDvt].setName ("e_dvt", CompOption::TypeList);
    mOptions[WizardOptions::EDvt].rest ().set (1, 1000);
    list.clear ();
    value.set((int) 30);
    list.push_back (value);
    value.set((int) 10);
    list.push_back (value);
    value.set((int) 4);
    list.push_back (value);
    value.set((int) 3);
    list.push_back (value);
    value.set((int) 3);
    list.push_back (value);
    value.set((int) 5);
    list.push_back (value);
    value.set((int) 5);
    list.push_back (value);
    value.set((int) 5);
    list.push_back (value);
    value.set((int) 5);
    list.push_back (value);
    value.set((int) 5);
    list.push_back (value);
    mOptions[WizardOptions::EDvt].value().set (CompOption::TypeInt, list);

    // e_dvphi
    mOptions[WizardOptions::EDvphi].setName ("e_dvphi", CompOption::TypeList);
    mOptions[WizardOptions::EDvphi].rest ().set (-1000, 1000);
    list.clear ();
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    mOptions[WizardOptions::EDvphi].value().set (CompOption::TypeInt, list);

    // e_s
    mOptions[WizardOptions::ES].setName ("e_s", CompOption::TypeList);
    mOptions[WizardOptions::ES].rest ().set (0, 1000);
    list.clear ();
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 20);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    mOptions[WizardOptions::ES].value().set (CompOption::TypeInt, list);

    // e_ds
    mOptions[WizardOptions::EDs].setName ("e_ds", CompOption::TypeList);
    mOptions[WizardOptions::EDs].rest ().set (0, 1000);
    list.clear ();
    value.set((int) 25);
    list.push_back (value);
    value.set((int) 10);
    list.push_back (value);
    value.set((int) 25);
    list.push_back (value);
    value.set((int) 25);
    list.push_back (value);
    value.set((int) 25);
    list.push_back (value);
    value.set((int) 25);
    list.push_back (value);
    value.set((int) 25);
    list.push_back (value);
    value.set((int) 25);
    list.push_back (value);
    value.set((int) 25);
    list.push_back (value);
    value.set((int) 25);
    list.push_back (value);
    mOptions[WizardOptions::EDs].value().set (CompOption::TypeInt, list);

    // e_snew
    mOptions[WizardOptions::ESnew].setName ("e_snew", CompOption::TypeList);
    mOptions[WizardOptions::ESnew].rest ().set (0, 1000);
    list.clear ();
    value.set((int) 300);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 100);
    list.push_back (value);
    value.set((int) 125);
    list.push_back (value);
    value.set((int) 125);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    mOptions[WizardOptions::ESnew].value().set (CompOption::TypeInt, list);

    // e_dsnew
    mOptions[WizardOptions::EDsnew].setName ("e_dsnew", CompOption::TypeList);
    mOptions[WizardOptions::EDsnew].rest ().set (0, 1000);
    list.clear ();
    value.set((int) 150);
    list.push_back (value);
    value.set((int) 30);
    list.push_back (value);
    value.set((int) 25);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 50);
    list.push_back (value);
    value.set((int) 25);
    list.push_back (value);
    value.set((int) 25);
    list.push_back (value);
    value.set((int) 25);
    list.push_back (value);
    value.set((int) 25);
    list.push_back (value);
    value.set((int) 25);
    list.push_back (value);
    mOptions[WizardOptions::EDsnew].value().set (CompOption::TypeInt, list);

    // e_g
    mOptions[WizardOptions::EG].setName ("e_g", CompOption::TypeList);
    mOptions[WizardOptions::EG].rest ().set (-1000, 1000);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    mOptions[WizardOptions::EG].value().set (CompOption::TypeInt, list);

    // e_dg
    mOptions[WizardOptions::EDg].setName ("e_dg", CompOption::TypeList);
    mOptions[WizardOptions::EDg].rest ().set (-1000, 1000);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 200);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    mOptions[WizardOptions::EDg].value().set (CompOption::TypeInt, list);

    // e_gp
    mOptions[WizardOptions::EGp].setName ("e_gp", CompOption::TypeList);
    mOptions[WizardOptions::EGp].rest ().set (0, 10000);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 10);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    value.set((int) 0);
    list.push_back (value);
    mOptions[WizardOptions::EGp].value().set (CompOption::TypeInt, list);

    // hard_limit
    mOptions[WizardOptions::HardLimit].setName ("hard_limit", CompOption::TypeInt);
    mOptions[WizardOptions::HardLimit].rest ().set (100, 5000);
    mOptions[WizardOptions::HardLimit].value().set((int) 3000);

    // soft_limit
    mOptions[WizardOptions::SoftLimit].setName ("soft_limit", CompOption::TypeInt);
    mOptions[WizardOptions::SoftLimit].rest ().set (100, 5000);
    mOptions[WizardOptions::SoftLimit].value().set((int) 2000);

    // darken
    mOptions[WizardOptions::Darken].setName ("darken", CompOption::TypeFloat);
    mOptions[WizardOptions::Darken].rest ().set (0.0, 1.0, 0.1);
    mOptions[WizardOptions::Darken].value().set((float) 0.9);

    // blend
    mOptions[WizardOptions::Blend].setName ("blend", CompOption::TypeBool);
    mOptions[WizardOptions::Blend].value().set(true);

    // tnew
    mOptions[WizardOptions::Tnew].setName ("tnew", CompOption::TypeFloat);
    mOptions[WizardOptions::Tnew].rest ().set (0.0, 1.0, 0.01);
    mOptions[WizardOptions::Tnew].value().set((float) 0.98);

    // told
    mOptions[WizardOptions::Told].setName ("told", CompOption::TypeFloat);
    mOptions[WizardOptions::Told].rest ().set (0.0, 1.0, 0.01);
    mOptions[WizardOptions::Told].value().set((float) 0.4);

    mGMovementMask = 0;
    foreach (CompOption::Value &val, mOptions[WizardOptions::GMovement].value ().list ())
        mGMovementMask |= (1 << val.i ());

    mETriggerMask = 0;
    foreach (CompOption::Value &val, mOptions[WizardOptions::ETrigger].value ().list ())
        mETriggerMask |= (1 << val.i ());

    mEMovementMask = 0;
    foreach (CompOption::Value &val, mOptions[WizardOptions::EMovement].value ().list ())
        mEMovementMask |= (1 << val.i ());

}

WizardOptions::~WizardOptions ()
{
}


CompOption::Vector &
WizardOptions::getOptions ()
{
    return mOptions;
}

bool
WizardOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case WizardOptions::Toggle:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::Toggle].empty ())
                    mNotify[WizardOptions::Toggle] (o, WizardOptions::Toggle);
                return true;
            }
            break;
        case WizardOptions::Gx:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::Gx].empty ())
                    mNotify[WizardOptions::Gx] (o, WizardOptions::Gx);
                return true;
            }
            break;
        case WizardOptions::Gy:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::Gy].empty ())
                    mNotify[WizardOptions::Gy] (o, WizardOptions::Gy);
                return true;
            }
            break;
        case WizardOptions::GStrength:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::GStrength].empty ())
                    mNotify[WizardOptions::GStrength] (o, WizardOptions::GStrength);
                return true;
            }
            break;
        case WizardOptions::GPosx:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::GPosx].empty ())
                    mNotify[WizardOptions::GPosx] (o, WizardOptions::GPosx);
                return true;
            }
            break;
        case WizardOptions::GPosy:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::GPosy].empty ())
                    mNotify[WizardOptions::GPosy] (o, WizardOptions::GPosy);
                return true;
            }
            break;
        case WizardOptions::GSpeed:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::GSpeed].empty ())
                    mNotify[WizardOptions::GSpeed] (o, WizardOptions::GSpeed);
                return true;
            }
            break;
        case WizardOptions::GAngle:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::GAngle].empty ())
                    mNotify[WizardOptions::GAngle] (o, WizardOptions::GAngle);
                return true;
            }
            break;
        case WizardOptions::GMovement:
            if (o->set (value))
            {
                mGMovementMask = 0;
                foreach (CompOption::Value &val, o->value ().list ())
                    mGMovementMask |= (1 << val.i ());
                if (!mNotify[WizardOptions::GMovement].empty ())
                    mNotify[WizardOptions::GMovement] (o, WizardOptions::GMovement);
                return true;
            }
            break;
        case WizardOptions::EActive:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EActive].empty ())
                    mNotify[WizardOptions::EActive] (o, WizardOptions::EActive);
                return true;
            }
            break;
        case WizardOptions::EName:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EName].empty ())
                    mNotify[WizardOptions::EName] (o, WizardOptions::EName);
                return true;
            }
            break;
        case WizardOptions::ETrigger:
            if (o->set (value))
            {
                mETriggerMask = 0;
                foreach (CompOption::Value &val, o->value ().list ())
                    mETriggerMask |= (1 << val.i ());
                if (!mNotify[WizardOptions::ETrigger].empty ())
                    mNotify[WizardOptions::ETrigger] (o, WizardOptions::ETrigger);
                return true;
            }
            break;
        case WizardOptions::EPosx:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EPosx].empty ())
                    mNotify[WizardOptions::EPosx] (o, WizardOptions::EPosx);
                return true;
            }
            break;
        case WizardOptions::EPosy:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EPosy].empty ())
                    mNotify[WizardOptions::EPosy] (o, WizardOptions::EPosy);
                return true;
            }
            break;
        case WizardOptions::ESpeed:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::ESpeed].empty ())
                    mNotify[WizardOptions::ESpeed] (o, WizardOptions::ESpeed);
                return true;
            }
            break;
        case WizardOptions::EAngle:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EAngle].empty ())
                    mNotify[WizardOptions::EAngle] (o, WizardOptions::EAngle);
                return true;
            }
            break;
        case WizardOptions::EMovement:
            if (o->set (value))
            {
                mEMovementMask = 0;
                foreach (CompOption::Value &val, o->value ().list ())
                    mEMovementMask |= (1 << val.i ());
                if (!mNotify[WizardOptions::EMovement].empty ())
                    mNotify[WizardOptions::EMovement] (o, WizardOptions::EMovement);
                return true;
            }
            break;
        case WizardOptions::ECount:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::ECount].empty ())
                    mNotify[WizardOptions::ECount] (o, WizardOptions::ECount);
                return true;
            }
            break;
        case WizardOptions::EH:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EH].empty ())
                    mNotify[WizardOptions::EH] (o, WizardOptions::EH);
                return true;
            }
            break;
        case WizardOptions::EDh:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EDh].empty ())
                    mNotify[WizardOptions::EDh] (o, WizardOptions::EDh);
                return true;
            }
            break;
        case WizardOptions::EL:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EL].empty ())
                    mNotify[WizardOptions::EL] (o, WizardOptions::EL);
                return true;
            }
            break;
        case WizardOptions::EDl:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EDl].empty ())
                    mNotify[WizardOptions::EDl] (o, WizardOptions::EDl);
                return true;
            }
            break;
        case WizardOptions::EA:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EA].empty ())
                    mNotify[WizardOptions::EA] (o, WizardOptions::EA);
                return true;
            }
            break;
        case WizardOptions::EDa:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EDa].empty ())
                    mNotify[WizardOptions::EDa] (o, WizardOptions::EDa);
                return true;
            }
            break;
        case WizardOptions::EDx:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EDx].empty ())
                    mNotify[WizardOptions::EDx] (o, WizardOptions::EDx);
                return true;
            }
            break;
        case WizardOptions::EDy:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EDy].empty ())
                    mNotify[WizardOptions::EDy] (o, WizardOptions::EDy);
                return true;
            }
            break;
        case WizardOptions::EDcirc:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EDcirc].empty ())
                    mNotify[WizardOptions::EDcirc] (o, WizardOptions::EDcirc);
                return true;
            }
            break;
        case WizardOptions::EVx:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EVx].empty ())
                    mNotify[WizardOptions::EVx] (o, WizardOptions::EVx);
                return true;
            }
            break;
        case WizardOptions::EVy:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EVy].empty ())
                    mNotify[WizardOptions::EVy] (o, WizardOptions::EVy);
                return true;
            }
            break;
        case WizardOptions::EVt:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EVt].empty ())
                    mNotify[WizardOptions::EVt] (o, WizardOptions::EVt);
                return true;
            }
            break;
        case WizardOptions::EVphi:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EVphi].empty ())
                    mNotify[WizardOptions::EVphi] (o, WizardOptions::EVphi);
                return true;
            }
            break;
        case WizardOptions::EDvx:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EDvx].empty ())
                    mNotify[WizardOptions::EDvx] (o, WizardOptions::EDvx);
                return true;
            }
            break;
        case WizardOptions::EDvy:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EDvy].empty ())
                    mNotify[WizardOptions::EDvy] (o, WizardOptions::EDvy);
                return true;
            }
            break;
        case WizardOptions::EDvcirc:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EDvcirc].empty ())
                    mNotify[WizardOptions::EDvcirc] (o, WizardOptions::EDvcirc);
                return true;
            }
            break;
        case WizardOptions::EDvt:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EDvt].empty ())
                    mNotify[WizardOptions::EDvt] (o, WizardOptions::EDvt);
                return true;
            }
            break;
        case WizardOptions::EDvphi:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EDvphi].empty ())
                    mNotify[WizardOptions::EDvphi] (o, WizardOptions::EDvphi);
                return true;
            }
            break;
        case WizardOptions::ES:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::ES].empty ())
                    mNotify[WizardOptions::ES] (o, WizardOptions::ES);
                return true;
            }
            break;
        case WizardOptions::EDs:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EDs].empty ())
                    mNotify[WizardOptions::EDs] (o, WizardOptions::EDs);
                return true;
            }
            break;
        case WizardOptions::ESnew:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::ESnew].empty ())
                    mNotify[WizardOptions::ESnew] (o, WizardOptions::ESnew);
                return true;
            }
            break;
        case WizardOptions::EDsnew:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EDsnew].empty ())
                    mNotify[WizardOptions::EDsnew] (o, WizardOptions::EDsnew);
                return true;
            }
            break;
        case WizardOptions::EG:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EG].empty ())
                    mNotify[WizardOptions::EG] (o, WizardOptions::EG);
                return true;
            }
            break;
        case WizardOptions::EDg:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EDg].empty ())
                    mNotify[WizardOptions::EDg] (o, WizardOptions::EDg);
                return true;
            }
            break;
        case WizardOptions::EGp:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::EGp].empty ())
                    mNotify[WizardOptions::EGp] (o, WizardOptions::EGp);
                return true;
            }
            break;
        case WizardOptions::HardLimit:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::HardLimit].empty ())
                    mNotify[WizardOptions::HardLimit] (o, WizardOptions::HardLimit);
                return true;
            }
            break;
        case WizardOptions::SoftLimit:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::SoftLimit].empty ())
                    mNotify[WizardOptions::SoftLimit] (o, WizardOptions::SoftLimit);
                return true;
            }
            break;
        case WizardOptions::Darken:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::Darken].empty ())
                    mNotify[WizardOptions::Darken] (o, WizardOptions::Darken);
                return true;
            }
            break;
        case WizardOptions::Blend:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::Blend].empty ())
                    mNotify[WizardOptions::Blend] (o, WizardOptions::Blend);
                return true;
            }
            break;
        case WizardOptions::Tnew:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::Tnew].empty ())
                    mNotify[WizardOptions::Tnew] (o, WizardOptions::Tnew);
                return true;
            }
            break;
        case WizardOptions::Told:
            if (o->set (value))
            {
                if (!mNotify[WizardOptions::Told].empty ())
                    mNotify[WizardOptions::Told] (o, WizardOptions::Told);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

