/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.audio.ui;

import blue.components.AlphaMarquee;
import blue.score.ScoreObject;
import blue.score.TimeState;
import blue.score.layers.Layer;
import blue.score.layers.LayerGroup;
import blue.score.layers.LayerGroupDataEvent;
import blue.score.layers.LayerGroupListener;
import blue.score.layers.audio.core.AudioClip;
import blue.score.layers.audio.core.AudioLayer;
import blue.score.layers.audio.core.AudioLayerGroup;
import blue.score.layers.audio.core.AudioLayerListener;
import blue.score.layers.audio.ui.AudioClipPanel;
import blue.score.layers.audio.ui.AudioLayerGroupUtils;
import blue.score.layers.audio.ui.AudioLayersDropTargetListener;
import blue.ui.core.score.ScoreObjectView;
import blue.ui.core.score.layers.LayerGroupPanel;
import blue.ui.core.score.layers.SelectionMarquee;
import blue.ui.core.score.layers.soundObject.AutomationLayerPanel;
import blue.ui.utilities.ParentDispatchingMouseAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.openide.util.Utilities;
import org.openide.util.lookup.InstanceContent;

public class AudioLayersPanel
extends JLayeredPane
implements LayerGroupListener,
PropertyChangeListener,
LayerGroupPanel<AudioLayerGroup>,
AudioLayerListener {
    private static Font renderFont = new Font("Dialog", 1, 12);
    private static final Color PATTERN_COLOR = new Color(198, 226, 255);
    private AudioLayerGroup layerGroup;
    private final TimeState timeState;
    private PropertyChangeListener heightListener;
    AffineTransform transform = new AffineTransform();
    AffineTransform reverseTransform = new AffineTransform();
    double[] srcPts = new double[4];
    double[] destPts = new double[4];
    Map<AudioClip, AudioClipPanel> clipPanelMap = new HashMap<AudioClip, AudioClipPanel>();
    private final InstanceContent content;
    AutomationLayerPanel automationPanel = new AutomationLayerPanel(new AlphaMarquee());
    BiConsumer<AudioClip, Double> splitHandler = (ac, time) -> {
        int layerNum = this.layerGroup.getLayerNumForScoreObject((ScoreObject)ac);
        AudioLayer layer = (AudioLayer)this.layerGroup.get(layerNum);
        AudioLayerGroupUtils.splitAudioClip(layer, ac, time);
    };

    public AudioLayersPanel(AudioLayerGroup layerGroup, TimeState timeState, InstanceContent content) {
        this.setLayout(null);
        this.layerGroup = layerGroup;
        this.timeState = timeState;
        this.content = content;
        this.transform.setToIdentity();
        this.transform.setToScale(timeState.getPixelSecond(), 1.0);
        this.reverseTransform.setToIdentity();
        this.reverseTransform.setToScale(1 / timeState.getPixelSecond(), 1.0);
        Dimension d = this.checkSize();
        this.setSize(d);
        this.setBackground(Color.BLACK);
        this.addMouseWheelListener(mwe -> mwe.getComponent().getParent().dispatchEvent(mwe));
        new AudioLayersDropTargetListener(this);
        this.heightListener = evt -> {
            this.checkSize();
            this.updateAudioClipYandHeight();
        };
        int y = 0;
        for (AudioLayer layer : layerGroup) {
            int height = layer.getAudioLayerHeight();
            for (AudioClip clip : layer) {
                this.addClipPanel(clip, timeState, y, height);
            }
            y += height;
        }
        ParentDispatchingMouseAdapter mouseAdapter = new ParentDispatchingMouseAdapter((Component)this);
        this.addMouseListener((MouseListener)mouseAdapter);
        this.addMouseMotionListener((MouseMotionListener)mouseAdapter);
        this.addMouseWheelListener((MouseWheelListener)mouseAdapter);
        this.automationPanel.setLayerGroup((LayerGroup)layerGroup, timeState);
        this.automationPanel.setSize(this.getSize());
        this.add((Component)this.automationPanel, MODAL_LAYER);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AudioLayersPanel.this.automationPanel.setSize(AudioLayersPanel.this.getSize());
            }
        });
    }

    public AudioLayerGroup getAudioLayerGroup() {
        return this.layerGroup;
    }

    public TimeState getTimeState() {
        return this.timeState;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.layerGroup == null) {
            return;
        }
        this.layerGroup.addLayerGroupListener((LayerGroupListener)this);
        this.timeState.addPropertyChangeListener((PropertyChangeListener)this);
        for (AudioLayer layer : this.layerGroup) {
            layer.addPropertyChangeListener(this.heightListener);
            layer.addAudioLayerListener((AudioLayerListener)this);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.layerGroup.removeLayerGroupListener((LayerGroupListener)this);
        this.timeState.removePropertyChangeListener((PropertyChangeListener)this);
        for (AudioLayer layer : this.layerGroup) {
            layer.removePropertyChangeListener(this.heightListener);
            layer.removeAudioLayerListener((AudioLayerListener)this);
        }
    }

    public void layerGroupChanged(final LayerGroupDataEvent event) {
        final ArrayList layers = event.getLayers();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (event.getType() == 0) {
                    for (Layer layer : layers) {
                        ((AudioLayer)layer).addPropertyChangeListener(AudioLayersPanel.this.heightListener);
                        ((AudioLayer)layer).addAudioLayerListener((AudioLayerListener)AudioLayersPanel.this);
                        for (AudioClip clip : (AudioLayer)layer) {
                            AudioLayersPanel.this.addClipPanel(clip, AudioLayersPanel.this.timeState, 0, 0);
                        }
                    }
                } else if (event.getType() == 1) {
                    for (Layer layer : layers) {
                        ((AudioLayer)layer).removePropertyChangeListener(AudioLayersPanel.this.heightListener);
                        ((AudioLayer)layer).removeAudioLayerListener((AudioLayerListener)AudioLayersPanel.this);
                        for (AudioClip clip : (AudioLayer)layer) {
                            AudioLayersPanel.this.removeClipPanel(clip);
                        }
                    }
                }
                AudioLayersPanel.this.updateAudioClipYandHeight();
                AudioLayersPanel.this.checkSize();
                AudioLayersPanel.this.repaint();
            }
        });
    }

    protected Dimension checkSize() {
        int h = this.layerGroup.getTotalHeight();
        int tempTime = (int)(this.layerGroup.getMaxTime() / 60.0) + 2;
        int width = tempTime * this.timeState.getPixelSecond() * 60;
        Dimension d = new Dimension(width, h);
        this.setPreferredSize(d);
        return d;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.timeState) {
            String prop;
            switch (prop = evt.getPropertyName()) {
                case "pixelSecond": {
                    this.checkSize();
                    this.transform.setToIdentity();
                    this.transform.setToScale(this.timeState.getPixelSecond(), 1.0);
                    this.reverseTransform.setToIdentity();
                    this.reverseTransform.setToScale(1 / this.timeState.getPixelSecond(), 1.0);
                    break;
                }
                case "snapEnabled": 
                case "snapValue": {
                    this.repaint();
                }
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintAudioLayersBackground(g);
    }

    public void marqueeSelectionPerformed(SelectionMarquee marquee) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof AudioClipPanel) || !marquee.intersects((JComponent)comps[i])) continue;
            this.content.add((Object)((AudioClipPanel)comps[i]).getScoreObject());
        }
    }

    public void paintNavigatorView(Graphics2D g2d) {
        Component[] components;
        for (Component c : components = this.getComponents()) {
            AudioClipPanel component = (AudioClipPanel)c;
            Rectangle r = component.getBounds();
            g2d.setColor(component.getScoreObject().getBackgroundColor());
            g2d.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    private void paintAudioLayersBackground(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, width, height);
        int y = 0;
        g.setColor(Color.DARK_GRAY);
        g.drawLine(0, 0, width, 0);
        for (AudioLayer layer : this.layerGroup) {
            g.drawLine(0, y += layer.getAudioLayerHeight(), width, y);
        }
        g.drawLine(0, this.getHeight() - 1, width, height - 1);
        if (this.timeState.isSnapEnabled()) {
            int snapPixels = (int)(this.timeState.getSnapValue() * (double)this.timeState.getPixelSecond());
            int x = 0;
            if (snapPixels <= 0) {
                return;
            }
            double snapValue = this.timeState.getSnapValue();
            int pixelSecond = this.timeState.getPixelSecond();
            int i = 0;
            while (x < this.getWidth()) {
                x = (int)((double)i * snapValue * (double)pixelSecond);
                g.drawLine(x, 0, x, height);
                ++i;
            }
        }
    }

    protected Rectangle getAudioLayerRect(AudioLayer layer) {
        int y = 0;
        for (AudioLayer temp : this.layerGroup) {
            if (layer == temp) {
                return new Rectangle(0, y, 0, temp.getAudioLayerHeight());
            }
            y += temp.getAudioLayerHeight();
        }
        return null;
    }

    public void audioClipAdded(AudioLayer source, AudioClip clip) {
        SwingUtilities.invokeLater(() -> {
            Rectangle rect = this.getAudioLayerRect(source);
            this.addClipPanel(clip, this.timeState, rect.y, rect.height);
            this.checkSize();
            this.repaint();
        });
    }

    public void audioClipRemoved(AudioLayer source, final AudioClip clip) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AudioLayersPanel.this.removeClipPanel(clip);
                AudioLayersPanel.this.checkSize();
                AudioLayersPanel.this.repaint();
            }
        });
    }

    private void addClipPanel(AudioClip clip, TimeState timeState, int y, int height) {
        AudioClipPanel panel = new AudioClipPanel(clip, timeState, this.splitHandler);
        panel.setBounds(panel.getX(), y, panel.getWidth(), height);
        this.add((Component)panel, DEFAULT_LAYER);
        this.clipPanelMap.put(clip, panel);
    }

    private void removeClipPanel(AudioClip clip) {
        AudioClipPanel panel = this.clipPanelMap.get(clip);
        this.remove(panel);
        this.clipPanelMap.remove(clip);
    }

    private void updateAudioClipYandHeight() {
        int y = 0;
        int height = 0;
        for (AudioLayer layer : this.layerGroup) {
            height = layer.getAudioLayerHeight();
            for (AudioClip clip : layer) {
                AudioClipPanel panel = this.clipPanelMap.get(clip);
                panel.setBounds(new Rectangle(panel.getX(), y, panel.getWidth(), height));
            }
            y += height;
        }
    }

    public ScoreObjectView<?> getScoreObjectViewAtPoint(Point p) {
        for (Component c : this.getComponentsInLayer(DEFAULT_LAYER)) {
            if (!(c instanceof ScoreObjectView) || !c.contains(p.x - c.getX(), p.y - c.getY())) continue;
            return (ScoreObjectView)c;
        }
        return null;
    }

    public Action[] getLayerActions() {
        List list = Utilities.actionsForPath((String)"blue/score/layers/audio/actions");
        return list.toArray(new Action[0]);
    }

    public AudioLayerGroup getLayerGroup() {
        return this.layerGroup;
    }
}

