/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.ceciliaModule.cybil;

import blue.BlueSystem;
import blue.soundObject.CeciliaModule;
import blue.soundObject.ceciliaModule.CGraph;
import blue.soundObject.ceciliaModule.cybil.CybilArg;
import blue.soundObject.ceciliaModule.cybil.CybilNode;
import blue.soundObject.ceciliaModule.cybil.CybilNoteList;
import blue.soundObject.ceciliaModule.cybil.CybilOperator;
import blue.soundObject.ceciliaModule.cybil.co;
import blue.soundObject.ceciliaModule.cybil.gr;
import blue.soundObject.ceciliaModule.cybil.li;
import blue.soundObject.ceciliaModule.cybil.lo;
import blue.soundObject.ceciliaModule.cybil.ma;
import blue.soundObject.ceciliaModule.cybil.pa;
import blue.soundObject.ceciliaModule.cybil.pik;
import blue.soundObject.ceciliaModule.cybil.ran;
import blue.soundObject.ceciliaModule.cybil.sq;
import blue.utility.TextUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class CybilCompiler {
    public static String compile(String cybilScore, CeciliaModule cm) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(cybilScore, "\n");
        while (st.hasMoreTokens()) {
            String line = CybilCompiler.stripComments(st.nextToken());
            if (line.startsWith("instr")) {
                String instrLine;
                line = line.substring(5);
                StringTokenizer instrIds = new StringTokenizer(line);
                StringBuffer instrBuffer = new StringBuffer();
                while (!(instrLine = st.nextToken()).equals("e")) {
                    String cleanLine = CybilCompiler.stripComments(instrLine);
                    if (cleanLine.length() <= 0) continue;
                    instrBuffer.append(cleanLine).append("\n");
                }
                String instrBody = instrBuffer.toString();
                while (instrIds.hasMoreTokens()) {
                    String instrumentId = instrIds.nextToken();
                    buffer.append(CybilCompiler.compileInstrument(instrumentId, instrBody, cm));
                }
                continue;
            }
            buffer.append(line).append("\n");
        }
        return buffer.toString();
    }

    private static String stripComments(String line) {
        int index = line.indexOf(";");
        String retVal = line;
        if (index > -1) {
            retVal = retVal.substring(0, index);
        }
        return retVal.trim();
    }

    private static String compileInstrument(String instrumentId, String instrBody, CeciliaModule cm) {
        StringTokenizer st = new StringTokenizer(instrBody, "\n");
        int numPfields = st.countTokens() + 1;
        CybilNoteList cybNoteList = new CybilNoteList();
        cybNoteList.instrumentId = instrumentId;
        cybNoteList.numPfields = numPfields;
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            line = TextUtilities.replaceAll((String)line, (String)"\t", (String)" ");
            int pField = CybilCompiler.getPField(line);
            ArrayList commands = CybilCompiler.splitCommands(line);
            cybNoteList.pfield = pField;
            cybNoteList.index = 0;
            int startIndex = 0;
            int endIndex = 0;
            Iterator iter = commands.iterator();
            while (iter.hasNext()) {
                String command = (String)iter.next();
                if (CybilCompiler.isOperator(command)) {
                    System.out.println("Operator found: " + command);
                    String nextCommand = (String)iter.next();
                    CybilArg arg = CybilCompiler.compileArg(cybNoteList, nextCommand, cm);
                    CybilOperator.process(command, cybNoteList, startIndex, endIndex, arg);
                    continue;
                }
                startIndex = cybNoteList.index;
                CybilCompiler.processCommand(cybNoteList, command, cm);
                endIndex = cybNoteList.index;
            }
        }
        return cybNoteList.notes.toString();
    }

    private static ArrayList splitCommands(String line) {
        ArrayList<String> commands = new ArrayList<String>();
        int counter = 0;
        int firstBrace = 0;
        for (int index = 0; index < line.length(); ++index) {
            char c = line.charAt(index);
            if (c == '{') {
                if (counter == 0) {
                    firstBrace = index;
                }
                ++counter;
                continue;
            }
            if (c == '}') {
                if (--counter != 0) continue;
                commands.add(line.substring(firstBrace, index + 1));
                continue;
            }
            if (!CybilCompiler.isOperator(c) || counter != 0) continue;
            commands.add(c + "");
        }
        return commands;
    }

    private static boolean isOperator(char c) {
        return CybilCompiler.isOperator(Character.toString(c));
    }

    private static boolean isOperator(String c) {
        if (c.length() != 1) {
            return false;
        }
        return c.equals("+") || c.equals("-") || c.equals("*") || c.equals("/");
    }

    private static void processCommand(CybilNoteList cybNoteList, String commandBody, CeciliaModule cm) {
        CybilArg arg = CybilCompiler.compileArg(cybNoteList, commandBody, cm);
        arg.getValue(cybNoteList);
    }

    private static CybilArg compileArg(CybilNoteList cybNoteList, String commandBody, CeciliaModule cm) {
        String spacedLine = CybilCompiler.spaceLine(commandBody);
        StringTokenizer st = new StringTokenizer(spacedLine);
        String[] tokens = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            tokens[i] = st.nextToken();
            ++i;
        }
        CybilNode node = new CybilNode();
        CybilCompiler.parseNodes(node, tokens, 1);
        CybilArg arg = CybilCompiler.compileNode(node, cybNoteList, cm);
        return arg;
    }

    private static CybilArg compileNode(CybilNode node, CybilNoteList cybNoteList, CeciliaModule cm) {
        ArrayList args = node.args;
        CybilArg retArg = null;
        retArg = CybilCompiler.createCybilArg((String)args.get(0));
        if (retArg != null) {
            for (int i = 1; i < args.size(); ++i) {
                Object obj = args.get(i);
                if (obj instanceof CybilNode) {
                    retArg.args.add(CybilCompiler.compileNode((CybilNode)obj, cybNoteList, cm));
                    continue;
                }
                retArg.args.add(obj);
            }
            if (retArg instanceof gr) {
                String graphName = (String)retArg.args.get(0);
                CGraph cGraph = (CGraph)cm.getStateData().get(graphName);
                ((gr)retArg).setCGraph(cGraph);
            }
        }
        return retArg;
    }

    private static CybilArg createCybilArg(String argName) {
        switch (argName) {
            case "sq": {
                return new sq();
            }
            case "li": {
                return new li();
            }
            case "lo": {
                return new lo();
            }
            case "ma": {
                return new ma();
            }
            case "gr": {
                return new gr();
            }
            case "ran": {
                return new ran();
            }
            case "pik": {
                return new pik();
            }
            case "pa": {
                return new pa();
            }
            case "co": {
                return new co();
            }
        }
        String errMessage = "[" + BlueSystem.getString((String)"message.error") + "] - " + BlueSystem.getString((String)"common.noClassFound") + " ";
        System.err.println(errMessage + argName);
        return null;
    }

    private static int parseNodes(CybilNode node, String[] tokens, int index) {
        int i;
        for (i = index; !tokens[i].equals("}") && i < tokens.length; ++i) {
            if (tokens[i].equals("{")) {
                int newIndex;
                CybilNode newNode = new CybilNode();
                node.args.add(newNode);
                i = newIndex = CybilCompiler.parseNodes(newNode, tokens, i + 1);
                continue;
            }
            node.args.add(tokens[i]);
        }
        return i;
    }

    private static String spaceLine(String line) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '{' || c == '}') {
                buffer.append(" ").append(c).append(" ");
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static int getPField(String line) {
        StringBuffer pfieldText = new StringBuffer();
        int index = line.indexOf("p") + 1;
        while (line.charAt(index) == ' ' || line.charAt(index) == '\t') {
            ++index;
        }
        while (line.charAt(index) != ' ' && line.charAt(index) != '\t' && line.charAt(index) != '\n') {
            pfieldText.append(line.charAt(index));
            ++index;
        }
        return Integer.parseInt(pfieldText.toString());
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("No file given");
            System.exit(1);
        }
    }
}

