/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.ceciliaModule;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

class Thumb
extends JComponent {
    Border NORMAL_BORDER = BorderFactory.createBevelBorder(0, UIManager.getColor("ScrollBar.trackHighlight"), Color.BLACK);
    Border DOWN_BORDER = BorderFactory.createBevelBorder(1, UIManager.getColor("ScrollBar.trackHighlight"), Color.BLACK);
    Point origin = null;
    private boolean isEditingValue = false;

    public Thumb() {
        Dimension d = new Dimension(30, 12);
        this.setPreferredSize(d);
        this.setSize(d);
        this.setBorder(this.NORMAL_BORDER);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Thumb.this.origin = e.getPoint();
                Thumb.this.setBorder(Thumb.this.DOWN_BORDER);
                Thumb.this.setEditingValue(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Thumb.this.origin = null;
                Thumb.this.setBorder(Thumb.this.NORMAL_BORDER);
                Thumb.this.setEditingValue(false);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Thumb.this.moveThumb(e.getX(), e.getY());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private void moveThumb(int x, int y) {
        if (this.getParent() == null) {
            return;
        }
        int xVal = SwingUtilities.convertPoint((Component)this, (int)x, (int)y, (Component)this.getParent()).x;
        int newX = xVal - this.origin.x;
        int max = this.getParent().getWidth() - 30 - 1;
        if (newX < 1) {
            newX = 1;
        }
        if (newX > max) {
            newX = max;
        }
        this.setLocation(newX, this.getY());
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
    }

    public boolean isEditingValue() {
        return this.isEditingValue;
    }

    public void setEditingValue(boolean isEditingValue) {
        this.isEditingValue = isEditingValue;
    }
}

