/*
 * Decompiled with CFR 0.152.
 */
package blue.components.lines;

import electric.xml.Element;
import java.util.Vector;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LinePoint
implements Comparable<LinePoint> {
    private DoubleProperty x = new SimpleDoubleProperty(0.0);
    private DoubleProperty y = new SimpleDoubleProperty(0.0);
    private transient Vector listeners = null;
    private transient ChangeEvent changeEvent = new ChangeEvent(this);

    public LinePoint() {
    }

    public LinePoint(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public LinePoint(LinePoint lp) {
        this.setX(lp.getX());
        this.setY(lp.getY());
    }

    public static LinePoint loadFromXML(Element data) {
        LinePoint lp = new LinePoint();
        double x = Double.parseDouble(data.getAttributeValue("x"));
        double y = Double.parseDouble(data.getAttributeValue("y"));
        lp.setLocation(x, y);
        return lp;
    }

    public Element saveAsXML() {
        Element retVal = new Element("linePoint");
        retVal.setAttribute("x", Double.toString(this.getX()));
        retVal.setAttribute("y", Double.toString(this.getY()));
        return retVal;
    }

    @Override
    public int compareTo(LinePoint b) {
        LinePoint a = this;
        double val = a.getX() - b.getX();
        if (val > 0.0) {
            return 1;
        }
        if (val < 0.0) {
            return -1;
        }
        return 0;
    }

    public void setLocation(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public final void setX(double value) {
        this.fireChangeEvent(this.changeEvent);
        this.x.set(value);
    }

    public final double getX() {
        return this.x.get();
    }

    public final DoubleProperty xProperty() {
        return this.x;
    }

    public final void setY(double value) {
        this.y.set(value);
        this.fireChangeEvent(this.changeEvent);
    }

    public final double getY() {
        return this.y.get();
    }

    public final DoubleProperty yProperty() {
        return this.y;
    }

    public void addChangeListener(ChangeListener pcl) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(pcl);
    }

    public void removeChangeListener(ChangeListener pcl) {
        if (this.listeners != null) {
            this.listeners.remove(pcl);
        }
    }

    public void fireChangeEvent(ChangeEvent pce) {
        if (this.listeners != null) {
            for (ChangeListener pcl : this.listeners) {
                pcl.stateChanged(pce);
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LinePoint)) {
            return false;
        }
        LinePoint b = (LinePoint)obj;
        return this.getX() == b.getX() && this.getY() == b.getY();
    }
}

