/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.BlueSystem;
import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorException;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import electric.xml.Element;

public class InversionProcessor
implements NoteProcessor {
    double value = 10.0;
    int pfield = 4;

    public InversionProcessor() {
    }

    public InversionProcessor(InversionProcessor ip) {
        this.value = ip.value;
        this.pfield = ip.pfield;
    }

    public String toString() {
        return "[inversion]";
    }

    public String getPfield() {
        return Integer.toString(this.pfield);
    }

    public void setPfield(String pfield) {
        this.pfield = Integer.parseInt(pfield);
    }

    public String getVal() {
        return Double.toString(this.value);
    }

    public void setVal(String value) {
        this.value = Double.parseDouble(value);
    }

    @Override
    public final void processNotes(NoteList in) throws NoteProcessorException {
        for (int i = 0; i < in.size(); ++i) {
            Note temp = (Note)in.get(i);
            try {
                double fieldVal = Double.parseDouble(temp.getPField(this.pfield));
                double addVal = -1.0 * (fieldVal - this.value);
                temp.setPField(Double.toString(this.value + addVal), this.pfield);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.pfieldNotDouble"), this.pfield);
            }
            catch (Exception ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.missingPfield"), this.pfield);
            }
        }
    }

    public static void main(String[] args) {
        NoteList n = new NoteList();
        for (int i = 0; i < 10; ++i) {
            try {
                n.add(Note.createNote("i1 " + i * 2 + " 2 3 4"));
                continue;
            }
            catch (NoteParseException e) {
                e.printStackTrace();
            }
        }
        System.out.println("before: \n\n" + n + "\n\n");
        InversionProcessor ap = new InversionProcessor();
        ap.setPfield("4");
        ap.setVal("1");
        try {
            ap.processNotes(n);
        }
        catch (NoteProcessorException ex) {
            System.out.println("Exception: " + ex.getMessage());
        }
        System.out.println("after: \n\n" + n + "\n\n");
    }

    public static NoteProcessor loadFromXML(Element data) {
        InversionProcessor ip = new InversionProcessor();
        ip.setPfield(data.getElement("pfield").getTextString());
        ip.setVal(data.getElement("value").getTextString());
        return ip;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("noteProcessor");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement("pfield").setText(this.getPfield());
        retVal.addElement("value").setText(this.getVal());
        return retVal;
    }

    @Override
    public InversionProcessor deepCopy() {
        return new InversionProcessor(this);
    }
}

