/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.automation.Parameter;
import blue.automation.ParameterListener;
import blue.automation.ParameterTimeManagerFactory;
import blue.orchestra.blueSynthBuilder.AutomatableBSBObject;
import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBFontUtil;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.ClampedValue;
import blue.orchestra.blueSynthBuilder.ClampedValueListener;
import blue.orchestra.blueSynthBuilder.Randomizable;
import blue.utility.NumberUtilities;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.math.BigDecimal;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.text.Font;

public class BSBKnob
extends AutomatableBSBObject
implements ParameterListener,
Randomizable {
    ClampedValueListener cvl = (pType, bType) -> {
        Parameter p;
        if (this.parameters != null && (p = this.parameters.getParameter(this.getObjectName())) != null) {
            this.updateParameter(this.knobValueProperty(), p, pType, bType);
        }
    };
    private ClampedValue knobValue;
    private IntegerProperty knobWidth = new SimpleIntegerProperty(60);
    private BooleanProperty randomizable = new SimpleBooleanProperty(true);
    private BooleanProperty valueDisplayEnabled = new SimpleBooleanProperty(true);
    private StringProperty label = new SimpleStringProperty("label");
    private BooleanProperty labelEnabled = new SimpleBooleanProperty(true);
    private ObjectProperty<Font> labelFont = new SimpleObjectProperty((Object)new Font(12.0));

    public BSBKnob() {
        this.knobValue = new ClampedValue(0.0, 1.0, 0.0, new BigDecimal(-1.0));
        this.knobValue.addListener(this.cvl);
    }

    public BSBKnob(BSBKnob knob) {
        super(knob);
        this.knobValue = new ClampedValue(knob.knobValueProperty());
        this.knobValue.addListener(this.cvl);
        this.setKnobWidth(knob.getKnobWidth());
        this.setRandomizable(knob.isRandomizable());
        this.setValueDisplayEnabled(knob.isValueDisplayEnabled());
        this.setLabel(knob.getLabel());
        this.setLabelEnabled(knob.isLabelEnabled());
        this.setLabelFont(knob.getLabelFont());
    }

    public final ClampedValue knobValueProperty() {
        return this.knobValue;
    }

    private final void setKnobValueProperty(ClampedValue value) {
        if (this.knobValue != null) {
            this.knobValue.removeListener(this.cvl);
        }
        this.knobValue = value;
        this.knobValue.addListener(this.cvl);
    }

    public final void setValue(double val) {
        this.knobValue.setValue(val);
    }

    public final double getValue() {
        return this.knobValue.getValue();
    }

    public final void setMinimum(double value) {
        this.knobValue.setMin(value);
    }

    public final double getMinimum() {
        return this.knobValue.getMin();
    }

    public final void setMaximum(double value) {
        this.knobValue.setMax(value);
    }

    public final double getMaximum() {
        return this.knobValue.getMax();
    }

    public static BSBObject loadFromXML(Element data) {
        BSBKnob knob = new BSBKnob();
        double minVal = 0.0;
        double maxVal = 0.0;
        double value = 0.0;
        BSBKnob.initBasicFromXML(data, knob);
        knob.setLabelEnabled(false);
        int version = 1;
        String versionStr = data.getAttributeValue("version");
        if (versionStr != null) {
            version = Integer.parseInt(versionStr);
        }
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "minimum": {
                    minVal = Double.parseDouble(node.getTextString());
                    break;
                }
                case "maximum": {
                    maxVal = Double.parseDouble(node.getTextString());
                    break;
                }
                case "value": {
                    value = Double.parseDouble(node.getTextString());
                    break;
                }
                case "knobWidth": {
                    knob.setKnobWidth(Integer.parseInt(node.getTextString()));
                    break;
                }
                case "randomizable": {
                    knob.setRandomizable(XMLUtilities.readBoolean(node));
                    break;
                }
                case "valueDisplayEnabled": {
                    knob.setValueDisplayEnabled(XMLUtilities.readBoolean(node));
                    break;
                }
                case "label": {
                    knob.setLabel(node.getTextString());
                    break;
                }
                case "labelEnabled": {
                    knob.setLabelEnabled(XMLUtilities.readBoolean(node));
                    break;
                }
                case "font": {
                    knob.setLabelFont(BSBFontUtil.loadFromXML(node));
                }
            }
        }
        if (version == 1) {
            double range = maxVal - minVal;
            value = value * range + minVal;
        }
        knob.setKnobValueProperty(new ClampedValue(minVal, maxVal, value, new BigDecimal(-1.0)));
        return knob;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = BSBKnob.getBasicXML(this);
        retVal.setAttribute("version", "2");
        retVal.addElement("minimum").setText(Double.toString(this.getMinimum()));
        retVal.addElement("maximum").setText(Double.toString(this.getMaximum()));
        retVal.addElement("value").setText(Double.toString(this.getValue()));
        retVal.addElement("knobWidth").setText(Integer.toString(this.getKnobWidth()));
        retVal.addElement(XMLUtilities.writeBoolean("randomizable", this.isRandomizable()));
        retVal.addElement(XMLUtilities.writeBoolean("valueDisplayEnabled", this.isValueDisplayEnabled()));
        retVal.addElement("label").setText(this.getLabel());
        retVal.addElement(XMLUtilities.writeBoolean("labelEnabled", this.isLabelEnabled()));
        retVal.addElement(BSBFontUtil.saveAsXML(this.getLabelFont()));
        return retVal;
    }

    @Override
    public void setupForCompilation(BSBCompilationUnit compilationUnit) {
        Parameter param;
        if (this.parameters != null && (param = this.parameters.getParameter(this.getObjectName())) != null && param.getCompilationVarName() != null) {
            compilationUnit.addReplacementValue(this.getObjectName(), param.getCompilationVarName());
            return;
        }
        compilationUnit.addReplacementValue(this.getObjectName(), Double.toString(this.knobValue.getValue()));
    }

    public final void setKnobWidth(int value) {
        this.knobWidth.set(value);
    }

    public final int getKnobWidth() {
        return this.knobWidth.get();
    }

    public final IntegerProperty knobWidthProperty() {
        return this.knobWidth;
    }

    @Override
    public final void setRandomizable(boolean value) {
        this.randomizable.set(value);
    }

    @Override
    public final boolean isRandomizable() {
        return this.randomizable.get();
    }

    public final BooleanProperty randomizableProperty() {
        return this.randomizable;
    }

    public final void setValueDisplayEnabled(boolean value) {
        this.valueDisplayEnabled.set(value);
    }

    public final boolean isValueDisplayEnabled() {
        return this.valueDisplayEnabled.get();
    }

    public final BooleanProperty valueDisplayEnabledProperty() {
        return this.valueDisplayEnabled;
    }

    public final void setLabel(String value) {
        this.label.set((Object)value);
    }

    public final String getLabel() {
        return (String)this.label.get();
    }

    public final StringProperty labelProperty() {
        return this.label;
    }

    public final void setLabelEnabled(boolean value) {
        this.labelEnabled.set(value);
    }

    public final boolean isLabelEnabled() {
        return this.labelEnabled.get();
    }

    public final BooleanProperty labelEnabledProperty() {
        return this.labelEnabled;
    }

    public final void setLabelFont(Font f) {
        this.labelFont.set((Object)f);
    }

    public final Font getLabelFont() {
        return (Font)this.labelFont.get();
    }

    public final ObjectProperty<Font> labelFontProperty() {
        return this.labelFont;
    }

    @Override
    public String getPresetValue() {
        return "ver2:" + NumberUtilities.formatDouble(this.knobValue.getValue());
    }

    @Override
    public void setPresetValue(String val) {
        double dval;
        if (val.indexOf(58) < 0) {
            double fval = Double.parseDouble(val);
            dval = fval * (this.knobValue.getMax() - this.knobValue.getMin()) + this.knobValue.getMin();
        } else {
            String[] parts = val.split(":");
            dval = Double.parseDouble(parts[1]);
        }
        this.setValue(dval);
    }

    @Override
    public void initializeParameters() {
        if (this.parameters == null) {
            return;
        }
        if (!this.automationAllowed && this.getObjectName() != null && this.getObjectName().length() != 0) {
            Parameter param = this.parameters.getParameter(this.getObjectName());
            if (param != null && param.isAutomationEnabled()) {
                this.automationAllowed = true;
            } else {
                this.parameters.removeParameter(this.getObjectName());
                return;
            }
        }
        if (this.getObjectName() == null || this.getObjectName().trim().length() == 0) {
            return;
        }
        Parameter parameter = this.parameters.getParameter(this.getObjectName());
        if (parameter != null) {
            parameter.addParameterListener(this);
            if (!parameter.isAutomationEnabled()) {
                parameter.setValue(this.getValue());
            }
            return;
        }
        Parameter param = new Parameter();
        param.setValue(this.getValue());
        param.setMax(this.getMaximum(), true);
        param.setMin(this.getMinimum(), true);
        param.setName(this.getObjectName());
        param.setResolution(new BigDecimal(-1));
        param.addParameterListener(this);
        param.setValue(this.getValue());
        this.parameters.add(param);
    }

    @Override
    public void lineDataChanged(Parameter param) {
        Parameter parameter = this.parameters.getParameter(this.getObjectName());
        if (parameter != null) {
            double time = ParameterTimeManagerFactory.getInstance().getTime();
            double val = parameter.getLine().getValue(time);
            this.setValue(val);
        }
    }

    @Override
    public void parameterChanged(Parameter param) {
    }

    @Override
    public void setAutomationAllowed(boolean allowAutomation) {
        this.automationAllowed = allowAutomation;
        if (this.parameters != null) {
            if (allowAutomation) {
                this.initializeParameters();
            } else if (this.getObjectName() != null && this.getObjectName().length() != 0) {
                this.parameters.removeParameter(this.getObjectName());
            }
        }
    }

    @Override
    public void randomize() {
        if (this.isRandomizable()) {
            double range = this.getMaximum() - this.getMinimum();
            double newValue = Math.random() * range + this.getMinimum();
            this.setValue(newValue);
        }
    }

    @Override
    public BSBObject deepCopy() {
        return new BSBKnob(this);
    }
}

