/*
 * Decompiled with CFR 0.152.
 */
package blue.score.tempo;

import blue.components.lines.Line;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

public class Tempo {
    private boolean enabled = false;
    private boolean visible = false;
    private Line line;
    private transient Vector<PropertyChangeListener> listeners = null;

    public Tempo() {
        this.line = new Line(false);
        this.line.setMax(240.0, true);
        this.line.setMin(30.0, true);
        this.line.getLinePoint(0).setLocation(0.0, 60.0);
    }

    public Tempo(Tempo tempo) {
        this.line = new Line(tempo.line);
        this.enabled = tempo.enabled;
        this.visible = tempo.visible;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "enabled", this.enabled, enabled);
            this.enabled = enabled;
            this.firePropertyChangeEvent(pce);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "visible", this.visible, visible);
            this.visible = visible;
            this.firePropertyChangeEvent(pce);
        }
    }

    public Line getLine() {
        return this.line;
    }

    public void setLine(Line line) {
        this.line = line;
    }

    private void firePropertyChangeEvent(PropertyChangeEvent pce) {
        if (this.listeners == null) {
            return;
        }
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(pce);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(pcl);
    }

    public Element saveAsXML() {
        Element retVal = new Element("tempo");
        retVal.addElement(XMLUtilities.writeBoolean("enabled", this.enabled));
        retVal.addElement(XMLUtilities.writeBoolean("visible", this.visible));
        retVal.addElement(this.line.saveAsXML());
        return retVal;
    }

    public static Tempo loadFromXML(Element data) {
        Tempo retVal = new Tempo();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "enabled": {
                    retVal.enabled = Boolean.valueOf(node.getTextString());
                    break;
                }
                case "visible": {
                    retVal.visible = Boolean.valueOf(node.getTextString());
                    break;
                }
                case "line": {
                    retVal.line = Line.loadFromXML(node);
                }
            }
        }
        return retVal;
    }
}

