/*
 * Decompiled with CFR 0.152.
 */
package blue.utility;

import blue.udo.OpcodeList;
import blue.udo.UserDefinedOpcode;
import blue.utility.TextUtilities;
import java.util.HashMap;
import java.util.StringTokenizer;

public class UDOUtilities {
    public static OpcodeList parseUDOText(String udoText) {
        OpcodeList retVal = new OpcodeList();
        String cleanedText = TextUtilities.stripMultiLineComments(udoText);
        StringTokenizer st = new StringTokenizer(cleanedText, "\n");
        String line = "";
        int state = 0;
        UserDefinedOpcode currentUDO = null;
        StringBuffer codeBody = null;
        block4: while (st.hasMoreTokens()) {
            line = st.nextToken();
            switch (state) {
                case 0: {
                    if (!line.trim().startsWith("opcode")) break;
                    String[] parts = (line = TextUtilities.stripSingleLineComments(line.trim())).substring(6).split(",");
                    if (parts.length != 3) continue block4;
                    currentUDO = new UserDefinedOpcode();
                    currentUDO.opcodeName = parts[0].trim();
                    currentUDO.outTypes = parts[1].trim();
                    currentUDO.inTypes = parts[2].trim();
                    codeBody = new StringBuffer();
                    state = 1;
                    break;
                }
                case 1: {
                    if (line.trim().startsWith("opcode")) {
                        currentUDO = null;
                        state = 0;
                        break;
                    }
                    if (line.trim().startsWith("endop")) {
                        currentUDO.codeBody = codeBody.toString();
                        retVal.add(currentUDO);
                        currentUDO = null;
                        state = 0;
                        break;
                    }
                    codeBody.append(line).append("\n");
                }
            }
        }
        return retVal;
    }

    public static HashMap appendUserDefinedOpcodes(OpcodeList newList, OpcodeList masterList) {
        HashMap<String, String> keyValues = new HashMap<String, String>();
        for (UserDefinedOpcode udo : newList) {
            if (keyValues.size() > 0) {
                udo.codeBody = TextUtilities.replaceOpcodeNames(keyValues, udo.codeBody);
            }
            String oldName = udo.getOpcodeName();
            String newName = masterList.getNameOfEquivalentCopy(udo);
            if (newName == null) {
                if (!masterList.isNameUnique(oldName)) {
                    newName = masterList.getUniqueName();
                    udo.setOpcodeName(newName);
                }
                masterList.addOpcode(udo);
            }
            if (newName == null || newName.equals(oldName)) continue;
            keyValues.put(oldName, newName);
        }
        return keyValues;
    }
}

