/*
 * Decompiled with CFR 0.152.
 */
package blue.automation;

import blue.automation.AutomationManager;
import blue.automation.Parameter;
import blue.automation.ParameterIdList;
import blue.automation.ParameterList;
import blue.components.AlphaMarquee;
import blue.components.DragDirection;
import blue.components.lines.Line;
import blue.components.lines.LineEditorDialog;
import blue.components.lines.LinePoint;
import blue.score.TimeState;
import blue.ui.core.score.ModeListener;
import blue.ui.core.score.ModeManager;
import blue.ui.core.score.ScoreMode;
import blue.ui.utilities.FileChooserManager;
import blue.ui.utilities.UiUtilities;
import blue.utility.NumberUtilities;
import blue.utility.ScoreUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openide.util.Exceptions;

public class ParameterLinePanel
extends JComponent
implements TableModelListener,
ListDataListener,
ListSelectionListener,
ModeListener {
    private static final String FILE_BPF_IMPORT = "paramaterLinePanel.bpf_import";
    private static final String FILE_BPF_EXPORT = "paramaterLinePanel.bpf_export";
    private EditPointsPopup popup = null;
    LinePoint selectedPoint = null;
    int leftBoundaryX = -1;
    int rightBoundaryX = -1;
    TableModelListener lineListener = null;
    ParameterIdList parameterIdList = null;
    ParameterList paramList = null;
    Parameter currentParameter = null;
    private TimeState timeState;
    LineCanvasMouseListener mouseListener = new LineCanvasMouseListener(this);
    AlphaMarquee marquee;
    ArrayList<double[]> selectionList = new ArrayList();
    double mouseDownInitialTime = -1.0;
    double transTime = 0.0;
    private double selectionStartTime = -1.0;
    private double selectionEndTime = -1.0;
    private double newSelectionStartTime = -1.0;
    private double newSelectionEndTime = -1.0;

    public ParameterLinePanel(AlphaMarquee marquee) {
        this.marquee = marquee;
        ModeManager.getInstance().addModeListener(this);
        this.lineListener = e -> this.repaint();
        FileChooserManager fcm = FileChooserManager.getDefault();
        fcm.addFilter((Object)FILE_BPF_IMPORT, new FileChooser.ExtensionFilter("Break Point File", new String[]{"*.bpf"}));
        fcm.addFilter((Object)FILE_BPF_EXPORT, new FileChooser.ExtensionFilter("Break Point File", new String[]{"*.bpf"}));
        fcm.setDialogTitle((Object)FILE_BPF_IMPORT, "Import BPF File");
        fcm.setDialogTitle((Object)FILE_BPF_EXPORT, "Export BPF File");
    }

    public void setTimeState(TimeState timeState) {
        this.timeState = timeState;
    }

    public void setParameterIdList(ParameterIdList paramIdList) {
        Parameter param;
        if (this.parameterIdList != null) {
            this.parameterIdList.removeListDataListener((ListDataListener)this);
            this.parameterIdList.removeListSelectionListener((ListSelectionListener)this);
            if (this.paramList != null) {
                for (Parameter param2 : this.paramList) {
                    param2.getLine().removeTableModelListener(this.lineListener);
                }
            }
        }
        this.parameterIdList = paramIdList;
        this.paramList = new ParameterList();
        AutomationManager automationManager = AutomationManager.getInstance();
        for (int i = 0; i < this.parameterIdList.size(); ++i) {
            String paramId = this.parameterIdList.getParameterId(i);
            param = automationManager.getParameter(paramId);
            if (param == null) continue;
            this.paramList.add((Object)param);
            param.getLine().addTableModelListener(this.lineListener);
        }
        if (this.parameterIdList != null) {
            this.parameterIdList.addListDataListener((ListDataListener)this);
            this.parameterIdList.addListSelectionListener((ListSelectionListener)this);
            int index = this.parameterIdList.getSelectedIndex();
            if (index >= 0) {
                String id = this.parameterIdList.getParameterId(index);
                param = automationManager.getParameter(id);
                this.setSelectedParameter(param);
            }
        }
        this.selectedPoint = null;
        this.modeChanged(ModeManager.getInstance().getMode());
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.repaint();
    }

    private void setSelectedParameter(Parameter param) {
        if (this.currentParameter == param) {
            this.repaint();
            return;
        }
        this.currentParameter = param;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.paramList == null || this.paramList.size() == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHints(hints);
        Color currentColor = null;
        ModeManager modeManager = ModeManager.getInstance();
        boolean editing = modeManager.getMode() == ScoreMode.SINGLE_LINE;
        boolean multiLineMode = !editing;
        for (Parameter param : this.paramList) {
            Line line = param.getLine();
            if (multiLineMode) {
                g2d.setColor(line.getColor().darker());
                this.drawSelectionLine(g2d, param);
                continue;
            }
            if (editing && param == this.currentParameter) {
                currentColor = line.getColor();
                continue;
            }
            g2d.setColor(line.getColor().darker());
            this.drawLine(g2d, param, false);
        }
        if (multiLineMode) {
            return;
        }
        if (currentColor != null) {
            g2d.setColor(currentColor);
            if (editing && this.marquee.isVisible() && this.marquee.intersects(this)) {
                this.drawSelectionLine(g2d, this.currentParameter);
            } else {
                this.drawLine(g2d, this.currentParameter, true);
            }
        }
        if (editing && this.selectedPoint != null) {
            double min = this.currentParameter.getMin();
            double max = this.currentParameter.getMax();
            int x = this.doubleToScreenX(this.selectedPoint.getX());
            int y = this.doubleToScreenY(this.selectedPoint.getY(), min, max);
            g2d.setColor(Color.red);
            this.paintPoint(g2d, x, y);
            if (this.currentParameter != null) {
                this.drawPointInformation(g2d, x, y);
            }
        }
    }

    private void drawPointInformation(Graphics2D g2d, int x, int y) {
        g2d.setColor(Color.white);
        double yVal = this.selectedPoint.getY();
        double xVal = this.selectedPoint.getX();
        String xText = "x: " + NumberUtilities.formatDouble((double)xVal);
        String yText = "y: " + NumberUtilities.formatDouble((double)yVal);
        String label = this.currentParameter.getLabel();
        if (label.length() > 0) {
            yText = yText + " " + label;
        }
        int width = 95;
        int height = 28;
        int xLoc = x + 5;
        int yLoc = y + 5;
        if (x + width > this.getWidth()) {
            xLoc = x - width - 5;
        }
        if (y + height > this.getHeight()) {
            yLoc = y - 14 - 5;
        }
        g2d.drawString(xText, xLoc, yLoc);
        g2d.drawString(yText, xLoc, yLoc + 14);
    }

    private final void drawLine(Graphics g, Parameter p, boolean drawPoints) {
        Line line = p.getLine();
        Rectangle clipBounds = g.getClipBounds();
        if (line.size() == 0) {
            return;
        }
        if (line.size() == 1) {
            LinePoint lp = line.getLinePoint(0);
            double min = line.getMin();
            double max = line.getMax();
            int x = this.doubleToScreenX(lp.getX());
            int y = this.doubleToScreenY(lp.getY(), min, max);
            g.drawLine(0, y, this.getWidth(), y);
            if (drawPoints) {
                this.paintPoint(g, x, y);
            }
            return;
        }
        if (p.getResolution().doubleValue() <= 0.0) {
            int[] xValues = new int[line.size()];
            int[] yValues = new int[line.size()];
            double min = line.getMin();
            double max = line.getMax();
            for (int i = 0; i < line.size(); ++i) {
                LinePoint point = line.getLinePoint(i);
                xValues[i] = this.doubleToScreenX(point.getX());
                yValues[i] = this.doubleToScreenY(point.getY(), min, max);
            }
            g.drawPolyline(xValues, yValues, xValues.length);
            int lastX = xValues[xValues.length - 1];
            if (lastX < this.getWidth()) {
                int lastY = yValues[yValues.length - 1];
                g.drawLine(lastX, lastY, this.getWidth(), lastY);
            }
            if (drawPoints) {
                for (int i = 0; i < xValues.length; ++i) {
                    this.paintPoint(g, xValues[i], yValues[i]);
                }
            }
        } else {
            LinePoint previous = null;
            double min = p.getMin();
            double max = p.getMax();
            BigDecimal resolution = p.getResolution();
            for (int i = 0; i < line.size(); ++i) {
                LinePoint point = line.getLinePoint(i);
                int x = this.doubleToScreenX(point.getX());
                int y = this.doubleToScreenY(point.getY(), min, max);
                if (drawPoints) {
                    this.paintPoint(g, x, y);
                }
                if (previous != null) {
                    double startVal = previous.getY();
                    int startX = this.doubleToScreenX(previous.getX());
                    int startY = this.doubleToScreenY(startVal, min, max);
                    int endX = this.doubleToScreenX(point.getX());
                    int endY = this.doubleToScreenY(point.getY(), min, max);
                    if (startVal == point.getY()) {
                        g.drawLine(startX, startY, endX, startY);
                        previous = point;
                        continue;
                    }
                    if (previous.getX() == point.getX()) {
                        if (startY != endY) {
                            g.drawLine(startX, startY, startX, endY);
                        }
                        previous = point;
                        continue;
                    }
                    int lastY = startY;
                    int lastX = startX;
                    for (int j = startX; j <= endX; ++j) {
                        double timeVal = this.screenToDoubleX(j);
                        double val = line.getValue(timeVal);
                        int newY = this.doubleToScreenY(val, min, max);
                        if (endY > startY) {
                            if (newY < startY) {
                                newY = startY;
                            }
                        } else if (newY > startY) {
                            newY = startY;
                        }
                        if (newY == lastY) continue;
                        g.drawLine(lastX, lastY, j, lastY);
                        g.drawLine(j, lastY, j, newY);
                        lastX = j;
                        lastY = newY;
                    }
                    if (lastX != endX) {
                        g.drawLine(lastX, lastY, endX, lastY);
                        g.drawLine(endX, lastY, endX, endY);
                    }
                }
                previous = point;
            }
            if (previous.getX() < (double)this.getWidth()) {
                int lastX = this.doubleToScreenX(previous.getX());
                int lastY = this.doubleToScreenY(previous.getY(), min, max);
                g.drawLine(lastX, lastY, this.getWidth(), lastY);
            }
        }
    }

    void paintSelectionPoint(Graphics g, int x, int y, double time, double selectionStart, double selectionEnd) {
        if (time >= selectionStart && time <= selectionEnd) {
            Color c = g.getColor();
            g.setColor(c.darker().darker());
            g.fillRect(x - 3, y - 3, 7, 7);
            g.setColor(c);
        }
        this.paintPoint(g, x, y);
    }

    private Line getSelectionSortedLine(Line line) {
        Line retVal = new Line(line);
        this.processLineForSelectionDrag(retVal);
        return retVal;
    }

    private boolean isPointInSelectionRegion(double pointTime, double timeMod) {
        for (int i = 0; i < this.selectionList.size(); ++i) {
            double[] points = this.selectionList.get(i);
            double min = points[0] + timeMod;
            double max = points[1] + timeMod;
            if (!(pointTime >= min) || !(pointTime <= max)) continue;
            return true;
        }
        return false;
    }

    private void processLineForSelectionDrag(Line line) {
        ArrayList<LinePoint> points = new ArrayList<LinePoint>();
        Iterator iter = line.iterator();
        while (iter.hasNext()) {
            LinePoint lp = (LinePoint)iter.next();
            if (line.isFirstLinePoint(lp)) continue;
            double pointTime = lp.getX();
            if (this.isPointInSelectionRegion(pointTime, 0.0)) {
                points.add(lp);
                iter.remove();
                continue;
            }
            if (!this.isPointInSelectionRegion(pointTime, this.transTime)) continue;
            iter.remove();
        }
        for (LinePoint lp : points) {
            lp.setLocation(lp.getX() + this.transTime, lp.getY());
            line.addLinePoint(lp);
        }
        line.sort();
    }

    private Line getSelectionScalingSortedLine(Line line) {
        Line retVal = new Line(line);
        this.processLineForSelectionScale(retVal);
        return retVal;
    }

    private void processLineForSelectionScale(Line line) {
        if (this.selectionStartTime < 0.0) {
            return;
        }
        ArrayList<LinePoint> points = new ArrayList<LinePoint>();
        Iterator iter = line.iterator();
        while (iter.hasNext()) {
            LinePoint lp = (LinePoint)iter.next();
            if (line.isFirstLinePoint(lp)) continue;
            double pointTime = lp.getX();
            if (pointTime >= this.selectionStartTime && pointTime <= this.selectionEndTime) {
                points.add(lp);
                iter.remove();
                continue;
            }
            if (!(pointTime >= this.newSelectionStartTime) || !(pointTime <= this.newSelectionEndTime)) continue;
            iter.remove();
        }
        double oldStart = this.selectionStartTime;
        double newStart = this.newSelectionStartTime;
        double oldRange = this.selectionEndTime - this.selectionStartTime;
        double newRange = this.newSelectionEndTime - this.newSelectionStartTime;
        for (LinePoint lp : points) {
            double newX = lp.getX() - oldStart;
            newX = newX / oldRange * newRange;
            lp.setLocation(newX += newStart, lp.getY());
            line.addLinePoint(lp);
        }
        line.sort();
    }

    private final void drawSelectionLine(Graphics g, Parameter p) {
        double selectionEnd;
        double selectionStart;
        Line tempLine = p.getLine();
        if (this.selectionList.size() > 0) {
            tempLine = this.getSelectionSortedLine(tempLine);
        } else if (this.newSelectionStartTime >= 0.0) {
            tempLine = this.getSelectionScalingSortedLine(tempLine);
        } else {
            this.drawLine(g, p, false);
            return;
        }
        Color currentColor = g.getColor();
        Rectangle clipBounds = g.getClipBounds();
        if (tempLine.size() == 0) {
            return;
        }
        double pixelSecond = this.timeState.getPixelSecond();
        if (this.newSelectionStartTime >= 0.0) {
            selectionStart = this.newSelectionStartTime;
            selectionEnd = this.newSelectionEndTime;
        } else {
            selectionStart = this.marquee.startTime;
            selectionEnd = this.marquee.endTime;
        }
        if (tempLine.size() == 1) {
            LinePoint lp = tempLine.getLinePoint(0);
            double min = tempLine.getMin();
            double max = tempLine.getMax();
            int x = this.doubleToScreenX(lp.getX());
            int y = this.doubleToScreenY(lp.getY(), min, max);
            g.setColor(currentColor);
            g.drawLine(0, y, this.getWidth(), y);
            this.paintSelectionPoint(g, x, y, lp.getX(), selectionStart, selectionEnd);
            return;
        }
        if (p.getResolution().doubleValue() <= 0.0) {
            int[] xValues = new int[tempLine.size()];
            int[] yValues = new int[tempLine.size()];
            double[] pointX = new double[tempLine.size()];
            double min = tempLine.getMin();
            double max = tempLine.getMax();
            for (int i = 0; i < tempLine.size(); ++i) {
                LinePoint point = tempLine.getLinePoint(i);
                pointX[i] = point.getX();
                xValues[i] = this.doubleToScreenX(pointX[i]);
                yValues[i] = this.doubleToScreenY(point.getY(), min, max);
            }
            g.drawPolyline(xValues, yValues, xValues.length);
            int lastX = xValues[xValues.length - 1];
            if (lastX < this.getWidth()) {
                int lastY = yValues[yValues.length - 1];
                g.drawLine(lastX, lastY, this.getWidth(), lastY);
            }
            for (int i = 0; i < xValues.length; ++i) {
                this.paintSelectionPoint(g, xValues[i], yValues[i], pointX[i], selectionStart, selectionEnd);
            }
        } else {
            LinePoint previous = null;
            double min = p.getMin();
            double max = p.getMax();
            BigDecimal resolution = p.getResolution();
            for (int i = 0; i < tempLine.size(); ++i) {
                LinePoint point = tempLine.getLinePoint(i);
                int x = this.doubleToScreenX(point.getX());
                int y = this.doubleToScreenY(point.getY(), min, max);
                if (previous != null) {
                    double startVal = previous.getY();
                    int startX = this.doubleToScreenX(previous.getX());
                    int startY = this.doubleToScreenY(startVal, min, max);
                    int endX = this.doubleToScreenX(point.getX());
                    int endY = this.doubleToScreenY(point.getY(), min, max);
                    if (startVal == point.getY()) {
                        g.setColor(currentColor);
                        g.drawLine(startX, startY, endX, startY);
                        previous = point;
                        continue;
                    }
                    if (previous.getX() == point.getX()) {
                        if (startY != endY) {
                            g.setColor(currentColor);
                            g.drawLine(startX, startY, startX, endY);
                        }
                        previous = point;
                        continue;
                    }
                    int lastY = startY;
                    int lastX = startX;
                    for (int j = startX; j <= endX; ++j) {
                        double timeVal = this.screenToDoubleX(j);
                        double val = tempLine.getValue(timeVal);
                        int newY = this.doubleToScreenY(val, min, max);
                        if (endY > startY) {
                            if (newY < startY) {
                                newY = startY;
                            }
                        } else if (newY > startY) {
                            newY = startY;
                        }
                        if (newY == lastY) continue;
                        g.setColor(currentColor);
                        g.drawLine(lastX, lastY, j, lastY);
                        g.drawLine(j, lastY, j, newY);
                        lastX = j;
                        lastY = newY;
                    }
                    if (lastX != endX) {
                        g.setColor(currentColor);
                        g.drawLine(lastX, lastY, endX, lastY);
                        g.drawLine(endX, lastY, endX, endY);
                    }
                }
                this.paintSelectionPoint(g, x, y, point.getX(), selectionStart, selectionEnd);
                previous = point;
            }
            if (previous.getX() < (double)this.getWidth()) {
                int lastX = this.doubleToScreenX(previous.getX());
                int lastY = this.doubleToScreenY(previous.getY(), min, max);
                g.setColor(currentColor);
                g.drawLine(lastX, lastY, this.getWidth(), lastY);
            }
        }
    }

    private final void paintPoint(Graphics g, int x, int y) {
        g.fillRect(x - 2, y - 2, 5, 5);
    }

    private int doubleToScreenX(double val) {
        if (this.timeState == null) {
            return -1;
        }
        return (int)Math.round(val * (double)this.timeState.getPixelSecond());
    }

    private int doubleToScreenY(double yVal, double min, double max) {
        int height = this.getHeight() - 10;
        double range = max - min;
        double adjustedY = yVal - min;
        double percent = adjustedY / range;
        int y = (int)Math.round((double)height * (1.0 - percent)) + 5;
        return y;
    }

    private double screenToDoubleX(int val) {
        if (this.timeState == null) {
            return -1.0;
        }
        return (double)val / (double)this.timeState.getPixelSecond();
    }

    private double screenToDoubleY(int val, double min, double max, BigDecimal resolution) {
        double height = this.getHeight() - 10;
        double percent = 1.0 - (double)(val - 5) / height;
        double range = max - min;
        double value = percent * range;
        if (resolution.doubleValue() > 0.0) {
            BigDecimal v = new BigDecimal(value).setScale(resolution.scale(), RoundingMode.HALF_UP);
            value = v.subtract(v.remainder(resolution)).doubleValue();
        }
        if (value > range) {
            value = range;
        }
        if (value < 0.0) {
            value = 0.0;
        }
        return value + min;
    }

    public void setBoundaryXValues() {
        Line currentLine = this.currentParameter.getLine();
        if (this.selectedPoint == currentLine.getLinePoint(0)) {
            this.leftBoundaryX = 0;
            this.rightBoundaryX = 0;
            return;
        }
        if (this.selectedPoint == currentLine.getLinePoint(currentLine.size() - 1)) {
            LinePoint p1 = currentLine.getLinePoint(currentLine.size() - 2);
            this.leftBoundaryX = this.doubleToScreenX(p1.getX());
            this.rightBoundaryX = this.getWidth();
            return;
        }
        for (int i = 0; i < currentLine.size(); ++i) {
            if (currentLine.getLinePoint(i) != this.selectedPoint) continue;
            LinePoint p1 = currentLine.getLinePoint(i - 1);
            LinePoint p2 = currentLine.getLinePoint(i + 1);
            this.leftBoundaryX = this.doubleToScreenX(p1.getX());
            this.rightBoundaryX = this.doubleToScreenX(p2.getX());
            return;
        }
    }

    protected LinePoint insertGraphPoint(int x, int y) {
        LinePoint point = new LinePoint();
        double min = this.currentParameter.getMin();
        double max = this.currentParameter.getMax();
        point.setLocation(this.screenToDoubleX(x), this.screenToDoubleY(y, min, max, this.currentParameter.getResolution()));
        int index = 1;
        Line currentLine = this.currentParameter.getLine();
        LinePoint last = currentLine.getLinePoint(currentLine.size() - 1);
        if (point.getX() > last.getX()) {
            currentLine.addLinePoint(point);
            return point;
        }
        for (int i = 0; i < currentLine.size(); ++i) {
            LinePoint p1 = currentLine.getLinePoint(i);
            LinePoint p2 = currentLine.getLinePoint(i + 1);
            if (!(point.getX() >= p1.getX()) || !(point.getX() <= p2.getX())) continue;
            index = i + 1;
            break;
        }
        currentLine.addLinePoint(index, point);
        return point;
    }

    public LinePoint findGraphPoint(int x, int y) {
        Line currentLine = this.currentParameter.getLine();
        double min = this.currentParameter.getMin();
        double max = this.currentParameter.getMax();
        for (int i = 0; i < currentLine.size(); ++i) {
            LinePoint point = currentLine.getLinePoint(i);
            int tempX = this.doubleToScreenX(point.getX());
            int tempY = this.doubleToScreenY(point.getY(), min, max);
            if (tempX < x - 2 || tempX > x + 2 || tempY < y - 2 || tempY > y + 2) continue;
            return point;
        }
        return null;
    }

    public LinePoint findGraphPoint(int x) {
        Line currentLine = this.currentParameter.getLine();
        for (int i = 0; i < currentLine.size(); ++i) {
            LinePoint point = currentLine.getLinePoint(i);
            int tempX = this.doubleToScreenX(point.getX());
            if (tempX < x - 2 || tempX > x + 2) continue;
            return point;
        }
        return null;
    }

    public void cleanup() {
        if (this.parameterIdList != null) {
            this.parameterIdList.removeListDataListener((ListDataListener)this);
            this.parameterIdList.removeListSelectionListener((ListSelectionListener)this);
        }
        if (this.paramList != null) {
            for (Parameter param : this.paramList) {
                param.getLine().removeTableModelListener((TableModelListener)this);
            }
        }
        this.parameterIdList = null;
        this.paramList = null;
        ModeManager.getInstance().removeModeListener(this);
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        if (e.getSource() == this.parameterIdList) {
            String paramId = this.parameterIdList.getParameterId(e.getIndex0());
            Parameter param = AutomationManager.getInstance().getParameter(paramId);
            this.paramList.add((Object)param);
            param.getLine().addTableModelListener((TableModelListener)this);
            this.repaint();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        if (e.getSource() == this.parameterIdList) {
            for (int i = 0; i < this.paramList.size(); ++i) {
                Parameter param = (Parameter)this.paramList.get(i);
                if (this.parameterIdList.contains(param.getUniqueId())) continue;
                this.paramList.remove(i);
                param.getLine().removeTableModelListener((TableModelListener)this);
                this.repaint();
                return;
            }
        }
    }

    @Override
    public void modeChanged(ScoreMode mode) {
        if (mode == ScoreMode.SINGLE_LINE) {
            this.addMouseListener(this.mouseListener);
            this.addMouseMotionListener(this.mouseListener);
        } else {
            this.removeMouseListener(this.mouseListener);
            this.removeMouseMotionListener(this.mouseListener);
        }
        this.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int index = e.getFirstIndex();
        if (index < 0) {
            this.setSelectedParameter(null);
            return;
        }
        String paramId = this.parameterIdList.getParameterId(index);
        Parameter param = AutomationManager.getInstance().getParameter(paramId);
        this.setSelectedParameter(param);
    }

    public void setSelectionDragRegion(double startTime, double endTime) {
        if (this.selectionList.size() == 0) {
            this.selectionList.add(new double[2]);
        }
        double[] points = this.selectionList.get(0);
        points[0] = startTime;
        points[1] = endTime;
        this.repaint();
    }

    public void clearSelectionDragRegions() {
        this.selectionList.clear();
        this.repaint();
    }

    public void setMultiLineMouseTranslation(double transTime) {
        this.transTime = transTime;
        this.repaint();
    }

    public void commitMultiLineDrag() {
        if (this.paramList != null && (this.marquee.intersects(this) || this.selectionList.size() > 0)) {
            for (int i = 0; i < this.paramList.size(); ++i) {
                Parameter param = (Parameter)this.paramList.get(i);
                this.processLineForSelectionDrag(param.getLine());
            }
        }
        this.transTime = 0.0;
    }

    public void initiateScoreScale(double startTime, double endTime) {
        this.selectionStartTime = startTime;
        this.newSelectionStartTime = startTime;
        this.selectionEndTime = endTime;
        this.newSelectionEndTime = endTime;
    }

    public void setScoreScaleStart(double newSelectionStartTime) {
        this.newSelectionStartTime = newSelectionStartTime;
        this.repaint();
    }

    public void setScoreScaleEnd(double newSelectionEndTime) {
        this.newSelectionEndTime = newSelectionEndTime;
        this.repaint();
    }

    public void commitScoreScale() {
        if (this.paramList != null) {
            for (int i = 0; i < this.paramList.size(); ++i) {
                Parameter param = (Parameter)this.paramList.get(i);
                this.processLineForSelectionScale(param.getLine());
            }
            this.selectionEndTime = -1.0;
            this.selectionStartTime = -1.0;
            this.newSelectionEndTime = -1.0;
            this.newSelectionStartTime = -1.0;
            this.transTime = 0.0;
        }
        this.repaint();
    }

    class EditPointsPopup
    extends JPopupMenu {
        Line line = null;
        JMenu selectParameterMenu = new JMenu("Select Parameter");
        ActionListener paramItemListener;
        Action editPointsAction;
        Action importBPF;
        Action exportBPF;

        public EditPointsPopup() {
            this.editPointsAction = new AbstractAction("Edit Points"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Component root = SwingUtilities.getRoot(EditPointsPopup.this.getInvoker());
                    LineEditorDialog dialog = LineEditorDialog.getInstance(root);
                    dialog.setLine(EditPointsPopup.this.line);
                    dialog.ask();
                }
            };
            this.paramItemListener = e -> {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                Parameter param = (Parameter)menuItem.getClientProperty("param");
                ParameterLinePanel.this.parameterIdList.setSelectedParameter(param.getUniqueId());
                ParameterLinePanel.this.repaint();
            };
            this.exportBPF = new AbstractAction("Export BPF"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    File retVal;
                    if (EditPointsPopup.this.line != null && EditPointsPopup.this.line.size() > 0 && (retVal = FileChooserManager.getDefault().showSaveDialog((Object)ParameterLinePanel.FILE_BPF_EXPORT, SwingUtilities.getRoot(ParameterLinePanel.this))) != null) {
                        File f = retVal;
                        try {
                            try (PrintWriter out = new PrintWriter(new FileWriter(f));){
                                out.print(EditPointsPopup.this.line.exportBPF());
                                out.flush();
                            }
                            JOptionPane.showMessageDialog(SwingUtilities.getRoot(ParameterLinePanel.this), "Line Exported as: " + f.getAbsolutePath());
                        }
                        catch (IOException e) {
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    }
                }
            };
            this.importBPF = new AbstractAction("Import BPF"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    File f;
                    File retVal;
                    if (EditPointsPopup.this.line != null && EditPointsPopup.this.line.size() > 0 && (retVal = FileChooserManager.getDefault().showSaveDialog((Object)ParameterLinePanel.FILE_BPF_IMPORT, SwingUtilities.getRoot(ParameterLinePanel.this))) != null && !EditPointsPopup.this.line.importBPF(f = retVal)) {
                        JOptionPane.showMessageDialog(SwingUtilities.getRoot(ParameterLinePanel.this), "Failed to import BPF from file " + f.getAbsolutePath());
                    }
                }
            };
            this.add(this.selectParameterMenu);
            this.add(this.editPointsAction);
            this.addSeparator();
            this.add(this.importBPF);
            this.add(this.exportBPF);
        }

        public void repopulate() {
            this.selectParameterMenu.removeAll();
            if (ParameterLinePanel.this.paramList == null || ParameterLinePanel.this.paramList.size() == 0) {
                return;
            }
            for (int i = 0; i < ParameterLinePanel.this.paramList.size(); ++i) {
                Parameter param = (Parameter)ParameterLinePanel.this.paramList.get(i);
                JMenuItem item = new JMenuItem();
                item.setText(param.getName());
                item.setEnabled(param != ParameterLinePanel.this.currentParameter);
                item.putClientProperty("param", param);
                item.addActionListener(this.paramItemListener);
                this.selectParameterMenu.add(item);
            }
        }

        public void setLine(Line line) {
            this.line = line;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            if (ParameterLinePanel.this.paramList != null) {
                this.repopulate();
                this.editPointsAction.setEnabled(this.line != null);
                boolean bpfEnabled = this.line != null && ParameterLinePanel.this.currentParameter.getResolution().doubleValue() <= 0.0;
                this.importBPF.setEnabled(bpfEnabled);
                this.exportBPF.setEnabled(bpfEnabled);
                super.show(invoker, x, y);
            }
        }
    }

    class LineCanvasMouseListener
    implements MouseListener,
    MouseMotionListener {
        ParameterLinePanel lineCanvas;
        DragDirection direction = DragDirection.NOT_SET;
        Point pressPoint = null;
        boolean horizontalShift = false;
        private int initialY;
        List<LinePointOrigin> linePointOrigins = new ArrayList<LinePointOrigin>();
        int maxHorizontalUp = 0;
        int maxHorizontalDown = 0;

        public LineCanvasMouseListener(ParameterLinePanel lineCanvas) {
            this.lineCanvas = lineCanvas;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (ModeManager.getInstance().getMode() != ScoreMode.SINGLE_LINE) {
                return;
            }
            this.pressPoint = e.getPoint();
            if (ParameterLinePanel.this.marquee.isVisible()) {
                int x;
                if (SwingUtilities.isLeftMouseButton(e) && !ParameterLinePanel.this.marquee.contains(SwingUtilities.convertPoint(e.getComponent(), this.pressPoint, ParameterLinePanel.this.marquee))) {
                    ParameterLinePanel.this.transTime = 0.0;
                    ParameterLinePanel.this.mouseDownInitialTime = -1.0;
                    ParameterLinePanel.this.clearSelectionDragRegions();
                    ParameterLinePanel.this.marquee.setVisible(false);
                    return;
                }
                if (ParameterLinePanel.this.marquee.intersects(ParameterLinePanel.this) && (x = e.getX()) >= ParameterLinePanel.this.marquee.getX() && x <= ParameterLinePanel.this.marquee.getX() + ParameterLinePanel.this.marquee.getWidth()) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        double[] points;
                        double pixelSecond = ParameterLinePanel.this.timeState.getPixelSecond();
                        ParameterLinePanel.this.mouseDownInitialTime = (double)e.getX() / pixelSecond;
                        ParameterLinePanel.this.transTime = 0.0;
                        double marqueeLeft = (double)ParameterLinePanel.this.marquee.getX() / pixelSecond;
                        double marqueeRight = (double)(ParameterLinePanel.this.marquee.getX() + ParameterLinePanel.this.marquee.getWidth()) / pixelSecond;
                        if (ParameterLinePanel.this.selectionList.size() == 0) {
                            points = new double[]{marqueeLeft, marqueeRight};
                            ParameterLinePanel.this.selectionList.add(points);
                        } else {
                            points = ParameterLinePanel.this.selectionList.get(0);
                            points[0] = marqueeLeft;
                            points[1] = marqueeRight;
                        }
                        this.horizontalShift = e.isControlDown();
                        int topY = 5;
                        int bottomY = ParameterLinePanel.this.getHeight() - 5;
                        if (this.horizontalShift) {
                            this.linePointOrigins.clear();
                            int max = Integer.MAX_VALUE;
                            int min = Integer.MAX_VALUE;
                            for (Parameter p : ParameterLinePanel.this.paramList) {
                                for (LinePoint lp : p.getLine()) {
                                    if (!(lp.getX() >= marqueeLeft) || !(lp.getX() <= marqueeRight)) continue;
                                    LinePointOrigin lpo = new LinePointOrigin(p, lp);
                                    this.linePointOrigins.add(lpo);
                                    max = Math.min(Math.abs(topY - lpo.originY), max);
                                    min = Math.min(bottomY - lpo.originY, min);
                                }
                            }
                            this.maxHorizontalUp = -max;
                            this.maxHorizontalDown = min;
                        }
                        this.initialY = e.getY();
                    }
                    return;
                }
            }
            ParameterLinePanel.this.transTime = 0.0;
            ParameterLinePanel.this.mouseDownInitialTime = -1.0;
            ParameterLinePanel.this.clearSelectionDragRegions();
            ParameterLinePanel.this.marquee.setVisible(false);
            if (ParameterLinePanel.this.currentParameter == null) {
                return;
            }
            Line currentLine = ParameterLinePanel.this.currentParameter.getLine();
            if (ParameterLinePanel.this.selectedPoint != null) {
                if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    LinePoint first = currentLine.getLinePoint(0);
                    if (ParameterLinePanel.this.selectedPoint != first) {
                        currentLine.removeLinePoint(ParameterLinePanel.this.selectedPoint);
                        ParameterLinePanel.this.selectedPoint = null;
                    }
                } else {
                    ParameterLinePanel.this.setBoundaryXValues();
                }
            } else if (SwingUtilities.isLeftMouseButton(e)) {
                int start = e.getX();
                double pixelSecond = ParameterLinePanel.this.timeState.getPixelSecond();
                double startTime = (double)start / pixelSecond;
                if (ParameterLinePanel.this.timeState.isSnapEnabled() && !e.isControlDown()) {
                    startTime = ScoreUtilities.getSnapValueStart((double)startTime, (double)ParameterLinePanel.this.timeState.getSnapValue());
                }
                if (e.isShiftDown()) {
                    Point p = new Point(start, ParameterLinePanel.this.getY());
                    ParameterLinePanel.this.marquee.setStart(p);
                    ParameterLinePanel.this.marquee.startTime = startTime;
                    ParameterLinePanel.this.marquee.endTime = startTime;
                    ParameterLinePanel.this.marquee.setVisible(true);
                } else {
                    ParameterLinePanel.this.selectedPoint = ParameterLinePanel.this.insertGraphPoint(start, e.getY());
                    ParameterLinePanel.this.setBoundaryXValues();
                }
            } else if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                if (ParameterLinePanel.this.popup == null) {
                    ParameterLinePanel.this.popup = new EditPointsPopup();
                }
                ParameterLinePanel.this.popup.setLine(currentLine);
                ParameterLinePanel.this.popup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.direction = DragDirection.NOT_SET;
            boolean didHorizontalShift = this.horizontalShift;
            this.horizontalShift = false;
            if (ModeManager.getInstance().getMode() != ScoreMode.SINGLE_LINE) {
                return;
            }
            if (ParameterLinePanel.this.currentParameter == null) {
                return;
            }
            if (ParameterLinePanel.this.selectedPoint == null && !didHorizontalShift && ParameterLinePanel.this.marquee.isVisible() && ParameterLinePanel.this.marquee.intersects(ParameterLinePanel.this) && ParameterLinePanel.this.selectionList.size() > 0 && SwingUtilities.isLeftMouseButton(e)) {
                ParameterLinePanel.this.processLineForSelectionDrag(ParameterLinePanel.this.currentParameter.getLine());
            }
            ParameterLinePanel.this.clearSelectionDragRegions();
            ParameterLinePanel.this.transTime = 0.0;
            ParameterLinePanel.this.repaint();
        }

        private double getInitialStartTime() {
            if (ParameterLinePanel.this.selectionList.size() == 0) {
                return 0.0;
            }
            double retVal = Double.MAX_VALUE;
            for (int i = 0; i < ParameterLinePanel.this.selectionList.size(); ++i) {
                double[] points = ParameterLinePanel.this.selectionList.get(i);
                if (!(points[0] < retVal)) continue;
                retVal = points[0];
            }
            return retVal;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (ModeManager.getInstance().getMode() != ScoreMode.SINGLE_LINE) {
                return;
            }
            if (ParameterLinePanel.this.currentParameter == null) {
                return;
            }
            if (ParameterLinePanel.this.marquee.isVisible()) {
                int x = e.getX();
                double pixelSecond = ParameterLinePanel.this.timeState.getPixelSecond();
                double mouseDragTime = (double)x / pixelSecond;
                if (this.horizontalShift) {
                    int yDiff = e.getY() - this.initialY;
                    yDiff = Math.max(yDiff, this.maxHorizontalUp);
                    yDiff = Math.min(yDiff, this.maxHorizontalDown);
                    this.processHorizontalShift(yDiff, this.linePointOrigins);
                } else if (ParameterLinePanel.this.mouseDownInitialTime > 0.0) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        ParameterLinePanel.this.transTime = mouseDragTime - ParameterLinePanel.this.mouseDownInitialTime;
                        double newTime = this.getInitialStartTime() + ParameterLinePanel.this.transTime;
                        if (ParameterLinePanel.this.timeState.isSnapEnabled() && !e.isControlDown()) {
                            newTime = ScoreUtilities.getSnapValueStart((double)newTime, (double)ParameterLinePanel.this.timeState.getSnapValue());
                            ParameterLinePanel.this.transTime = newTime - this.getInitialStartTime();
                        }
                        if (newTime < 0.0) {
                            ParameterLinePanel.this.transTime -= newTime;
                            newTime = 0.0;
                        }
                        ParameterLinePanel.this.marquee.startTime = newTime;
                        ParameterLinePanel.this.marquee.endTime = newTime;
                        ParameterLinePanel.this.marquee.setLocation((int)(newTime * pixelSecond), ParameterLinePanel.this.marquee.getY());
                    }
                } else {
                    if (x < 0) {
                        x = 0;
                    }
                    double endTime = (double)x / pixelSecond;
                    if (ParameterLinePanel.this.timeState.isSnapEnabled() && !e.isControlDown()) {
                        endTime = ScoreUtilities.getSnapValueMove((double)endTime, (double)ParameterLinePanel.this.timeState.getSnapValue());
                    }
                    Point p = new Point((int)(endTime * pixelSecond), ParameterLinePanel.this.getY() + ParameterLinePanel.this.getHeight());
                    ParameterLinePanel.this.marquee.endTime = endTime;
                    ParameterLinePanel.this.marquee.setDragPoint(p);
                }
            } else if (ParameterLinePanel.this.selectedPoint != null) {
                int x = e.getX();
                int y = e.getY();
                if (this.direction == DragDirection.NOT_SET) {
                    int magy;
                    int magx = Math.abs(x - (int)this.pressPoint.getX());
                    DragDirection dragDirection = this.direction = magx > (magy = Math.abs(y - (int)this.pressPoint.getY())) ? DragDirection.LEFT_RIGHT : DragDirection.UP_DOWN;
                }
                if (e.isControlDown()) {
                    if (this.direction == DragDirection.LEFT_RIGHT) {
                        y = (int)this.pressPoint.getY();
                    } else {
                        x = (int)this.pressPoint.getX();
                    }
                }
                int topY = 5;
                int bottomY = ParameterLinePanel.this.getHeight() - 5;
                if (x < ParameterLinePanel.this.leftBoundaryX) {
                    x = ParameterLinePanel.this.leftBoundaryX;
                } else if (x > ParameterLinePanel.this.rightBoundaryX) {
                    x = ParameterLinePanel.this.rightBoundaryX;
                }
                if (y < topY) {
                    y = topY;
                } else if (y > bottomY) {
                    y = bottomY;
                }
                double pixelSecond = ParameterLinePanel.this.timeState.getPixelSecond();
                double dragTime = (double)x / pixelSecond;
                if (ParameterLinePanel.this.timeState.isSnapEnabled() && !e.isControlDown()) {
                    dragTime = ScoreUtilities.getSnapValueMove((double)dragTime, (double)ParameterLinePanel.this.timeState.getSnapValue());
                }
                double min = ParameterLinePanel.this.currentParameter.getMin();
                double max = ParameterLinePanel.this.currentParameter.getMax();
                if (ParameterLinePanel.this.selectedPoint != null) {
                    ParameterLinePanel.this.selectedPoint.setLocation(dragTime, ParameterLinePanel.this.screenToDoubleY(y, min, max, ParameterLinePanel.this.currentParameter.getResolution()));
                }
            }
            ParameterLinePanel.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int y;
            if (ModeManager.getInstance().getMode() != ScoreMode.SINGLE_LINE) {
                return;
            }
            if (ParameterLinePanel.this.currentParameter == null) {
                return;
            }
            int x = e.getX();
            LinePoint foundPoint = ParameterLinePanel.this.findGraphPoint(x, y = e.getY());
            if (foundPoint != null) {
                if (ParameterLinePanel.this.selectedPoint != foundPoint) {
                    ParameterLinePanel.this.selectedPoint = foundPoint;
                    ParameterLinePanel.this.repaint();
                }
            } else if (ParameterLinePanel.this.selectedPoint != null) {
                ParameterLinePanel.this.selectedPoint = null;
                ParameterLinePanel.this.repaint();
            }
        }

        private void processHorizontalShift(int yDiff, List<LinePointOrigin> lpos) {
            for (LinePointOrigin lpo : lpos) {
                LinePoint lp = lpo.linePoint;
                Parameter param = lpo.param;
                double newY = ParameterLinePanel.this.screenToDoubleY(lpo.originY + yDiff, param.getMin(), param.getMax(), new BigDecimal(-1));
                lp.setLocation(lp.getX(), newY);
            }
        }
    }

    class LinePointOrigin {
        private final int originY;
        private final Parameter param;
        private final LinePoint linePoint;

        public LinePointOrigin(Parameter p, LinePoint lp) {
            this.originY = ParameterLinePanel.this.doubleToScreenY(lp.getY(), p.getMin(), p.getMax());
            this.param = p;
            this.linePoint = lp;
        }
    }
}

