/*
 * Decompiled with CFR 0.152.
 */
package blue.components;

import blue.components.ColorSelectionPanel;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class ColorCellEditor
implements TableCellEditor {
    protected transient List<CellEditorListener> listeners = null;
    private ColorSelectionPanel panel = new ColorSelectionPanel();

    public ColorCellEditor() {
        this.panel.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("colorSelectionValue")) {
                this.fireEditingStopped();
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        return this.panel.getColor();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        this.listeners.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEditingCanceled() {
        if (this.listeners == null) {
            return;
        }
        ChangeEvent ce = new ChangeEvent(this);
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                CellEditorListener listener = this.listeners.get(i);
                listener.editingCanceled(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEditingStopped() {
        if (this.listeners == null) {
            return;
        }
        ChangeEvent ce = new ChangeEvent(this);
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                CellEditorListener listener = this.listeners.get(i);
                listener.editingStopped(ce);
            }
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.panel.setColor((Color)value);
        return this.panel;
    }
}

