/*
 * Decompiled with CFR 0.152.
 */
package blue.components;

import blue.components.DragDirection;
import blue.components.lines.Line;
import blue.components.lines.LineEditorDialog;
import blue.components.lines.LineList;
import blue.components.lines.LinePoint;
import blue.ui.utilities.UiUtilities;
import blue.utility.NumberUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class LineCanvas
extends JComponent
implements TableModelListener {
    private static EditPointsPopup popup = null;
    LineList lineList = null;
    Line currentLine = null;
    LinePoint selectedPoint = null;
    Line selectedLine = null;
    int leftBoundaryX = -1;
    int rightBoundaryX = -1;
    boolean locked = false;
    TableModelListener lineListener = null;

    public LineCanvas() {
        new LineCanvasMouseListener(this);
        this.lineListener = e -> this.repaint();
    }

    public void setLineList(LineList lineList) {
        this.lineList = lineList;
        this.currentLine = null;
        this.repaint();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.repaint();
    }

    public void setSelectedLine(Line line) {
        if (this.currentLine == line) {
            return;
        }
        if (this.currentLine != null) {
            this.currentLine.removeTableModelListener(this.lineListener);
        }
        this.currentLine = line;
        if (this.currentLine != null) {
            this.currentLine.addTableModelListener(this.lineListener);
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHints(hints);
        g2d.setColor(Color.black);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(Color.lightGray);
        g2d.drawRect(5, 5, this.getWidth() - 10, this.getHeight() - 10);
        Color currentColor = null;
        if (this.lineList == null) {
            return;
        }
        for (Line line : this.lineList) {
            if (line == this.currentLine) {
                currentColor = line.getColor();
                continue;
            }
            g2d.setColor(line.getColor().darker());
            this.drawLine(g2d, line, false);
        }
        if (currentColor != null) {
            g2d.setColor(currentColor);
            this.drawLine(g2d, this.currentLine, true);
        }
        if (this.selectedPoint != null) {
            double min = this.currentLine.getMin();
            double max = this.currentLine.getMax();
            int x = this.doubleToScreenX(this.selectedPoint.getX());
            int y = this.doubleToScreenY(this.selectedPoint.getY(), min, max);
            g2d.setColor(Color.red);
            this.paintPoint(g2d, x, y);
            if (this.currentLine != null) {
                this.drawPointInformation(g2d, x, y);
            }
        }
    }

    private void drawPointInformation(Graphics2D g2d, int x, int y) {
        g2d.setColor(Color.white);
        double range = this.currentLine.getMax() - this.currentLine.getMin();
        double yVal = this.selectedPoint.getY();
        double xVal = this.selectedPoint.getX();
        String xText = "x: " + NumberUtilities.formatDouble((double)xVal);
        String yText = "y: " + NumberUtilities.formatDouble((double)yVal);
        int width = 95;
        int height = 28;
        int xLoc = x + 5;
        int yLoc = y + 5;
        if (x + width > this.getWidth()) {
            xLoc = x - width - 5;
        }
        if (y + height > this.getHeight()) {
            yLoc = y - 14 - 5;
        }
        g2d.drawString(xText, xLoc, yLoc);
        g2d.drawString(yText, xLoc, yLoc + 14);
    }

    private final void drawLine(Graphics g, Line line, boolean drawPoints) {
        int i;
        double min = line.getMin();
        double max = line.getMax();
        int[] xValues = new int[line.size()];
        int[] yValues = new int[line.size()];
        for (i = 0; i < line.size(); ++i) {
            LinePoint point = line.getLinePoint(i);
            xValues[i] = this.doubleToScreenX(point.getX());
            yValues[i] = this.doubleToScreenY(point.getY(), min, max);
        }
        g.drawPolyline(xValues, yValues, xValues.length);
        if (drawPoints) {
            for (i = 0; i < xValues.length; ++i) {
                this.paintPoint(g, xValues[i], yValues[i]);
            }
        }
    }

    private final void paintPoint(Graphics g, int x, int y) {
        g.fillRect(x - 2, y - 2, 5, 5);
    }

    private int doubleToScreenX(double val) {
        int width = this.getWidth() - 10;
        return (int)Math.round(val * (double)width) + 5;
    }

    private int doubleToScreenY(double yVal, double min, double max) {
        int height = this.getHeight() - 10;
        double range = max - min;
        double percent = (yVal - min) / range;
        int y = (int)Math.round((double)height * (1.0 - percent)) + 5;
        return y;
    }

    private double screenToDoubleX(int val) {
        double width = this.getWidth() - 10;
        return (double)(val - 5) / width;
    }

    private double screenToDoubleY(int val, double min, double max) {
        double height = this.getHeight() - 10;
        double percent = 1.0 - (double)(val - 5) / height;
        double range = max - min;
        return percent * range + min;
    }

    public void setBoundaryXValues() {
        if (this.selectedPoint == null) {
            return;
        }
        if (this.selectedPoint == this.currentLine.getLinePoint(0)) {
            this.leftBoundaryX = 5;
            this.rightBoundaryX = 5;
            return;
        }
        if (this.selectedPoint == this.currentLine.getLinePoint(this.currentLine.size() - 1)) {
            this.leftBoundaryX = this.getWidth() - 5;
            this.rightBoundaryX = this.getWidth() - 5;
            return;
        }
        for (int i = 0; i < this.currentLine.size(); ++i) {
            if (this.currentLine.getLinePoint(i) != this.selectedPoint) continue;
            LinePoint p1 = this.currentLine.getLinePoint(i - 1);
            LinePoint p2 = this.currentLine.getLinePoint(i + 1);
            this.leftBoundaryX = this.doubleToScreenX(p1.getX());
            this.rightBoundaryX = this.doubleToScreenX(p2.getX());
            return;
        }
    }

    protected LinePoint insertGraphPoint(int x, int y) {
        if (x < 5 || x > this.getWidth() - 5 || y < 5 || y > this.getHeight() - 5) {
            return null;
        }
        double min = this.currentLine.getMin();
        double max = this.currentLine.getMax();
        LinePoint point = new LinePoint();
        point.setLocation(this.screenToDoubleX(x), this.screenToDoubleY(y, min, max));
        int index = 1;
        for (int i = 0; i < this.currentLine.size() - 1; ++i) {
            LinePoint p1 = this.currentLine.getLinePoint(i);
            LinePoint p2 = this.currentLine.getLinePoint(i + 1);
            if (!(point.getX() >= p1.getX()) || !(point.getX() <= p2.getX())) continue;
            index = i + 1;
            break;
        }
        this.currentLine.addLinePoint(index, point);
        return point;
    }

    public LinePoint findGraphPoint(int x, int y) {
        double min = this.currentLine.getMin();
        double max = this.currentLine.getMax();
        for (int i = 0; i < this.currentLine.size(); ++i) {
            LinePoint point = this.currentLine.getLinePoint(i);
            int tempX = this.doubleToScreenX(point.getX());
            int tempY = this.doubleToScreenY(point.getY(), min, max);
            if (tempX < x - 2 || tempX > x + 2 || tempY < y - 2 || tempY > y + 2) continue;
            return point;
        }
        return null;
    }

    public LinePoint findGraphPoint(int x) {
        for (int i = 0; i < this.currentLine.size(); ++i) {
            LinePoint point = this.currentLine.getLinePoint(i);
            int tempX = this.doubleToScreenX(point.getX());
            if (tempX < x - 2 || tempX > x + 2) continue;
            return point;
        }
        return null;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.currentLine != null) {
            this.currentLine.addTableModelListener(this.lineListener);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.currentLine != null) {
            this.currentLine.removeTableModelListener(this.lineListener);
        }
    }

    class EditPointsPopup
    extends JPopupMenu {
        Line line = null;

        public EditPointsPopup() {
            this.add(new AbstractAction("Edit Points"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LineEditorDialog dialog = LineEditorDialog.getInstance(EditPointsPopup.this.getInvoker());
                    dialog.setLine(EditPointsPopup.this.line);
                    dialog.ask();
                }
            });
        }

        public void setLine(Line line) {
            this.line = line;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            if (this.line != null) {
                super.show(invoker, x, y);
            }
        }
    }

    class LineCanvasMouseListener
    implements MouseListener,
    MouseMotionListener {
        LineCanvas lineCanvas;
        DragDirection direction = DragDirection.NOT_SET;
        Point pressPoint = null;

        public LineCanvasMouseListener(LineCanvas lineCanvas) {
            this.lineCanvas = lineCanvas;
            lineCanvas.addMouseListener(this);
            lineCanvas.addMouseMotionListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (LineCanvas.this.currentLine == null) {
                return;
            }
            this.pressPoint = e.getPoint();
            if (LineCanvas.this.selectedLine == null) {
                if (LineCanvas.this.selectedPoint != null) {
                    if (UiUtilities.isRightMouseButton((MouseEvent)e) && !this.lineCanvas.isLocked()) {
                        LinePoint first = LineCanvas.this.currentLine.getLinePoint(0);
                        LinePoint last = LineCanvas.this.currentLine.getLinePoint(LineCanvas.this.currentLine.size() - 1);
                        if (LineCanvas.this.selectedPoint != first && LineCanvas.this.selectedPoint != last) {
                            LineCanvas.this.currentLine.removeLinePoint(LineCanvas.this.selectedPoint);
                            LineCanvas.this.selectedPoint = null;
                        }
                    } else {
                        LineCanvas.this.setBoundaryXValues();
                    }
                } else if (SwingUtilities.isLeftMouseButton(e)) {
                    if (!this.lineCanvas.isLocked()) {
                        LineCanvas.this.selectedPoint = LineCanvas.this.insertGraphPoint(e.getX(), e.getY());
                        LineCanvas.this.setBoundaryXValues();
                    }
                } else if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    if (popup == null) {
                        popup = new EditPointsPopup();
                    }
                    popup.setLine(LineCanvas.this.currentLine);
                    popup.show((Component)e.getSource(), e.getX(), e.getY());
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.direction = DragDirection.NOT_SET;
            if (LineCanvas.this.currentLine == null) {
                return;
            }
            LineCanvas.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (LineCanvas.this.currentLine == null) {
                return;
            }
            if (LineCanvas.this.selectedPoint != null) {
                int x = e.getX();
                int y = e.getY();
                if (this.direction == DragDirection.NOT_SET) {
                    int magy;
                    int magx = Math.abs(x - (int)this.pressPoint.getX());
                    DragDirection dragDirection = this.direction = magx > (magy = Math.abs(y - (int)this.pressPoint.getY())) ? DragDirection.LEFT_RIGHT : DragDirection.UP_DOWN;
                }
                if (e.isControlDown()) {
                    if (this.direction == DragDirection.LEFT_RIGHT) {
                        y = (int)this.pressPoint.getY();
                    } else {
                        x = (int)this.pressPoint.getX();
                    }
                }
                int topY = 5;
                int bottomY = LineCanvas.this.getHeight() - 5;
                if (x < LineCanvas.this.leftBoundaryX) {
                    x = LineCanvas.this.leftBoundaryX;
                } else if (x > LineCanvas.this.rightBoundaryX) {
                    x = LineCanvas.this.rightBoundaryX;
                }
                if (y < topY) {
                    y = topY;
                } else if (y > bottomY) {
                    y = bottomY;
                }
                double min = LineCanvas.this.currentLine.getMin();
                double max = LineCanvas.this.currentLine.getMax();
                double doubleYValue = LineCanvas.this.screenToDoubleY(y, min, max);
                LineCanvas.this.selectedPoint.setLocation(LineCanvas.this.screenToDoubleX(x), doubleYValue);
                if (LineCanvas.this.currentLine.isEndPointsLinked()) {
                    LinePoint first = LineCanvas.this.currentLine.getLinePoint(0);
                    LinePoint last = LineCanvas.this.currentLine.getLinePoint(LineCanvas.this.currentLine.getRowCount() - 1);
                    if (LineCanvas.this.selectedPoint == first) {
                        last.setLocation(last.getX(), doubleYValue);
                    } else if (LineCanvas.this.selectedPoint == last) {
                        first.setLocation(first.getX(), doubleYValue);
                    }
                }
                LineCanvas.this.repaint();
            } else if (LineCanvas.this.selectedLine != null) {
                // empty if block
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int y;
            if (LineCanvas.this.currentLine == null) {
                return;
            }
            int x = e.getX();
            LinePoint foundPoint = LineCanvas.this.findGraphPoint(x, y = e.getY());
            if (foundPoint != null) {
                if (LineCanvas.this.selectedPoint != foundPoint) {
                    LineCanvas.this.selectedPoint = foundPoint;
                    LineCanvas.this.repaint();
                }
            } else if (LineCanvas.this.selectedPoint != null) {
                LineCanvas.this.selectedPoint = null;
                LineCanvas.this.repaint();
            }
        }
    }
}

