/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder;

import blue.BlueSystem;
import blue.orchestra.blueSynthBuilder.BSBDropdownItem;
import javafx.collections.ObservableList;
import javax.swing.table.AbstractTableModel;

final class DropdownItemsTableModel
extends AbstractTableModel {
    private ObservableList<BSBDropdownItem> items;

    public void setDropdownItems(ObservableList<BSBDropdownItem> items) {
        this.items = items;
        this.fireTableDataChanged();
    }

    public void addDropdownItem() {
        BSBDropdownItem item = new BSBDropdownItem();
        item.setName(BlueSystem.getString((String)"propertyEditor.name"));
        item.setValue(BlueSystem.getString((String)"propertyEditor.value"));
        this.items.add((Object)item);
        this.fireTableRowsInserted(this.items.size() - 1, this.items.size() - 1);
    }

    public void removeDropdownItem(int index) {
        if (index < 0) {
            return;
        }
        this.items.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void pushUpItem(int index) {
        if (index > 0) {
            BSBDropdownItem a = (BSBDropdownItem)this.items.remove(index - 1);
            this.items.add(index, (Object)a);
            this.fireTableRowsUpdated(index - 1, index);
        }
    }

    public void pushDownItem(int index) {
        if (index < this.items.size() - 1) {
            BSBDropdownItem a = (BSBDropdownItem)this.items.remove(index + 1);
            this.items.add(index, (Object)a);
            this.fireTableRowsUpdated(index, index + 1);
        }
    }

    @Override
    public String getColumnName(int i) {
        if (i == 0) {
            return BlueSystem.getString((String)"propertyEditor.name");
        }
        if (i == 1) {
            return BlueSystem.getString((String)"propertyEditor.value");
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        BSBDropdownItem item = (BSBDropdownItem)this.items.get(row);
        if (col == 0) {
            return item.getName();
        }
        if (col == 1) {
            return item.getValue();
        }
        System.err.println("error in DropdownItemsTableModel::getValueAt()");
        return null;
    }

    @Override
    public int getRowCount() {
        if (this.items != null) {
            return this.items.size();
        }
        return 0;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return true;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        try {
            String val = (String)value;
            BSBDropdownItem item = (BSBDropdownItem)this.items.get(row);
            if (col == 0) {
                item.setName(val);
            } else if (col == 1) {
                item.setValue(val);
            }
        }
        catch (Exception e) {
            System.out.println("error in DropdownItemsModel: setValueAt");
            e.printStackTrace();
        }
        this.fireTableCellUpdated(row, col);
    }
}

