/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.editor.blueSynthBuilder.jfx.Alignment;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javafx.scene.layout.Pane;

public class AlignmentUtils {
    private static Comparator<Pane> leftComparator = new Comparator<Pane>(){

        @Override
        public int compare(Pane a, Pane b) {
            return Double.compare(a.getLayoutX(), b.getLayoutX());
        }
    };
    private static Comparator<Pane> horizontalCenterComparator = new Comparator<Pane>(){

        @Override
        public int compare(Pane a, Pane b) {
            double center1 = a.getLayoutX() + a.getWidth() / 2.0;
            double center2 = b.getLayoutX() + b.getWidth() / 2.0;
            return Double.compare(center1, center2);
        }
    };
    private static Comparator<Pane> rightComparator = new Comparator<Pane>(){

        @Override
        public int compare(Pane a, Pane b) {
            double right1 = a.getLayoutX() + a.getWidth();
            double right2 = b.getLayoutX() + b.getWidth();
            return Double.compare(right1, right2);
        }
    };
    private static Comparator<Pane> topComparator = new Comparator<Pane>(){

        @Override
        public int compare(Pane a, Pane b) {
            return Double.compare(a.getLayoutY(), b.getLayoutY());
        }
    };
    private static Comparator<Pane> verticalCenterComparator = new Comparator<Pane>(){

        @Override
        public int compare(Pane a, Pane b) {
            double center1 = a.getLayoutY() + a.getHeight() / 2.0;
            double center2 = b.getLayoutY() + b.getHeight() / 2.0;
            return Double.compare(center1, center2);
        }
    };
    private static Comparator<Pane> bottomComparator = new Comparator<Pane>(){

        @Override
        public int compare(Pane a, Pane b) {
            double bottom1 = a.getLayoutY() + a.getHeight();
            double bottom2 = b.getLayoutY() + b.getHeight();
            return Double.compare(bottom1, bottom2);
        }
    };

    public static void align(List<? extends Pane> panes, Alignment type) {
        switch (type) {
            case LEFT: {
                Optional leftPane = panes.stream().min((o1, o2) -> Double.compare(o1.getLayoutX(), o2.getLayoutX()));
                if (!leftPane.isPresent()) break;
                int x = (int)((Pane)leftPane.get()).getLayoutX();
                for (Pane pane : panes) {
                    BSBObject bSBObject = (BSBObject)pane.getUserData();
                    bSBObject.setX(x);
                }
                break;
            }
            case HORIZONTAL_CENTER: {
                double left = 2.147483647E9;
                double right = 0.0;
                for (Pane pane : panes) {
                    double d;
                    if (pane.getLayoutX() < left) {
                        left = pane.getLayoutX();
                    }
                    if (!((d = pane.getLayoutX() + pane.getWidth()) > right)) continue;
                    right = d;
                }
                double center = (right - left) / 2.0 + left;
                for (Pane pane : panes) {
                    BSBObject bSBObject = (BSBObject)pane.getUserData();
                    int n = (int)(center - pane.getWidth() / 2.0);
                    bSBObject.setX(n);
                }
                break;
            }
            case RIGHT: {
                double right = 0.0;
                for (Pane pane : panes) {
                    double d = pane.getLayoutX() + pane.getWidth();
                    if (!(d > right)) continue;
                    right = d;
                }
                for (Pane pane : panes) {
                    BSBObject bSBObject = (BSBObject)pane.getUserData();
                    bSBObject.setX((int)(right - pane.getWidth()));
                }
                break;
            }
            case TOP: {
                Optional topPane = panes.stream().min((o1, o2) -> Double.compare(o1.getLayoutY(), o2.getLayoutY()));
                if (!topPane.isPresent()) break;
                int n = (int)((Pane)topPane.get()).getLayoutY();
                for (Pane pane : panes) {
                    BSBObject bsbObj = (BSBObject)pane.getUserData();
                    bsbObj.setY(n);
                }
                break;
            }
            case VERTICAL_CENTER: {
                double top = 2.147483647E9;
                double bottom = 0.0;
                for (Pane pane : panes) {
                    double d;
                    if (pane.getLayoutY() < top) {
                        top = pane.getLayoutY();
                    }
                    if (!((d = pane.getLayoutY() + pane.getHeight()) > bottom)) continue;
                    bottom = d;
                }
                double center = (bottom - top) / 2.0 + top;
                for (Pane pane : panes) {
                    BSBObject bSBObject = (BSBObject)pane.getUserData();
                    int newY = (int)(center - pane.getHeight() / 2.0);
                    bSBObject.setY(newY);
                }
                break;
            }
            case BOTTOM: {
                double bottom = 0.0;
                for (Pane pane : panes) {
                    double d = pane.getLayoutY() + pane.getHeight();
                    if (!(d > bottom)) continue;
                    bottom = d;
                }
                for (Pane pane : panes) {
                    BSBObject bSBObject = (BSBObject)pane.getUserData();
                    bSBObject.setY((int)(bottom - pane.getHeight()));
                }
                break;
            }
        }
    }

    public static void distribute(List<? extends Pane> panes, Alignment type) {
        if (panes == null || panes.size() < 3) {
            return;
        }
        int size = panes.size();
        switch (type) {
            case LEFT: {
                Collections.sort(panes, leftComparator);
                Pane first = panes.get(0);
                Pane last = panes.get(size - 1);
                double spacing = (last.getLayoutX() - first.getLayoutX()) / (double)(size - 1);
                for (int i = 1; i < size - 1; ++i) {
                    Pane pane = panes.get(i);
                    BSBObject bsbObj = (BSBObject)pane.getUserData();
                    int newX = (int)((double)i * spacing + first.getLayoutX());
                    bsbObj.setX(newX);
                }
                break;
            }
            case HORIZONTAL_CENTER: {
                Collections.sort(panes, horizontalCenterComparator);
                Pane first = panes.get(0);
                Pane last = panes.get(size - 1);
                double firstCenter = first.getLayoutX() + first.getWidth() / 2.0;
                double lastCenter = last.getLayoutX() + last.getWidth() / 2.0;
                double spacing = (lastCenter - firstCenter) / (double)(size - 1);
                for (int i = 1; i < size - 1; ++i) {
                    Pane pane = panes.get(i);
                    BSBObject bsbObj = (BSBObject)pane.getUserData();
                    int newX = (int)((double)i * spacing + firstCenter);
                    bsbObj.setX(newX -= (int)(pane.getWidth() / 2.0));
                }
                break;
            }
            case RIGHT: {
                Collections.sort(panes, rightComparator);
                Pane first = panes.get(0);
                Pane last = panes.get(size - 1);
                double spacing = (last.getLayoutX() + last.getWidth() - (first.getLayoutX() + first.getWidth())) / (double)(size - 1);
                for (int i = 1; i < size - 1; ++i) {
                    Pane pane = panes.get(i);
                    BSBObject bsbObj = (BSBObject)pane.getUserData();
                    int newX = (int)((double)i * spacing + first.getLayoutX() + first.getWidth());
                    bsbObj.setX(newX -= (int)pane.getWidth());
                }
                break;
            }
            case TOP: {
                Collections.sort(panes, topComparator);
                Pane first = panes.get(0);
                Pane last = panes.get(size - 1);
                double spacing = (last.getLayoutY() - first.getLayoutY()) / (double)(size - 1);
                for (int i = 1; i < size - 1; ++i) {
                    Pane pane = panes.get(i);
                    BSBObject bsbObj = (BSBObject)pane.getUserData();
                    int newY = (int)((double)i * spacing + first.getLayoutY());
                    bsbObj.setY(newY);
                }
                break;
            }
            case VERTICAL_CENTER: {
                Collections.sort(panes, verticalCenterComparator);
                Pane first = panes.get(0);
                Pane last = panes.get(size - 1);
                double firstCenter = first.getLayoutY() + first.getHeight() / 2.0;
                double lastCenter = last.getLayoutY() + last.getHeight() / 2.0;
                double spacing = (lastCenter - firstCenter) / (double)(size - 1);
                for (int i = 1; i < size - 1; ++i) {
                    Pane pane = panes.get(i);
                    BSBObject bsbObj = (BSBObject)pane.getUserData();
                    int newY = (int)((double)i * spacing + firstCenter);
                    bsbObj.setY(newY -= (int)(pane.getHeight() / 2.0));
                }
                break;
            }
            case BOTTOM: {
                Collections.sort(panes, bottomComparator);
                Pane first = panes.get(0);
                Pane last = panes.get(size - 1);
                double spacing = (last.getLayoutY() + last.getHeight() - (first.getLayoutY() + first.getHeight())) / (double)(size - 1);
                for (int i = 1; i < size - 1; ++i) {
                    Pane pane = panes.get(i);
                    BSBObject bsbObj = (BSBObject)pane.getUserData();
                    int newY = (int)((double)i * spacing + first.getLayoutY() + first.getHeight());
                    bsbObj.setY(newY -= (int)pane.getHeight());
                }
                break;
            }
        }
    }
}

