/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.BlueSystem;
import blue.orchestra.blueSynthBuilder.BSBFileSelector;
import blue.orchestra.editor.blueSynthBuilder.jfx.ResizeableView;
import blue.ui.utilities.FileChooserManager;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;

public class BSBFileSelectorView
extends BorderPane
implements ResizeableView {
    private static final int FILE_BUTTON_WIDTH = 30;
    private static int OBJECT_HEIGHT = 30;
    private static String FILE_SELECTOR_ID = "BSBFileSelector";
    private final BSBFileSelector fileSelector;
    TextField fileNameField;

    public BSBFileSelectorView(final BSBFileSelector fileSelector) {
        this.setUserData(fileSelector);
        this.fileSelector = fileSelector;
        this.fileNameField = new TextField();
        this.fileNameField.setPrefHeight((double)OBJECT_HEIGHT);
        this.fileNameField.setEditable(false);
        this.fileNameField.setPromptText("Select a File");
        MenuItem clearMenuItem = new MenuItem("Clear");
        clearMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                fileSelector.fileNameProperty().set((Object)"");
            }
        });
        ContextMenu menu = new ContextMenu(new MenuItem[]{clearMenuItem});
        this.fileNameField.setContextMenu(menu);
        Button btn = new Button("...");
        btn.setPrefWidth(30.0);
        btn.setPrefHeight((double)OBJECT_HEIGHT);
        this.setCenter((Node)this.fileNameField);
        this.setRight((Node)btn);
        btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                List rValue;
                File file;
                String fileName = fileSelector.getFileName();
                if (fileName != null && fileName.trim().length() > 0 && (file = BlueSystem.findFile((String)fileName)) != null) {
                    FileChooserManager.getDefault().setSelectedFile((Object)FILE_SELECTOR_ID, file);
                }
                if (!(rValue = FileChooserManager.getDefault().showOpenDialog((Object)FILE_SELECTOR_ID, null)).isEmpty()) {
                    File f = (File)rValue.get(0);
                    try {
                        String absFilePath = f.getCanonicalPath();
                        String relPath = BlueSystem.getRelativePath((String)absFilePath);
                        System.out.println("Rel Path: " + relPath);
                        fileSelector.setFileName(relPath);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                Dragboard dragboard = event.getDragboard();
                if (dragboard.hasFiles() || dragboard.hasString() || dragboard.hasUrl()) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.LINK});
                }
                event.consume();
            }
        });
        this.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                Dragboard dragboard = event.getDragboard();
                if (dragboard.hasFiles()) {
                    List files = dragboard.getFiles();
                    if (files.size() != 1) {
                        event.setDropCompleted(false);
                        event.consume();
                        return;
                    }
                    File f = (File)files.get(0);
                    if (f.exists() && f.isFile()) {
                        try {
                            String absFilePath = f.getCanonicalPath();
                            String relPath = BlueSystem.getRelativePath((String)absFilePath);
                            fileSelector.setFileName(relPath);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        event.setDropCompleted(true);
                        event.consume();
                        return;
                    }
                    event.setDropCompleted(false);
                } else if (dragboard.hasString()) {
                    String s = dragboard.getString().trim();
                    if (!s.startsWith("file://")) {
                        event.setDropCompleted(false);
                        event.consume();
                        return;
                    }
                    s = s.substring(7).trim();
                    s = URLDecoder.decode(s);
                    File f = new File(s = s.replaceAll(" ", "\\ "));
                    if (f.exists() && f.isFile()) {
                        try {
                            String absFilePath = f.getCanonicalPath();
                            String relPath = BlueSystem.getRelativePath((String)absFilePath);
                            fileSelector.setFileName(relPath);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        event.setDropCompleted(true);
                        event.consume();
                        return;
                    }
                } else if (dragboard.hasUrl()) {
                    String val = dragboard.getUrl();
                    System.out.println("URL: " + val);
                    File f = new File(val);
                    if (f.exists() && f.isFile()) {
                        try {
                            String absFilePath = f.getCanonicalPath();
                            String relPath = BlueSystem.getRelativePath((String)absFilePath);
                            fileSelector.setFileName(relPath);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        event.setDropCompleted(true);
                        event.consume();
                        return;
                    }
                }
                event.setDropCompleted(false);
            }
        });
        this.sceneProperty().addListener((obs, old, newVal) -> {
            if (newVal == null) {
                this.fileNameField.textProperty().unbind();
                this.fileNameField.prefWidthProperty().unbind();
            } else {
                this.fileNameField.textProperty().bind((ObservableValue)fileSelector.fileNameProperty());
                this.fileNameField.prefWidthProperty().bind((ObservableValue)fileSelector.textFieldWidthProperty());
            }
        });
    }

    @Override
    public boolean canResizeWidgetWidth() {
        return true;
    }

    @Override
    public boolean canResizeWidgetHeight() {
        return false;
    }

    @Override
    public int getWidgetMinimumWidth() {
        return 40;
    }

    @Override
    public int getWidgetMinimumHeight() {
        return -1;
    }

    @Override
    public int getWidgetWidth() {
        return this.fileSelector.getTextFieldWidth();
    }

    @Override
    public void setWidgetWidth(int width) {
        this.fileSelector.setTextFieldWidth(Math.max(10, width));
    }

    @Override
    public int getWidgetHeight() {
        return -1;
    }

    @Override
    public void setWidgetHeight(int height) {
    }

    @Override
    public void setWidgetX(int x) {
        this.fileSelector.setX(x);
    }

    @Override
    public int getWidgetX() {
        return this.fileSelector.getX();
    }

    @Override
    public void setWidgetY(int y) {
    }

    @Override
    public int getWidgetY() {
        return -1;
    }
}

