/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.components.lines.Line;
import blue.components.lines.LineList;
import blue.jfx.BlueFX;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class LineSelector
extends HBox {
    ObjectProperty<Line> selectedLine = new SimpleObjectProperty();
    public Button leftButton;
    public Button rightButton;
    private final LineList lineList;

    public LineSelector(LineList lineList) {
        this.lineList = lineList;
        Label label = new Label();
        this.leftButton = new Button();
        this.leftButton.getStyleClass().add((Object)"left-arrow");
        this.leftButton.setOnAction(e -> this.previousLine());
        this.leftButton.setOnAction(e -> this.previousLine());
        this.leftButton.setMaxHeight(Double.MAX_VALUE);
        this.rightButton = new Button();
        this.rightButton.getStyleClass().add((Object)"right-arrow");
        this.rightButton.setOnAction(e -> this.nextLine());
        this.rightButton.setMaxHeight(Double.MAX_VALUE);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setMaxHeight(Double.MAX_VALUE);
        HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{label, this.leftButton, this.rightButton});
        this.selectedLine.addListener((obs, old, newVal) -> {
            String lblText = newVal == null ? "" : newVal.getVarName();
            label.setText(lblText);
        });
        if (lineList.size() > 0) {
            this.setSelectedLine((Line)lineList.get(0));
        }
        ListChangeListener lcl = e -> BlueFX.runOnFXThread(() -> {
            if (this.getSelectedLine() == null || !lineList.contains((Object)this.getSelectedLine())) {
                if (lineList.size() > 0) {
                    this.setSelectedLine((Line)lineList.get(0));
                } else {
                    this.setSelectedLine(null);
                }
            }
        });
        this.sceneProperty().addListener((obs, old, newVal) -> {
            if (newVal == null) {
                lineList.removeListener(lcl);
            } else {
                lineList.addListener(lcl);
            }
        });
    }

    private void nextLine() {
        Line line = this.getSelectedLine();
        if (line == null || this.lineList.size() < 2) {
            return;
        }
        int index = this.lineList.indexOf((Object)line) + 1;
        if (index >= this.lineList.size()) {
            index = 0;
        }
        this.setSelectedLine((Line)this.lineList.get(index));
    }

    private void previousLine() {
        Line line = this.getSelectedLine();
        if (line == null || this.lineList.size() < 2) {
            return;
        }
        int index = this.lineList.indexOf((Object)line) - 1;
        if (index < 0) {
            index = this.lineList.size() - 1;
        }
        this.setSelectedLine((Line)this.lineList.get(index));
    }

    public void setSelectedLine(Line line) {
        this.selectedLine.set((Object)line);
    }

    public Line getSelectedLine() {
        return (Line)this.selectedLine.get();
    }

    public ObjectProperty<Line> selectedLineProperty() {
        return this.selectedLine;
    }
}

