/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx.editors;

import java.util.function.Predicate;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;
import org.controlsfx.control.PropertySheet;

public class StringPropertyEditor
extends TextField {
    Predicate<String> validator = null;
    PropertySheet.Item item;
    boolean editing = false;

    public StringPropertyEditor(PropertySheet.Item item) {
        this.item = item;
        this.setOnAction(e -> this.updateTextFromTextField());
        this.focusedProperty().addListener((obs, o, n) -> {
            if (o.booleanValue() && !n.booleanValue()) {
                this.editing = false;
                this.updateTextFromTextField();
            } else {
                this.editing = true;
            }
        });
        ChangeListener listener = (obs, old, newVal) -> {
            if (!this.editing) {
                this.setText(newVal.toString());
            }
        };
        this.sceneProperty().addListener((obs, old, newVal) -> {
            if (newVal == null) {
                if (item.getObservableValue().isPresent()) {
                    ((ObservableValue)item.getObservableValue().get()).removeListener(listener);
                }
            } else if (item.getObservableValue().isPresent()) {
                ((ObservableValue)item.getObservableValue().get()).addListener(listener);
            }
        });
    }

    private void updateTextFromTextField() {
        String newValue = this.getText();
        if (newValue.equals(this.item.getValue())) {
            return;
        }
        if (this.validator == null || this.validator.test(newValue)) {
            this.item.setValue((Object)newValue);
        }
    }

    public void setValidator(Predicate<String> validator) {
        this.validator = validator;
    }
}

