/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.blueShare.instruments;

import blue.BlueSystem;
import blue.InstrumentLibrary;
import blue.orchestra.Instrument;
import blue.tools.blueShare.BlueShareRemoteCaller;
import blue.tools.blueShare.instruments.BlueShareInstrumentCategory;
import blue.tools.blueShare.instruments.InstrumentOption;
import blue.tools.blueShare.instruments.InstrumentOptionTableModel;
import blue.utility.GUI;
import electric.xml.ParseException;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.xmlrpc.XmlRpcException;

public class InstrumentImportPane
extends JComponent {
    private String AVAILABLE_INSTRUMENTS_LABEL = BlueSystem.getString((String)"blueShare.availableInstruments");
    JSplitPane mainSplitPane = new JSplitPane();
    JPanel categoriesPanel = new JPanel();
    JSplitPane rightSplitPane = new JSplitPane();
    JPanel iListPanel = new JPanel();
    JLabel iOptionsLabel = new JLabel();
    JPanel instrumentInfoPanel = new JPanel();
    JPanel instrumentTopPanel = new JPanel();
    JLabel iNameLabel = new JLabel();
    JLabel submittedByLabel = new JLabel();
    JLabel iTypeLabel = new JLabel();
    JTextField iTypeText = new JTextField();
    JTextField iNameText = new JTextField();
    JTextField userText = new JTextField();
    JTextArea iDescription = new JTextArea();
    JPanel importButtonPanel = new JPanel();
    JButton importButton = new JButton();
    JTree categoryTree = new JTree();
    JTable instrumentTable = new JTable();
    InstrumentOptionTableModel iTableModel = new InstrumentOptionTableModel();
    JPanel instrumentPanel = new JPanel();
    CardLayout cards = new CardLayout();
    JPanel instrCardPanel = new JPanel();
    CardLayout iListCard = new CardLayout();

    public InstrumentImportPane() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.categoriesPanel.setLayout(new BorderLayout());
        JLabel categoriesLabel = new JLabel(BlueSystem.getString((String)"common.categories"));
        this.rightSplitPane.setOrientation(0);
        this.iListPanel.setLayout(new BorderLayout());
        this.iOptionsLabel.setText(this.AVAILABLE_INSTRUMENTS_LABEL);
        this.instrumentInfoPanel.setLayout(new BorderLayout());
        this.instrumentTopPanel.setLayout(new GridBagLayout());
        this.iNameLabel.setText(BlueSystem.getString((String)"blueShare.instrumentNameLabel"));
        this.submittedByLabel.setText(BlueSystem.getString((String)"blueShare.submittedByLabel"));
        this.iTypeLabel.setText(BlueSystem.getString((String)"blueShare.instrumentType"));
        this.instrumentInfoPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.iListPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.categoriesPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.importButton.setText(BlueSystem.getString((String)"blueShare.importInstrument"));
        JScrollPane categoryScrollPane = new JScrollPane(this.categoryTree);
        this.add((Component)this.mainSplitPane, "Center");
        this.mainSplitPane.add((Component)this.categoriesPanel, "left");
        this.categoriesPanel.add((Component)categoryScrollPane, "Center");
        this.categoriesPanel.add((Component)categoriesLabel, "North");
        this.mainSplitPane.add((Component)this.rightSplitPane, "right");
        this.rightSplitPane.add((Component)this.iListPanel, "top");
        JLabel tempLabel = new JLabel(BlueSystem.getString((String)"blueShare.noInstrumentsForCategory"));
        tempLabel.setHorizontalAlignment(0);
        JScrollPane instrScrollPane = new JScrollPane(this.instrumentTable);
        this.instrCardPanel.setLayout(this.iListCard);
        this.instrCardPanel.add((Component)instrScrollPane, "iList");
        this.instrCardPanel.add((Component)tempLabel, "none");
        this.iListPanel.add((Component)this.instrCardPanel, "Center");
        this.iListPanel.add((Component)this.iOptionsLabel, "North");
        this.instrumentPanel.setLayout(this.cards);
        this.instrumentPanel.add((Component)this.instrumentInfoPanel, "instrumentInfo");
        tempLabel = new JLabel(BlueSystem.getString((String)"blueShare.selectInstrument"));
        tempLabel.setHorizontalAlignment(0);
        this.instrumentPanel.add((Component)tempLabel, "blank");
        this.setInstrumentEnabled(false);
        this.rightSplitPane.add((Component)this.instrumentPanel, "bottom");
        this.instrumentInfoPanel.add((Component)this.instrumentTopPanel, "North");
        this.instrumentTopPanel.add((Component)this.iNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.instrumentTopPanel.add((Component)this.submittedByLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.instrumentTopPanel.add((Component)this.iTypeText, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 1), 0, 0));
        this.instrumentTopPanel.add((Component)this.userText, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 1), 0, 0));
        JScrollPane descriptionScroll = new JScrollPane();
        this.instrumentInfoPanel.add((Component)descriptionScroll, "Center");
        this.instrumentInfoPanel.add((Component)this.importButtonPanel, "South");
        descriptionScroll.getViewport().add((Component)this.iDescription, null);
        this.instrumentTopPanel.add((Component)this.iNameText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 1), 0, 0));
        this.instrumentTopPanel.add((Component)this.iTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.importButtonPanel.add((Component)this.importButton, null);
        this.instrumentTable.setModel(this.iTableModel);
        this.iDescription.setLineWrap(true);
        this.mainSplitPane.setDividerLocation(200);
        this.rightSplitPane.setDividerLocation(200);
        this.instrumentTable.setSelectionMode(0);
        this.categoryTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = InstrumentImportPane.this.categoryTree.getClosestRowForLocation(e.getX(), e.getY());
                TreePath path = InstrumentImportPane.this.categoryTree.getClosestPathForLocation(e.getX(), e.getY());
                if (row == -1) {
                    return;
                }
                try {
                    DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                    BlueShareInstrumentCategory tempCat = (BlueShareInstrumentCategory)tempNode.getUserObject();
                    InstrumentImportPane.this.populateInstruments(tempCat);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        });
        this.instrumentTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.populateInstrument();
        });
        this.importButton.addActionListener(e -> this.importInstrument());
    }

    private void populateInstruments(BlueShareInstrumentCategory category) {
        this.iOptionsLabel.setText(this.AVAILABLE_INSTRUMENTS_LABEL + " - " + BlueSystem.getString((String)"blueShare.loading"));
        try {
            InstrumentOption[] options = category.getCategoryId() == Integer.MIN_VALUE ? BlueShareRemoteCaller.getLatestTenInstruments() : BlueShareRemoteCaller.getInstrumentOptions(category);
            this.iTableModel.setInstrumentOptions(options);
            this.setInstrumentEnabled(false);
            if (options.length > 0) {
                this.iListCard.show(this.instrCardPanel, "iList");
            } else {
                this.iListCard.show(this.instrCardPanel, "none");
            }
            this.iOptionsLabel.setText(this.AVAILABLE_INSTRUMENTS_LABEL + " - " + category.getName());
        }
        catch (ParseException pe) {
            String error = BlueSystem.getString((String)"blueShare.selectServer.couldNotReadResponse");
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            this.iTableModel.setInstrumentOptions(null);
            this.iOptionsLabel.setText(this.AVAILABLE_INSTRUMENTS_LABEL + " - " + BlueSystem.getString((String)"message.error"));
            return;
        }
        catch (XmlRpcException xre) {
            String error = "Error: " + xre.getLocalizedMessage();
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            this.iTableModel.setInstrumentOptions(null);
            this.iOptionsLabel.setText(this.AVAILABLE_INSTRUMENTS_LABEL + " - " + BlueSystem.getString((String)"message.error"));
            return;
        }
        catch (IOException ioe) {
            String error = "Error: " + ioe.getLocalizedMessage();
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            this.iTableModel.setInstrumentOptions(null);
            this.iOptionsLabel.setText(this.AVAILABLE_INSTRUMENTS_LABEL + " - " + BlueSystem.getString((String)"message.error"));
            return;
        }
    }

    private void populateInstrument() {
        InstrumentOption iOption = this.iTableModel.getInstrumentOption(this.instrumentTable.getSelectedRow());
        if (iOption != null) {
            this.iNameText.setText(iOption.getName());
            this.iTypeText.setText(iOption.getType());
            this.userText.setText(iOption.getScreenName());
            this.iDescription.setText(iOption.getDescription());
        }
        this.setInstrumentEnabled(true);
    }

    private void setInstrumentEnabled(boolean val) {
        if (val) {
            this.cards.show(this.instrumentPanel, "instrumentInfo");
        } else {
            this.cards.show(this.instrumentPanel, "blank");
        }
    }

    private void importInstrument() {
        InstrumentOption iOption = this.iTableModel.getInstrumentOption(this.instrumentTable.getSelectedRow());
        if (iOption == null) {
            return;
        }
        try {
            Instrument instrument = BlueShareRemoteCaller.getInstrument(iOption);
            if (instrument == null) {
                String error = BlueSystem.getString((String)"blueShare.importError");
                JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
                return;
            }
            InstrumentLibrary instrLib = BlueSystem.getUserInstrumentLibrary();
            instrLib.importInstrument(instrument);
            String message = BlueSystem.getString((String)"blueShare.importSuccess");
            JOptionPane.showMessageDialog(null, message, BlueSystem.getString((String)"common.success"), -1);
        }
        catch (ParseException pe) {
            String error = BlueSystem.getString((String)"blueShare.selectServer.couldNotReadResponse");
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            return;
        }
        catch (XmlRpcException xre) {
            String error = "Error: " + xre.getLocalizedMessage();
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            return;
        }
        catch (IOException ioe) {
            String error = "Error: " + ioe.getLocalizedMessage();
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            return;
        }
    }

    public void setCategories(BlueShareInstrumentCategory[] categories) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(BlueSystem.getString((String)"common.categories"));
        BlueShareInstrumentCategory latestInstruments = new BlueShareInstrumentCategory(Integer.MIN_VALUE, ">Latest Instruments", "Newest Instruments in Repository", null);
        DefaultMutableTreeNode temp = new DefaultMutableTreeNode(latestInstruments);
        root.add(temp);
        this.addSubCategories(root, categories);
        this.categoryTree.setModel(new DefaultTreeModel(root));
    }

    private void addSubCategories(DefaultMutableTreeNode parent, BlueShareInstrumentCategory[] categories) {
        for (int i = 0; i < categories.length; ++i) {
            DefaultMutableTreeNode temp = new DefaultMutableTreeNode(categories[i]);
            parent.add(temp);
            this.addSubCategories(temp, categories[i].getSubCategories());
        }
    }

    public static void main(String[] args) {
        InstrumentImportPane instrumentImportPane1 = new InstrumentImportPane();
        GUI.showComponentAsStandalone((Component)instrumentImportPane1, (String)"Instrument Import Pane Test", (boolean)true);
    }
}

