/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.codeRepository;

import blue.BlueSystem;
import blue.WindowSettingManager;
import blue.WindowSettingsSavable;
import blue.tools.codeRepository.CodeRepositoryDragSource;
import blue.tools.codeRepository.CodeRepositoryDropTarget;
import blue.tools.codeRepository.CodeRepositoryManager;
import blue.tools.codeRepository.CodeRepositoryPopup;
import blue.tools.codeRepository.CodeRepositoryTreeNode;
import blue.tools.codeRepository.ElementHolder;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.ui.utilities.SimpleDocumentListener;
import blue.ui.utilities.UiUtilities;
import blue.utility.GUI;
import electric.xml.Element;
import electric.xml.ParseException;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;
import org.openide.awt.UndoRedo;

public class CodeRepositoryDialog
extends JDialog
implements WindowSettingsSavable {
    private static final CodeRepositoryPopup popup = new CodeRepositoryPopup();
    JSplitPane topSplit = new JSplitPane();
    BorderLayout borderLayout1 = new BorderLayout();
    JTree codeTree;
    DefaultTreeModel treeModel;
    CardLayout cards = new CardLayout();
    ElementHolder selected;
    MimeTypeEditorComponent code1Text = new MimeTypeEditorComponent("text/plain");
    UndoManager undo = new UndoRedo.Manager();
    JPanel editPanel = new JPanel();
    JPanel textPanel = new JPanel();
    JButton okButton = new JButton(BlueSystem.getString((String)"programOptions.okButton"));
    JButton cancelButton = new JButton(BlueSystem.getString((String)"programOptions.cancelButton"));

    public CodeRepositoryDialog(Frame owner) {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(BlueSystem.getString((String)"codeRepository.title"));
        this.setupTree();
        this.getContentPane().setLayout(this.borderLayout1);
        this.getContentPane().add((Component)this.topSplit, "Center");
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setBorder(null);
        this.topSplit.add((Component)jScrollPane1, "left");
        this.topSplit.add((Component)this.editPanel, "right");
        jScrollPane1.getViewport().add((Component)this.codeTree, null);
        this.topSplit.setDividerLocation(200);
        JPanel temp = new JPanel();
        temp.setLayout(new FlowLayout(1));
        temp.add(this.okButton);
        temp.add(this.cancelButton);
        this.okButton.addActionListener(e -> {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.codeTree.getModel().getRoot();
            CodeRepositoryManager.saveCodeRepository(node);
            this.setVisible(false);
        });
        this.cancelButton.addActionListener(e -> this.setVisible(false));
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)temp, "South");
        this.setSize(600, 400);
        GUI.centerOnScreen((Component)this);
        this.textPanel.setLayout(new BorderLayout());
        this.textPanel.add((Component)this.code1Text, "Center");
        this.editPanel.setLayout(this.cards);
        this.editPanel.add((Component)new JPanel(), "disabled");
        this.editPanel.add((Component)this.textPanel, "enabled");
        this.cards.show(this.editPanel, "disabled");
        this.code1Text.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (CodeRepositoryDialog.this.selected != null && !CodeRepositoryDialog.this.selected.isGroup) {
                    CodeRepositoryDialog.this.selected.text = CodeRepositoryDialog.this.code1Text.getText();
                }
            }
        });
        this.code1Text.setUndoManager(this.undo);
        this.code1Text.getDocument().addUndoableEditListener(this.undo);
        new CodeRepositoryDragSource(this.codeTree, 2);
        new CodeRepositoryDropTarget(this.codeTree);
        WindowSettingManager.getInstance().registerWindow("CodeRepositoryDialog", this);
    }

    private void setupTree() {
        try {
            TreeNode rootNode = CodeRepositoryManager.getCodeRepositoryTreeNode(true);
            this.codeTree = new JTree(rootNode);
            this.treeModel = (DefaultTreeModel)this.codeTree.getModel();
            this.treeModel.setAsksAllowsChildren(true);
            this.codeTree.setEditable(true);
            this.codeTree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = CodeRepositoryDialog.this.codeTree.getClosestRowForLocation(e.getX(), e.getY());
                    TreePath path = CodeRepositoryDialog.this.codeTree.getClosestPathForLocation(e.getX(), e.getY());
                    if (row == -1) {
                        CodeRepositoryDialog.this.cards.show(CodeRepositoryDialog.this.editPanel, "disabled");
                        CodeRepositoryDialog.this.selected = null;
                        return;
                    }
                    CodeRepositoryTreeNode tempNode = (CodeRepositoryTreeNode)path.getLastPathComponent();
                    ElementHolder tempElem = (ElementHolder)tempNode.getUserObject();
                    if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                        CodeRepositoryDialog.this.showPopup(tempNode, tempElem, e.getX(), e.getY());
                    } else {
                        if (tempElem.isGroup) {
                            CodeRepositoryDialog.this.cards.show(CodeRepositoryDialog.this.editPanel, "disabled");
                            CodeRepositoryDialog.this.selected = null;
                        } else {
                            CodeRepositoryDialog.this.cards.show(CodeRepositoryDialog.this.editPanel, "enabled");
                            CodeRepositoryDialog.this.selected = tempElem;
                            CodeRepositoryDialog.this.code1Text.setText(tempElem.text);
                        }
                        CodeRepositoryDialog.this.undo.discardAllEdits();
                    }
                }
            });
        }
        catch (ParseException pe) {
            System.out.println("[blue.gui.OpcodePopup] There was an error trying to open or parse opcodes.xml or codeRepository.xml");
            pe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showPopup(CodeRepositoryTreeNode node, ElementHolder elem, int x, int y) {
        popup.show(this, node, elem, x, y);
    }

    @Override
    public void loadWindowSettings(Element settings) {
        WindowSettingManager.setBasicSettings(settings, this);
        Element elem = settings.getElement("splitVal");
        if (elem != null) {
            this.topSplit.setDividerLocation(Integer.parseInt(elem.getTextString()));
        }
    }

    @Override
    public Element saveWindowSettings() {
        Element retVal = WindowSettingManager.getBasicSettings(this);
        retVal.addElement("splitVal").setText(Integer.toString(this.topSplit.getDividerLocation()));
        return retVal;
    }
}

