/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.blueLive;

import blue.blueLive.LiveObjectSet;
import blue.blueLive.LiveObjectSetList;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class LiveObjectSetListTableModel
implements TableModel {
    Vector<TableModelListener> tableListeners = new Vector();
    private LiveObjectSetList liveObjectSetList;

    public void setLiveObjectSetList(LiveObjectSetList liveObjectSetList) {
        this.liveObjectSetList = liveObjectSetList;
        this.fireTableDataChanged(new TableModelEvent(this, -1));
    }

    @Override
    public int getRowCount() {
        return this.liveObjectSetList == null ? 0 : this.liveObjectSetList.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return "Set";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return ((LiveObjectSet)this.liveObjectSetList.get(rowIndex)).getName();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ((LiveObjectSet)this.liveObjectSetList.get(rowIndex)).setName((String)aValue);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.tableListeners == null) {
            this.tableListeners = new Vector();
        }
        this.tableListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (this.tableListeners == null) {
            return;
        }
        this.tableListeners.remove(l);
    }

    private void fireTableDataChanged() {
        this.fireTableDataChanged(new TableModelEvent(this));
    }

    private void fireTableDataChanged(TableModelEvent tme) {
        if (this.tableListeners == null) {
            return;
        }
        for (TableModelListener listener : this.tableListeners) {
            listener.tableChanged(tme);
        }
    }

    public void addLiveObjectSet(LiveObjectSet set) {
        this.liveObjectSetList.add((Object)set);
        set.setName("Set " + this.liveObjectSetList.size());
        this.fireTableDataChanged();
    }

    public void removeLiveObjectSet(int index) {
        if (index >= 0 && index < this.liveObjectSetList.size()) {
            this.liveObjectSetList.remove(index);
            this.fireTableDataChanged();
        }
    }

    public void pushUpSet(int index) {
        LiveObjectSet set = (LiveObjectSet)this.liveObjectSetList.remove(index);
        this.liveObjectSetList.add(index - 1, (Object)set);
        this.fireTableDataChanged();
    }

    public void pushDownSet(int index) {
        LiveObjectSet set = (LiveObjectSet)this.liveObjectSetList.remove(index);
        this.liveObjectSetList.add(index + 1, (Object)set);
        this.fireTableDataChanged();
    }
}

