/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.BlueSystem;
import blue.mixer.Channel;
import blue.mixer.ChannelList;
import blue.mixer.Effect;
import blue.mixer.EffectsChain;
import blue.mixer.Send;
import blue.ui.core.mixer.ChannelOutComboBoxModel;
import blue.ui.core.mixer.EffectEditorManager;
import blue.ui.core.mixer.EffectsPopup;
import blue.ui.core.mixer.SendEditorManager;
import blue.ui.core.mixer.SubChannelOutComboBoxModel;
import blue.ui.utilities.UiUtilities;
import blue.util.ObservableListListener;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import org.openide.windows.WindowManager;

public class ChannelPanel
extends JPanel
implements PropertyChangeListener,
Comparable<ChannelPanel> {
    boolean subChannel = false;
    boolean updating = false;
    private JLabel channelNameLabel;
    private JLabel jLabel1;
    private JLabel levelLabel;
    private JSlider levelSlider;
    private JTextField levelValueField;
    private JPanel levelValuePanel;
    private JLabel outputLabel;
    private JComboBox outputList;
    private JLabel postLabel;
    private JList postList;
    private JScrollPane postScroll;
    private JLabel preLabel;
    private JList preList;
    private JScrollPane preScroll;
    private Channel channel;
    private boolean master;

    public ChannelPanel() {
        this.initComponents();
        this.levelLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    ChannelPanel.this.switchLevelValueView(true);
                    ChannelPanel.this.levelValueField.requestFocus();
                }
            }
        });
        this.levelValueField.addActionListener(e -> {
            this.setLevelValueFromField();
            this.switchLevelValueView(false);
        });
        this.levelValueField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ChannelPanel.this.switchLevelValueView(false);
            }
        });
        Dimension miniScrollDim = new Dimension(9, 55);
        this.preScroll.getVerticalScrollBar().setPreferredSize(miniScrollDim);
        this.postScroll.getVerticalScrollBar().setPreferredSize(miniScrollDim);
        miniScrollDim = new Dimension(1, 9);
        this.preScroll.getHorizontalScrollBar().setPreferredSize(miniScrollDim);
        this.postScroll.getHorizontalScrollBar().setPreferredSize(miniScrollDim);
        this.levelSlider.addChangeListener(e -> {
            if (!this.updating) {
                this.updateLevelValue();
            }
        });
        this.outputList.addActionListener(arg0 -> {
            if (this.channel != null) {
                this.channel.setOutChannel((String)this.outputList.getSelectedItem());
            }
        });
        this.preList.setCellRenderer(new EnabledListCellRenderer());
        this.postList.setCellRenderer(new EnabledListCellRenderer());
    }

    private void setLevelValueFromField() {
        try {
            float val = Float.parseFloat(this.levelValueField.getText());
            val = Math.max(val, -96.0f);
            val = Math.min(val, 12.0f);
            this.channel.setLevel((double)val);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void switchLevelValueView(boolean toTextField) {
        String compName;
        if (toTextField) {
            compName = "levelField";
            MessageFormat fmt = new MessageFormat("{0,number,##.####}", Locale.ENGLISH);
            this.levelValueField.setText(fmt.format(new Object[]{new Float(this.channel.getLevel())}));
        } else {
            compName = "levelLabel";
            this.levelLabel.setText(this.channel.getLevel() + " dB");
        }
        CardLayout cardLayout = (CardLayout)this.levelValuePanel.getLayout();
        cardLayout.show(this.levelValuePanel, compName);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public synchronized void setChannel(Channel channel) {
        if (this.channel != null) {
            this.channel.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.channel = null;
        this.preList.setModel(channel.getPreEffects());
        this.postList.setModel(channel.getPostEffects());
        this.channelNameLabel.setText(channel.getName());
        this.channelNameLabel.setToolTipText(channel.getName());
        this.outputList.setSelectedItem(channel.getOutChannel());
        int levelVal = this.getSliderValFromChannel(channel);
        this.levelSlider.setValue(levelVal);
        this.levelLabel.setText(channel.getLevel() + " dB");
        this.channel = channel;
        this.channel.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private int getSliderValFromChannel(Channel channel) {
        int levelVal = 0;
        if (channel != null) {
            levelVal = channel.getLevel() > 0.0 ? (int)(channel.getLevel() * 20.0) : (int)(channel.getLevel() * 10.0);
        }
        return levelVal;
    }

    public void setSubChannel(boolean val) {
        this.subChannel = val;
    }

    public void setChannelOutModel(ComboBoxModel model) {
        this.outputList.setModel(model);
    }

    public ComboBoxModel getChannelOutModel() {
        return this.outputList.getModel();
    }

    public synchronized void clear() {
        if (this.channel != null) {
            this.channel.removePropertyChangeListener((PropertyChangeListener)this);
        }
        DefaultListModel<String> fakeModel = new DefaultListModel<String>();
        fakeModel.addElement("clear");
        this.preList.setModel(fakeModel);
        this.postList.setModel(fakeModel);
        ComboBoxModel model = this.outputList.getModel();
        if (model instanceof ChannelOutComboBoxModel) {
            ((ChannelOutComboBoxModel)model).clearListeners();
        }
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
        this.outputLabel.setVisible(!master);
        this.outputList.setVisible(!master);
    }

    private void updateLevelValue() {
        if (this.channel == null) {
            return;
        }
        float db = this.levelSlider.getValue();
        db = db > 0.0f ? db / 20.0f : db / 10.0f;
        this.channel.setLevel((double)db);
        this.levelLabel.setText(db + " dB");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.levelSlider = new JSlider();
        this.channelNameLabel = new JLabel();
        this.preLabel = new JLabel();
        this.postLabel = new JLabel();
        this.outputLabel = new JLabel();
        this.outputList = new JComboBox();
        this.postScroll = new JScrollPane();
        this.postList = new JList();
        this.preScroll = new JScrollPane();
        this.preList = new JList();
        this.levelValuePanel = new JPanel();
        this.levelLabel = new JLabel();
        this.levelValueField = new JTextField();
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Level");
        this.levelSlider.setMaximum(240);
        this.levelSlider.setMinimum(-960);
        this.levelSlider.setOrientation(1);
        this.levelSlider.setValue(0);
        this.channelNameLabel.setHorizontalAlignment(0);
        this.channelNameLabel.setText("Channel");
        this.channelNameLabel.setBorder(BorderFactory.createBevelBorder(1));
        this.channelNameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChannelPanel.this.channelNameLabelMouseClicked(evt);
            }
        });
        this.preLabel.setHorizontalAlignment(0);
        this.preLabel.setText("Pre");
        this.postLabel.setHorizontalAlignment(0);
        this.postLabel.setText("Post");
        this.outputLabel.setHorizontalAlignment(0);
        this.outputLabel.setText("Output");
        this.outputList.setFont(new Font("Dialog", 0, 10));
        this.outputList.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.outputList.setFocusable(false);
        this.postList.setFont(new Font("Dialog", 0, 10));
        this.postList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.postList.setSelectionMode(0);
        this.postList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChannelPanel.this.postListMouseClicked(evt);
            }
        });
        this.postScroll.setViewportView(this.postList);
        this.preList.setFont(new Font("Dialog", 0, 10));
        this.preList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.preList.setSelectionMode(0);
        this.preList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ChannelPanel.this.preListFocusLost(evt);
            }
        });
        this.preList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChannelPanel.this.preListMouseClicked(evt);
            }
        });
        this.preScroll.setViewportView(this.preList);
        this.levelValuePanel.setMaximumSize(new Dimension(24, 20));
        this.levelValuePanel.setMinimumSize(new Dimension(24, 20));
        this.levelValuePanel.setPreferredSize(new Dimension(24, 20));
        this.levelValuePanel.setLayout(new CardLayout());
        this.levelLabel.setHorizontalAlignment(0);
        this.levelLabel.setText("0db");
        this.levelLabel.setBorder(new SoftBevelBorder(1));
        this.levelLabel.setName("levelLabel");
        this.levelValuePanel.add((Component)this.levelLabel, "levelLabel");
        this.levelValueField.setBorder(BorderFactory.createLineBorder(Color.green));
        this.levelValueField.setMargin(new Insets(0, 2, 0, 2));
        this.levelValueField.setName("levelField");
        this.levelValuePanel.add((Component)this.levelValueField, "levelField");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.channelNameLabel, -1, 86, Short.MAX_VALUE).addComponent(this.preLabel, -1, 86, Short.MAX_VALUE).addComponent(this.preScroll, -1, 86, Short.MAX_VALUE).addComponent(this.jLabel1, -1, 86, Short.MAX_VALUE).addComponent(this.outputList, 0, 86, Short.MAX_VALUE).addComponent(this.outputLabel, -1, 86, Short.MAX_VALUE).addComponent(this.postScroll, GroupLayout.Alignment.TRAILING, -1, 86, Short.MAX_VALUE).addComponent(this.postLabel, GroupLayout.Alignment.TRAILING, -1, 86, Short.MAX_VALUE).addComponent(this.levelValuePanel, -1, 86, Short.MAX_VALUE).addComponent(this.levelSlider, GroupLayout.Alignment.TRAILING, -1, 86, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.channelNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.preLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.preScroll, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.levelSlider, -1, 56, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.levelValuePanel, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.postLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.postScroll, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputList, -2, 28, -2)));
    }

    private void preListFocusLost(FocusEvent evt) {
        this.preList.setSelectedIndex(-1);
    }

    private void postListMouseClicked(MouseEvent evt) {
        if (UiUtilities.isRightMouseButton((MouseEvent)evt)) {
            int index = this.postList.locationToIndex(evt.getPoint());
            if (this.postList.getSelectedIndex() != index) {
                this.postList.setSelectedIndex(index);
            }
            EffectsPopup popup = EffectsPopup.getInstance();
            popup.setEffectsChain(this.channel.getPostEffects(), this.postList.getSelectedIndex());
            popup.setComboBoxModel(this.outputList.getModel());
            popup.setMaster(this.isMaster());
            popup.setListSelectionModel(this.postList.getSelectionModel());
            popup.show(this.postList, evt.getX(), evt.getY());
        } else if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2) {
            if (this.postList.getSelectedValue() == null) {
                return;
            }
            Object obj = this.postList.getSelectedValue();
            Frame root = WindowManager.getDefault().getMainWindow();
            if (obj instanceof Effect) {
                Effect effect = (Effect)obj;
                EffectEditorManager.getInstance().openEffectEditor(root, effect);
            } else if (obj instanceof Send) {
                Send send = (Send)obj;
                ComboBoxModel model = this.outputList.getModel();
                ObservableListListener<Channel> temp = null;
                if (model instanceof ChannelOutComboBoxModel) {
                    temp = ((ChannelOutComboBoxModel)model).getCopy();
                } else if (model instanceof SubChannelOutComboBoxModel) {
                    temp = ((SubChannelOutComboBoxModel)model).getCopy();
                }
                SendEditorManager.getInstance().openSendEditor(root, send, (ComboBoxModel)temp);
            }
        }
    }

    private void preListMouseClicked(MouseEvent evt) {
        if (UiUtilities.isRightMouseButton((MouseEvent)evt)) {
            int index = this.preList.locationToIndex(evt.getPoint());
            if (this.preList.getSelectedIndex() != index) {
                this.preList.setSelectedIndex(index);
            }
            EffectsPopup popup = EffectsPopup.getInstance();
            popup.setEffectsChain(this.channel.getPreEffects(), this.preList.getSelectedIndex());
            popup.setComboBoxModel(this.outputList.getModel());
            popup.setMaster(this.isMaster());
            popup.setListSelectionModel(this.preList.getSelectionModel());
            popup.show(this.preList, evt.getX(), evt.getY());
        } else if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2) {
            if (this.preList.getSelectedValue() == null) {
                return;
            }
            Object obj = this.preList.getSelectedValue();
            Frame root = WindowManager.getDefault().getMainWindow();
            if (obj instanceof Effect) {
                Effect effect = (Effect)obj;
                EffectEditorManager.getInstance().openEffectEditor(root, effect);
            } else if (obj instanceof Send) {
                Send send = (Send)obj;
                ComboBoxModel model = this.outputList.getModel();
                ObservableListListener<Channel> temp = null;
                if (model instanceof ChannelOutComboBoxModel) {
                    temp = ((ChannelOutComboBoxModel)model).getCopy();
                } else if (model instanceof SubChannelOutComboBoxModel) {
                    temp = ((SubChannelOutComboBoxModel)model).getCopy();
                }
                SendEditorManager.getInstance().openSendEditor(root, send, (ComboBoxModel)temp);
            } else {
                System.err.println("ERR: " + obj);
            }
        }
    }

    private void channelNameLabelMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && (this.subChannel || this.channel.getAssociation() != null)) {
            this.editChannelName();
        }
    }

    private void editSubChannelName() {
        boolean finished = false;
        String originalName = this.channel.getName();
        SubChannelOutComboBoxModel model = (SubChannelOutComboBoxModel)this.getChannelOutModel();
        ChannelList subChannels = model.getChannels();
        while (!finished) {
            String retVal = JOptionPane.showInputDialog(WindowManager.getDefault().getMainWindow(), "Please Enter SubChannel Name", originalName);
            if (retVal != null && retVal.trim().length() > 0 && !retVal.equals(originalName)) {
                if (!this.isValidChannelName(retVal = retVal.trim())) {
                    JOptionPane.showMessageDialog(this, "Error: Channel names may only contain letters, numbers, or underscores", BlueSystem.getString((String)"common.error"), 0);
                    finished = false;
                    continue;
                }
                if (retVal.equals("Master") || subChannels.isChannelNameInUse(retVal)) {
                    JOptionPane.showMessageDialog(this, "Error: Channel Name already in use", BlueSystem.getString((String)"common.error"), 0);
                    finished = false;
                    continue;
                }
                this.channel.setName(retVal);
                finished = true;
                continue;
            }
            finished = true;
        }
    }

    private void editChannelName() {
        if (this.subChannel) {
            this.editSubChannelName();
        } else {
            String originalName = this.channel.getName();
            String retVal = JOptionPane.showInputDialog(WindowManager.getDefault().getMainWindow(), "Please Enter Channel Name", originalName);
            if (retVal != null && retVal.trim().length() > 0 && !retVal.equals(originalName)) {
                retVal = retVal.trim();
                this.channel.setName(retVal);
            }
        }
    }

    private boolean isValidChannelName(String retVal) {
        for (int i = 0; i < retVal.length(); ++i) {
            char c = retVal.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop;
        if (evt.getSource() != this.channel) {
            return;
        }
        switch (prop = evt.getPropertyName()) {
            case "name": {
                this.channelNameLabel.setText(this.channel.getName());
                this.channelNameLabel.setToolTipText(this.channel.getName());
                this.channelNameLabel.invalidate();
                this.channelNameLabel.repaint();
                break;
            }
            case "level": {
                this.updating = true;
                int levelVal = 0;
                levelVal = this.channel.getLevel() > 0.0 ? (int)(this.channel.getLevel() * 20.0) : (int)(this.channel.getLevel() * 10.0);
                this.levelSlider.setValue(levelVal);
                this.levelLabel.setText(this.channel.getLevel() + " dB");
                this.levelLabel.invalidate();
                this.levelLabel.repaint();
                this.updating = false;
            }
        }
    }

    @Override
    public int compareTo(ChannelPanel chanB) {
        try {
            int a = Integer.parseInt(this.channel.getName());
            int b = Integer.parseInt(chanB.getChannel().getName());
            return a - b;
        }
        catch (NumberFormatException nfe) {
            return this.channel.getName().compareToIgnoreCase(chanB.getChannel().getName());
        }
    }

    private static class EnabledListCellRenderer
    extends DefaultListCellRenderer {
        private final Font ENABLED_FONT = new Font("Dialog", 0, 10);
        private final Font DISABLED_FONT = new Font("Dialog", 2, 10);
        private static final Color ENABLED_COLOR = Color.WHITE;
        private static final Color DISABLED_COLOR = Color.GRAY;

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (list.getModel() != null && index >= 0 && list.getModel() instanceof EffectsChain) {
                EffectsChain chain = (EffectsChain)list.getModel();
                Object obj = chain.getElementAt(index);
                if (obj instanceof Effect) {
                    Effect effect = (Effect)obj;
                    if (effect.isEnabled()) {
                        c.setForeground(ENABLED_COLOR);
                    } else {
                        c.setForeground(DISABLED_COLOR);
                    }
                } else {
                    Send send = (Send)obj;
                    if (send.isEnabled()) {
                        c.setForeground(ENABLED_COLOR);
                    } else {
                        c.setForeground(DISABLED_COLOR);
                    }
                }
            }
            return c;
        }
    }
}

