/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.mixer.Send;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;

public class SendEditPanel
extends JPanel
implements PropertyChangeListener {
    private static MessageFormat format = new MessageFormat("{0,number,#.##}", Locale.ENGLISH);
    Send send = null;
    boolean updating = false;
    private JSlider amountSlider;
    private JComboBox channelComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel valueLabel;

    public SendEditPanel() {
        this.initComponents();
        this.amountSlider.setMinimum(0);
        this.amountSlider.setMaximum(100);
        this.amountSlider.addChangeListener(e -> {
            float val = (float)this.amountSlider.getValue() / 100.0f;
            this.valueLabel.setText(format.format(new Object[]{new Float(val)}));
            if (this.send != null && !this.updating) {
                this.send.setLevel((double)val);
            }
        });
        this.channelComboBox.addActionListener(e -> {
            if (this.send != null) {
                this.send.setSendChannel((String)this.channelComboBox.getSelectedItem());
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.send != null) {
            this.send.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.send != null) {
            this.send.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void setSend(Send send) {
        if (this.send != null) {
            this.send.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.send = null;
        this.updating = true;
        this.amountSlider.setValue((int)(send.getLevel() * 100.0));
        this.channelComboBox.setSelectedItem(send.getSendChannel());
        this.send = send;
        this.updating = false;
        this.send.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.channelComboBox = new JComboBox();
        this.amountSlider = new JSlider();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.valueLabel = new JLabel();
        this.jLabel1.setText("Send Channel");
        this.jLabel2.setText("Amount");
        this.channelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel3.setText("0.0");
        this.jLabel4.setText("1.0");
        this.valueLabel.setHorizontalAlignment(0);
        this.valueLabel.setText("Value");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valueLabel, -1, 229, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4)).addComponent(this.channelComboBox, 0, 285, Short.MAX_VALUE).addComponent(this.amountSlider, -1, 285, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.channelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.amountSlider, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.valueLabel)).addComponent(this.jLabel4)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    void setComboBoxModel(ComboBoxModel comboBoxModel) {
        this.channelComboBox.setModel(comboBoxModel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("level")) {
            this.updating = true;
            this.amountSlider.setValue((int)(this.send.getLevel() * 100.0));
            this.updating = false;
        }
    }
}

