/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.project;

import blue.BlueData;
import blue.BlueSystem;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.settings.DiskRenderSettings;
import blue.ui.core.project.RenderToDiskUtility;
import blue.ui.core.render.ProcessConsole;
import blue.ui.core.soundFile.AudioFilePlayerTopComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.windows.WindowManager;

public final class RenderToDiskAndPlayAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        BlueData data;
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        if (project != null && (data = project.getData()) != null) {
            RenderToDiskUtility.getInstance().renderToDisk(data, f -> {
                DiskRenderSettings settings = DiskRenderSettings.getInstance();
                if (settings.externalPlayCommandEnabled) {
                    String command = settings.externalPlayCommand;
                    command = command.replaceAll("\\$outfile", f.getAbsolutePath());
                    try {
                        if (System.getProperty("os.name").contains("Windows")) {
                            Runtime.getRuntime().exec(command);
                        } else {
                            String[] cmdArray = ProcessConsole.splitCommandString(command);
                            Runtime.getRuntime().exec(cmdArray);
                        }
                        System.out.println(command);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Could not run command: " + command, "Error", 0);
                        System.err.println("[" + BlueSystem.getString((String)"message.error") + "] - " + ex.getLocalizedMessage());
                        ex.printStackTrace();
                    }
                } else {
                    SwingUtilities.invokeLater(() -> {
                        AudioFilePlayerTopComponent tc = (AudioFilePlayerTopComponent)WindowManager.getDefault().findTopComponent("AudioFilePlayerTopComponent");
                        tc.setAudioFile((File)f);
                    });
                }
            });
        }
    }
}

