/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score;

import blue.score.Score;
import blue.score.ScoreObject;
import blue.score.layers.Layer;
import blue.score.layers.LayerGroup;
import java.awt.Point;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ScorePath {
    private WeakReference<Score> scoreRef;
    private List<WeakReference<LayerGroup>> layerGroups = new ArrayList<WeakReference<LayerGroup>>();
    private List<Point> scrollLocations = new ArrayList<Point>();

    public ScorePath(Score score) {
        this.scoreRef = new WeakReference<Score>(score);
        this.scrollLocations.add(new Point(0, 0));
    }

    public Score getScore() {
        return (Score)this.scoreRef.get();
    }

    public boolean editLayerGroup(LayerGroup layerGroup) {
        if (layerGroup == null) {
            if (this.layerGroups.isEmpty()) {
                return false;
            }
            this.layerGroups.clear();
            Point p = this.scrollLocations.get(0);
            this.scrollLocations.clear();
            this.scrollLocations.add(p);
            return true;
        }
        if (this.getLastLayerGroup() == layerGroup) {
            return false;
        }
        boolean found = false;
        for (WeakReference<LayerGroup> ref : this.layerGroups) {
            if (ref.get() != layerGroup) continue;
            found = true;
            break;
        }
        if (found) {
            for (int i = this.layerGroups.size() - 1; i >= 0 && this.layerGroups.get(i).get() != layerGroup; --i) {
                this.layerGroups.remove(i);
                this.scrollLocations.remove(i);
            }
        } else {
            this.layerGroups.add(new WeakReference<LayerGroup>(layerGroup));
            this.scrollLocations.add(new Point(0, 0));
        }
        return true;
    }

    public LayerGroup<? extends Layer> getLastLayerGroup() {
        if (this.layerGroups.isEmpty()) {
            return null;
        }
        return (LayerGroup)this.layerGroups.get(this.layerGroups.size() - 1).get();
    }

    public List<LayerGroup> getLayerGroups() {
        ArrayList<LayerGroup> retVal = new ArrayList<LayerGroup>();
        for (WeakReference<LayerGroup> ref : this.layerGroups) {
            retVal.add((LayerGroup)ref.get());
        }
        return retVal;
    }

    protected Point getCurrentPoint() {
        Point p = this.layerGroups.isEmpty() ? this.scrollLocations.get(0) : this.scrollLocations.get(this.scrollLocations.size() - 1);
        return p;
    }

    public void setScrollX(int x) {
        this.getCurrentPoint().x = x;
    }

    public void setScrollY(int y) {
        this.getCurrentPoint().y = y;
    }

    public int getScrollX() {
        return this.getCurrentPoint().x;
    }

    public int getScrollY() {
        return this.getCurrentPoint().y;
    }

    boolean containsLayerGroup(LayerGroup layerGroup) {
        if (layerGroup == null) {
            return false;
        }
        for (WeakReference<LayerGroup> ref : this.layerGroups) {
            if (ref.get() != layerGroup) continue;
            return true;
        }
        return false;
    }

    public List<Layer> getAllLayers() {
        ArrayList<Layer> allLayers = this.getLastLayerGroup() == null ? this.getScore().getAllLayers() : new ArrayList<Layer>((Collection<Layer>)this.getLastLayerGroup());
        return allLayers;
    }

    public Layer getGlobalLayerForY(int y) {
        if (this.getLastLayerGroup() == null) {
            return this.getScore().getGlobalLayerForY(y);
        }
        int runningY = 0;
        for (Layer layer : this.getLastLayerGroup()) {
            if (y <= runningY + layer.getLayerHeight()) {
                return layer;
            }
            runningY += layer.getLayerHeight();
        }
        return null;
    }

    public int getGlobalLayerIndexForY(int y) {
        LayerGroup<? extends Layer> layerGroup = this.getLastLayerGroup();
        if (layerGroup == null) {
            return this.getScore().getGlobalLayerIndexForY(y);
        }
        int runningY = 0;
        for (int i = 0; i < layerGroup.size(); ++i) {
            Layer layer = (Layer)layerGroup.get(i);
            if (y <= runningY + layer.getLayerHeight()) {
                return i;
            }
            runningY += layer.getLayerHeight();
        }
        return layerGroup.size() - 1;
    }

    public Layer getLayerForScoreObject(ScoreObject scoreObj) {
        List<Object> layers = this.getLastLayerGroup() == null ? this.getScore().getAllLayers() : this.getLastLayerGroup();
        Iterator iterator = layers.iterator();
        while (iterator.hasNext()) {
            Layer layer = (Layer)iterator.next();
            if (!layer.contains(scoreObj)) continue;
            return layer;
        }
        return null;
    }

    public int getGlobalLayerIndexForScoreObject(ScoreObject scoreObj) {
        List<Object> layers = this.getLastLayerGroup() == null ? this.getScore().getAllLayers() : this.getLastLayerGroup();
        for (int i = 0; i < layers.size(); ++i) {
            Layer layer = (Layer)layers.get(i);
            if (!layer.contains(scoreObj)) continue;
            return i;
        }
        return -1;
    }
}

