/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject;

import blue.BlueSystem;
import blue.jfx.BlueFX;
import blue.library.Library;
import blue.library.LibraryItem;
import blue.library.LibraryTreeItem;
import blue.score.ScoreObject;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectUtilities;
import blue.ui.core.score.ScoreController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.TextFieldTreeCell;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.openide.util.Exceptions;
import org.openide.util.lookup.InstanceContent;

public class UserSoundObjectLibrary
extends JComponent {
    Library<SoundObject> soundObjectLibrary;
    InstanceContent instanceContent;
    DataFormat sObjDataFormat = DataFormat.PLAIN_TEXT;

    public UserSoundObjectLibrary(InstanceContent instanceContent) {
        this.setLayout(new BorderLayout());
        this.soundObjectLibrary = BlueSystem.getSoundObjectLibrary();
        this.instanceContent = instanceContent;
        JLabel label = new JLabel("User SoundObject Library");
        this.add((Component)label, "North");
        label.setMinimumSize(new Dimension(0, 0));
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), new EmptyBorder(3, 3, 3, 3)));
        JFXPanel jfxPanel = new JFXPanel();
        CountDownLatch latch = new CountDownLatch(1);
        BlueFX.runOnFXThread(() -> {
            try {
                TreeView treeView = new TreeView();
                treeView.setRoot(this.soundObjectLibrary.getRoot());
                treeView.setEditable(true);
                treeView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
                treeView.setCellFactory(tv -> new LibraryItemCell());
                treeView.getSelectionModel().selectedItemProperty().addListener((obs, old, newVal) -> {
                    if (newVal == null) {
                        return;
                    }
                    if (((LibraryItem)newVal.getValue()).getValue() != null) {
                        instanceContent.set(Collections.singleton(((LibraryItem)newVal.getValue()).getValue()), null);
                    } else {
                        instanceContent.set(Collections.emptyList(), null);
                    }
                });
                Scene scene = new Scene((Parent)treeView);
                BlueFX.style((Scene)scene);
                jfxPanel.setScene(scene);
                treeView.setContextMenu(this.buildContextMenu((TreeView<LibraryItem<SoundObject>>)treeView));
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.add((Component)jfxPanel, "Center");
    }

    public ContextMenu buildContextMenu(TreeView<LibraryItem<SoundObject>> treeView) {
        ContextMenu popupMenu = new ContextMenu();
        ObservableList selectedItems = treeView.getSelectionModel().getSelectedItems();
        ScoreController.ScoreObjectBuffer scoreObjectBuffer = ScoreController.getInstance().getScoreObjectBuffer();
        ArrayList<MenuItem> folderMenuItems = new ArrayList<MenuItem>();
        MenuItem addFolder = new MenuItem("Add Folder");
        addFolder.setOnAction(evt -> {
            TreeItem item = (TreeItem)selectedItems.get(0);
            item.getChildren().add((Object)new LibraryTreeItem(new LibraryItem("New Folder")));
        });
        MenuItem deleteFolder = new MenuItem("Delete Folder");
        deleteFolder.setOnAction(evt -> {
            TreeItem item = (TreeItem)selectedItems.get(0);
            item.getParent().getChildren().remove((Object)item);
        });
        MenuItem paste = new MenuItem("Paste SoundObject");
        paste.setOnAction(evt -> {
            TreeItem item = (TreeItem)selectedItems.get(0);
            SoundObject sObj = (SoundObject)scoreObjectBuffer.scoreObjects.get(0).deepCopy();
            if (!SoundObjectUtilities.isOrContainsInstance((SoundObject)sObj)) {
                item.getChildren().add((Object)new LibraryTreeItem(new LibraryItem(sObj)));
            }
        });
        folderMenuItems.add(addFolder);
        folderMenuItems.add(deleteFolder);
        folderMenuItems.add(paste);
        ArrayList<Object> sObjMenuItems = new ArrayList<Object>();
        MenuItem cut = new MenuItem("Cut");
        cut.setOnAction(evt -> {
            TreeItem item = (TreeItem)selectedItems.get(0);
            SoundObject sObj = ((LibraryItem)item.getValue()).getValue();
            if (sObj == null) {
                return;
            }
            scoreObjectBuffer.clear();
            scoreObjectBuffer.scoreObjects.add((ScoreObject)sObj.deepCopy());
            scoreObjectBuffer.layerIndexes.add(0);
            item.getParent().getChildren().remove((Object)item);
        });
        MenuItem copy = new MenuItem("Copy");
        copy.setOnAction(evt -> {
            TreeItem item = (TreeItem)selectedItems.get(0);
            SoundObject sObj = ((LibraryItem)item.getValue()).getValue();
            if (sObj == null) {
                return;
            }
            scoreObjectBuffer.clear();
            scoreObjectBuffer.scoreObjects.add((ScoreObject)sObj.deepCopy());
            scoreObjectBuffer.layerIndexes.add(0);
        });
        MenuItem delete = new MenuItem("Delete");
        delete.setOnAction(evt -> {
            TreeItem item = (TreeItem)selectedItems.get(0);
            item.getParent().getChildren().remove((Object)item);
        });
        sObjMenuItems.add(cut);
        sObjMenuItems.add(copy);
        sObjMenuItems.add(new SeparatorMenuItem());
        sObjMenuItems.add(delete);
        popupMenu.getItems().addAll(folderMenuItems);
        popupMenu.getItems().addAll(sObjMenuItems);
        popupMenu.setOnShowing(evt -> {
            if (selectedItems.size() == 1) {
                TreeItem item = (TreeItem)selectedItems.get(0);
                boolean isFolder = ((LibraryItem)item.getValue()).getValue() == null;
                deleteFolder.setDisable(item == this.soundObjectLibrary.getRoot());
                if (isFolder) {
                    boolean isScoreObj;
                    boolean bl = isScoreObj = scoreObjectBuffer.scoreObjects.size() == 1 && scoreObjectBuffer.scoreObjects.get(0) instanceof SoundObject;
                    if (isScoreObj) {
                        SoundObject sObj = (SoundObject)scoreObjectBuffer.scoreObjects.get(0);
                        paste.setDisable(SoundObjectUtilities.isOrContainsInstance((SoundObject)sObj));
                    } else {
                        paste.setDisable(true);
                    }
                }
                for (MenuItem menuItem : folderMenuItems) {
                    menuItem.setVisible(isFolder);
                }
                for (MenuItem menuItem : sObjMenuItems) {
                    menuItem.setVisible(!isFolder);
                }
            }
        });
        return popupMenu;
    }

    class LibraryItemCell
    extends TextFieldTreeCell<LibraryItem<SoundObject>> {
        private TextField textField;

        public LibraryItemCell() {
            this.setOnDragDetected(evt -> {
                if (this.getTreeView().getRow(this.getTreeItem()) != 0) {
                    Dragboard db = this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                    ClipboardContent clipboard = new ClipboardContent();
                    clipboard.putString("" + this.getTreeView().getRow(this.getTreeItem()));
                    db.setContent((Map)clipboard);
                }
                evt.consume();
            });
            this.setOnDragDropped(evt -> {
                if (evt.getDragboard().getString() != null) {
                    String item = evt.getDragboard().getString();
                    try {
                        int row = Integer.parseInt(item);
                        TreeItem treeItem = this.getTreeView().getTreeItem(row);
                        treeItem.getParent().getChildren().remove((Object)treeItem);
                        this.getTreeItem().getChildren().add((Object)treeItem);
                        evt.setDropCompleted(true);
                    }
                    catch (Exception e) {
                        evt.setDropCompleted(false);
                    }
                } else {
                    evt.setDropCompleted(false);
                }
                evt.consume();
            });
            this.setOnDragOver(evt -> {
                String val = evt.getDragboard().getString();
                if (((LibraryItem)this.getTreeItem().getValue()).getValue() == null && val != null) {
                    int row = Integer.parseInt(val);
                    TreeItem treeItem = this.getTreeView().getTreeItem(row);
                    if (!this.isInParentPath((TreeItem<LibraryItem<SoundObject>>)treeItem, (TreeItem<LibraryItem<SoundObject>>)this.getTreeItem()) && this.getTreeItem() != treeItem.getParent()) {
                        evt.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                    }
                }
                evt.consume();
            });
        }

        private boolean isInParentPath(TreeItem<LibraryItem<SoundObject>> source, TreeItem<LibraryItem<SoundObject>> target) {
            if (target == source) {
                return true;
            }
            if (target == null) {
                return false;
            }
            return this.isInParentPath(source, (TreeItem<LibraryItem<SoundObject>>)target.getParent());
        }

        public void startEdit() {
            super.startEdit();
            if (this.textField == null) {
                this.createTextField();
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
            this.textField.selectAll();
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText(((LibraryItem)this.getItem()).toString());
            this.setGraphic(this.getTreeItem().getGraphic());
        }

        public void updateItem(LibraryItem<SoundObject> item, boolean empty) {
            super.updateItem(item, empty);
            boolean root = item == UserSoundObjectLibrary.this.soundObjectLibrary.getRoot().getValue();
            this.setEditable(!root);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
            } else {
                this.setText(this.getString());
                this.setGraphic(this.getTreeItem().getGraphic());
            }
        }

        private void createTextField() {
            this.textField = new TextField(this.getString());
            this.textField.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    if (t.getCode() == KeyCode.ENTER) {
                        String newVal = LibraryItemCell.this.textField.getText().trim();
                        if (LibraryItemCell.this.getItem() != UserSoundObjectLibrary.this.soundObjectLibrary.getRoot().getValue() && newVal.length() > 0) {
                            ((LibraryItem)LibraryItemCell.this.getItem()).setText(newVal);
                            LibraryItemCell.this.commitEdit(LibraryItemCell.this.getItem());
                        } else {
                            LibraryItemCell.this.cancelEdit();
                        }
                    } else if (t.getCode() == KeyCode.ESCAPE) {
                        LibraryItemCell.this.cancelEdit();
                    }
                }
            });
            this.textField.editableProperty().bind((ObservableValue)this.editableProperty());
        }

        private String getString() {
            return this.getItem() == null ? "" : ((LibraryItem)this.getItem()).toString();
        }
    }
}

