/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject.actions;

import blue.BlueData;
import blue.CopyBuffer;
import blue.SoundLayer;
import blue.automation.Parameter;
import blue.components.lines.LinePoint;
import blue.orchestra.BlueSynthBuilder;
import blue.projects.BlueProjectManager;
import blue.score.ScoreObject;
import blue.score.TimeState;
import blue.score.layers.Layer;
import blue.score.layers.ScoreObjectLayer;
import blue.soundObject.Sound;
import blue.soundObject.SoundObject;
import blue.ui.core.score.ScorePath;
import blue.ui.core.score.undo.AddScoreObjectEdit;
import blue.undo.BlueUndoManager;
import blue.utility.ScoreUtilities;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoableEdit;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class PasteBSBAsSoundAction
extends AbstractAction
implements ContextAwareAction {
    private Collection<? extends ScoreObject> scoreObjects;
    private Point p;
    private TimeState timeState;
    private final ScorePath scorePath;

    public PasteBSBAsSoundAction() {
        this(Utilities.actionsGlobalContext());
    }

    private PasteBSBAsSoundAction(Lookup lookup) {
        super(NbBundle.getMessage(PasteBSBAsSoundAction.class, (String)"CTL_PasteBSBAsSoundAction"));
        this.p = (Point)lookup.lookup(Point.class);
        this.timeState = (TimeState)lookup.lookup(TimeState.class);
        this.scorePath = (ScorePath)lookup.lookup(ScorePath.class);
    }

    @Override
    public boolean isEnabled() {
        Object obj = CopyBuffer.getBufferedObject((String)CopyBuffer.INSTRUMENT);
        return obj != null && obj instanceof BlueSynthBuilder && this.scorePath.getGlobalLayerForY(this.p.y) != null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double start = (double)this.p.x / (double)this.timeState.getPixelSecond();
        if (this.timeState.isSnapEnabled()) {
            start = ScoreUtilities.getSnapValueStart((double)start, (double)this.timeState.getSnapValue());
        }
        Object obj = CopyBuffer.getBufferedObject((String)CopyBuffer.INSTRUMENT);
        Sound sound = new Sound();
        sound.setStartTime(start);
        BlueSynthBuilder bsbCopy = ((BlueSynthBuilder)obj).deepCopy();
        for (Parameter param : bsbCopy.getParameterList()) {
            param.setAutomationEnabled(false);
            param.getLine().clear();
            param.getLine().addLinePoint(new LinePoint(0.0, param.getValue(0.0)));
            param.getLine().addLinePoint(new LinePoint(1.0, param.getValue(0.0)));
        }
        sound.setBlueSynthBuilder(bsbCopy);
        Layer layer = this.scorePath.getGlobalLayerForY(this.p.y);
        if (!layer.accepts((ScoreObject)sound)) {
            JOptionPane.showMessageDialog(null, "Unable to paste due to target layers not accepting types of objects within the copy buffer (i.e. trying to paste a SoundObject into an AudioLayer");
            return;
        }
        SoundLayer sLayer = (SoundLayer)layer;
        sLayer.add((SoundObject)sound);
        BlueData data = BlueProjectManager.getInstance().getCurrentBlueData();
        AddScoreObjectEdit undoEdit = new AddScoreObjectEdit((ScoreObjectLayer)sLayer, (ScoreObject)sound);
        BlueUndoManager.setUndoManager((String)"score");
        BlueUndoManager.addEdit((UndoableEdit)undoEdit);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new PasteBSBAsSoundAction(actionContext);
    }
}

