/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.tempo;

import blue.components.DragDirection;
import blue.components.lines.Line;
import blue.components.lines.LineEditorDialog;
import blue.components.lines.LinePoint;
import blue.score.TimeState;
import blue.score.tempo.Tempo;
import blue.ui.core.score.ModeManager;
import blue.ui.core.score.tempo.TempoMinMaxDialog;
import blue.ui.utilities.UiUtilities;
import blue.utility.GUI;
import blue.utility.NumberUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;

public class TempoEditor
extends JComponent
implements PropertyChangeListener {
    EditPointsPopup popup;
    TempoMinMaxDialog tempoMinMaxDialog;
    TableModelListener lineListener = e -> this.repaint();
    Tempo tempo = null;
    private TimeState timeState;
    LinePoint selectedPoint = null;
    int leftBoundaryX = -1;
    int rightBoundaryX = -1;

    public TempoEditor() {
        TempoEditorMouseListener tempoEditorMouseListener = new TempoEditorMouseListener(this);
        this.addMouseListener(tempoEditorMouseListener);
        this.addMouseMotionListener(tempoEditorMouseListener);
    }

    public void setTempo(Tempo tempo) {
        if (this.tempo != null) {
            this.tempo.getLine().removeTableModelListener(this.lineListener);
            this.tempo.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.tempo = tempo;
        this.tempo.getLine().addTableModelListener(this.lineListener);
        this.tempo.addPropertyChangeListener((PropertyChangeListener)this);
        this.setTempoVisible(tempo.isVisible());
    }

    public void setTimeState(TimeState timeState) {
        this.timeState = timeState;
    }

    public void setTempoVisible(boolean tempoVisible) {
        if (tempoVisible) {
            this.setPreferredSize(new Dimension(1, 100));
            this.setSize(this.getWidth(), 100);
        } else {
            this.setPreferredSize(new Dimension(1, 20));
            this.setSize(this.getWidth(), 20);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.tempo == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHints(hints);
        Object currentColor = null;
        ModeManager modeManager = ModeManager.getInstance();
        Line tempoLine = this.tempo.getLine();
        boolean enabled = this.tempo.isEnabled();
        if (enabled) {
            if (this.tempo.isVisible()) {
                g2d.setColor(Color.GREEN);
            } else {
                g2d.setColor(Color.GREEN.darker().darker());
            }
        } else {
            g2d.setColor(Color.DARK_GRAY);
            this.drawLine(g2d, tempoLine, false);
            g2d.setColor(Color.WHITE);
            g2d.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            return;
        }
        this.drawLine(g2d, tempoLine, this.tempo.isVisible());
        if (enabled && this.selectedPoint != null) {
            double min = tempoLine.getMin();
            double max = tempoLine.getMax();
            int x = this.doubleToScreenX(this.selectedPoint.getX());
            int y = this.doubleToScreenY(this.selectedPoint.getY(), min, max);
            g2d.setColor(Color.red);
            this.paintPoint(g2d, x, y);
            this.drawPointInformation(g2d, x, y);
        }
        g2d.setColor(Color.WHITE);
        g2d.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    private void drawPointInformation(Graphics2D g2d, int x, int y) {
        g2d.setColor(Color.white);
        double yVal = this.selectedPoint.getY();
        double xVal = this.selectedPoint.getX();
        String xText = "x: " + NumberUtilities.formatDouble((double)xVal);
        String yText = "y: " + NumberUtilities.formatDouble((double)yVal) + " bpm";
        int width = 95;
        int height = 28;
        int xLoc = x + 5;
        int yLoc = y + 5;
        if (x + width > this.getWidth()) {
            xLoc = x - width - 5;
        }
        if (y + height > this.getHeight()) {
            yLoc = y - 14 - 5;
        }
        g2d.drawString(xText, xLoc, yLoc);
        g2d.drawString(yText, xLoc, yLoc + 14);
    }

    private final void drawLine(Graphics g, Line line, boolean drawPoints) {
        Rectangle clipBounds = g.getClipBounds();
        if (line.size() == 0) {
            return;
        }
        if (line.size() == 1) {
            LinePoint lp = line.getLinePoint(0);
            double min = line.getMin();
            double max = line.getMax();
            int x = this.doubleToScreenX(lp.getX());
            int y = this.doubleToScreenY(lp.getY(), min, max);
            g.drawLine(0, y, this.getWidth(), y);
            if (drawPoints) {
                this.paintPoint(g, x, y);
            }
            return;
        }
        int prevX = -1;
        int prevY = -1;
        double min = line.getMin();
        double max = line.getMax();
        for (int i = 0; i < line.size(); ++i) {
            LinePoint point = line.getLinePoint(i);
            int x = this.doubleToScreenX(point.getX());
            int y = this.doubleToScreenY(point.getY(), min, max);
            if (drawPoints) {
                this.paintPoint(g, x, y);
            }
            if (prevX != -1 && prevX <= clipBounds.x + clipBounds.width && x >= clipBounds.x) {
                g.drawLine(prevX, prevY, x, y);
            }
            prevX = x;
            prevY = y;
        }
        if (prevX < this.getWidth()) {
            g.drawLine(prevX, prevY, this.getWidth(), prevY);
        }
    }

    private final void paintPoint(Graphics g, int x, int y) {
        g.fillRect(x - 2, y - 2, 5, 5);
    }

    private int doubleToScreenX(double val) {
        if (this.timeState == null) {
            return -1;
        }
        return (int)Math.round(val * (double)this.timeState.getPixelSecond());
    }

    private int doubleToScreenY(double yVal, double min, double max) {
        return this.doubleToScreenY(yVal, min, max, -1.0);
    }

    private int doubleToScreenY(double yVal, double min, double max, double resolution) {
        int height = this.getHeight() - 10;
        double range = max - min;
        double adjustedY = yVal - min;
        if (resolution > 0.0) {
            double tempY;
            for (tempY = 0.0; tempY <= adjustedY; tempY += resolution) {
            }
            adjustedY = (tempY -= resolution) > range ? range : tempY;
        }
        double percent = adjustedY / range;
        int y = (int)Math.round((double)height * (1.0 - percent)) + 5;
        return y;
    }

    private double screenToDoubleX(int val) {
        if (this.timeState == null) {
            return -1.0;
        }
        return (double)val / (double)this.timeState.getPixelSecond();
    }

    private double screenToDoubleY(int val, double min, double max, double resolution) {
        double height = this.getHeight() - 10;
        double percent = 1.0 - (double)(val - 5) / height;
        double range = max - min;
        double value = percent * range;
        if (resolution > 0.0) {
            value -= Math.IEEEremainder(value, resolution);
        }
        if (value > range) {
            value = range;
        }
        if (value < 0.0) {
            value = 0.0;
        }
        return value + min;
    }

    public void setBoundaryXValues() {
        Line currentLine = this.tempo.getLine();
        if (this.selectedPoint == currentLine.getLinePoint(0)) {
            this.leftBoundaryX = 0;
            this.rightBoundaryX = 0;
            return;
        }
        if (this.selectedPoint == currentLine.getLinePoint(currentLine.size() - 1)) {
            LinePoint p1 = currentLine.getLinePoint(currentLine.size() - 2);
            this.leftBoundaryX = this.doubleToScreenX(p1.getX());
            this.rightBoundaryX = this.getWidth();
            return;
        }
        for (int i = 0; i < currentLine.size(); ++i) {
            if (currentLine.getLinePoint(i) != this.selectedPoint) continue;
            LinePoint p1 = currentLine.getLinePoint(i - 1);
            LinePoint p2 = currentLine.getLinePoint(i + 1);
            this.leftBoundaryX = this.doubleToScreenX(p1.getX());
            this.rightBoundaryX = this.doubleToScreenX(p2.getX());
            return;
        }
    }

    protected LinePoint insertGraphPoint(int x, int y) {
        LinePoint point = new LinePoint();
        Line currentLine = this.tempo.getLine();
        double min = currentLine.getMin();
        double max = currentLine.getMax();
        point.setLocation(this.screenToDoubleX(x), this.screenToDoubleY(y, min, max, -1.0));
        int index = 1;
        LinePoint last = currentLine.getLinePoint(currentLine.size() - 1);
        if (point.getX() > last.getX()) {
            currentLine.addLinePoint(point);
            return point;
        }
        for (int i = 0; i < currentLine.size(); ++i) {
            LinePoint p1 = currentLine.getLinePoint(i);
            LinePoint p2 = currentLine.getLinePoint(i + 1);
            if (!(point.getX() >= p1.getX()) || !(point.getX() <= p2.getX())) continue;
            index = i + 1;
            break;
        }
        currentLine.addLinePoint(index, point);
        return point;
    }

    public LinePoint findGraphPoint(int x, int y) {
        Line currentLine = this.tempo.getLine();
        double min = currentLine.getMin();
        double max = currentLine.getMax();
        for (int i = 0; i < currentLine.size(); ++i) {
            LinePoint point = currentLine.getLinePoint(i);
            int tempX = this.doubleToScreenX(point.getX());
            int tempY = this.doubleToScreenY(point.getY(), min, max);
            if (tempX < x - 2 || tempX > x + 2 || tempY < y - 2 || tempY > y + 2) continue;
            return point;
        }
        return null;
    }

    public LinePoint findGraphPoint(int x) {
        Line currentLine = this.tempo.getLine();
        for (int i = 0; i < currentLine.size(); ++i) {
            LinePoint point = currentLine.getLinePoint(i);
            int tempX = this.doubleToScreenX(point.getX());
            if (tempX < x - 2 || tempX > x + 2) continue;
            return point;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop;
        switch (prop = evt.getPropertyName()) {
            case "enabled": {
                this.repaint();
                break;
            }
            case "visible": {
                this.setTempoVisible((Boolean)evt.getNewValue());
            }
        }
    }

    class EditPointsPopup
    extends JPopupMenu {
        Action editPointsAction;
        Action editBoundariesAction;

        public EditPointsPopup() {
            this.editPointsAction = new AbstractAction("Edit Points"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TempoEditor.this.tempo != null) {
                        Component root = SwingUtilities.getRoot(EditPointsPopup.this.getInvoker());
                        LineEditorDialog dialog = LineEditorDialog.getInstance(root);
                        dialog.setLine(TempoEditor.this.tempo.getLine());
                        dialog.ask();
                    }
                }
            };
            this.editBoundariesAction = new AbstractAction("Edit Min/Max"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TempoEditor.this.tempo != null) {
                        if (TempoEditor.this.tempoMinMaxDialog == null) {
                            Component root = SwingUtilities.getRoot(EditPointsPopup.this.getInvoker());
                            TempoEditor.this.tempoMinMaxDialog = new TempoMinMaxDialog((Frame)root, true);
                            GUI.centerOnScreen((Component)TempoEditor.this.tempoMinMaxDialog);
                        }
                        Line line = TempoEditor.this.tempo.getLine();
                        TempoEditor.this.tempoMinMaxDialog.setValues(line.getMin(), line.getMax());
                        TempoEditor.this.tempoMinMaxDialog.setVisible(true);
                        if (TempoEditor.this.tempoMinMaxDialog.getReturnStatus() == 1) {
                            double min = TempoEditor.this.tempoMinMaxDialog.getMin();
                            double max = TempoEditor.this.tempoMinMaxDialog.getMax();
                            boolean truncate = TempoEditor.this.tempoMinMaxDialog.isTruncate();
                            line.setMinMax(min, max, truncate);
                        }
                    }
                }
            };
            this.add(this.editPointsAction);
            this.add(this.editBoundariesAction);
        }
    }

    public class TempoEditorMouseListener
    implements MouseListener,
    MouseMotionListener {
        TempoEditor tempoEditor;
        DragDirection direction = DragDirection.NOT_SET;
        Point pressPoint = null;

        public TempoEditorMouseListener(TempoEditor tempoEditor) {
            this.tempoEditor = tempoEditor;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (TempoEditor.this.tempo == null || !TempoEditor.this.tempo.isEnabled() || !TempoEditor.this.tempo.isVisible()) {
                return;
            }
            this.pressPoint = e.getPoint();
            if (TempoEditor.this.selectedPoint != null) {
                if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    LinePoint first = TempoEditor.this.tempo.getLine().getLinePoint(0);
                    if (TempoEditor.this.selectedPoint != first) {
                        TempoEditor.this.tempo.getLine().removeLinePoint(TempoEditor.this.selectedPoint);
                        TempoEditor.this.selectedPoint = null;
                    }
                } else {
                    TempoEditor.this.setBoundaryXValues();
                }
            } else if (SwingUtilities.isLeftMouseButton(e)) {
                int start = e.getX();
                if (TempoEditor.this.timeState.isSnapEnabled() && !e.isShiftDown()) {
                    int snapPixels = (int)(TempoEditor.this.timeState.getSnapValue() * (double)TempoEditor.this.timeState.getPixelSecond());
                    int fraction = start % snapPixels;
                    start -= fraction;
                    if (fraction > snapPixels / 2) {
                        start += snapPixels;
                    }
                }
                TempoEditor.this.selectedPoint = TempoEditor.this.insertGraphPoint(start, e.getY());
                TempoEditor.this.setBoundaryXValues();
            } else if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                if (TempoEditor.this.popup == null) {
                    TempoEditor.this.popup = new EditPointsPopup();
                }
                TempoEditor.this.popup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.direction = DragDirection.NOT_SET;
            if (TempoEditor.this.tempo == null || !TempoEditor.this.tempo.isEnabled() || !TempoEditor.this.tempo.isVisible()) {
                return;
            }
            TempoEditor.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (TempoEditor.this.tempo == null || !TempoEditor.this.tempo.isEnabled() || !TempoEditor.this.tempo.isVisible()) {
                return;
            }
            if (TempoEditor.this.selectedPoint != null) {
                int x = e.getX();
                int y = e.getY();
                if (this.direction == DragDirection.NOT_SET) {
                    int magy;
                    int magx = Math.abs(x - (int)this.pressPoint.getX());
                    DragDirection dragDirection = this.direction = magx > (magy = Math.abs(y - (int)this.pressPoint.getY())) ? DragDirection.LEFT_RIGHT : DragDirection.UP_DOWN;
                }
                if (e.isControlDown()) {
                    if (this.direction == DragDirection.LEFT_RIGHT) {
                        y = (int)this.pressPoint.getY();
                    } else {
                        x = (int)this.pressPoint.getX();
                    }
                }
                int topY = 5;
                int bottomY = TempoEditor.this.getHeight() - 5;
                if (x < TempoEditor.this.leftBoundaryX) {
                    x = TempoEditor.this.leftBoundaryX;
                } else if (x > TempoEditor.this.rightBoundaryX) {
                    x = TempoEditor.this.rightBoundaryX;
                }
                if (y < topY) {
                    y = topY;
                } else if (y > bottomY) {
                    y = bottomY;
                }
                if (TempoEditor.this.timeState.isSnapEnabled() && !e.isShiftDown()) {
                    int snapPixels = (int)(TempoEditor.this.timeState.getSnapValue() * (double)TempoEditor.this.timeState.getPixelSecond());
                    int fraction = x % snapPixels;
                    x -= fraction;
                    if (fraction > snapPixels / 2) {
                        x += snapPixels;
                    }
                }
                double min = TempoEditor.this.tempo.getLine().getMin();
                double max = TempoEditor.this.tempo.getLine().getMax();
                if (TempoEditor.this.selectedPoint != null) {
                    TempoEditor.this.selectedPoint.setLocation(TempoEditor.this.screenToDoubleX(x), TempoEditor.this.screenToDoubleY(y, min, max, -1.0));
                    TempoEditor.this.repaint();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int y;
            if (TempoEditor.this.tempo == null || !TempoEditor.this.tempo.isEnabled() || !TempoEditor.this.tempo.isVisible()) {
                return;
            }
            int x = e.getX();
            LinePoint foundPoint = TempoEditor.this.findGraphPoint(x, y = e.getY());
            if (foundPoint != null) {
                if (TempoEditor.this.selectedPoint != foundPoint) {
                    TempoEditor.this.selectedPoint = foundPoint;
                    TempoEditor.this.repaint();
                }
            } else if (TempoEditor.this.selectedPoint != null) {
                TempoEditor.this.selectedPoint = null;
                TempoEditor.this.repaint();
            }
        }
    }
}

