/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.undo;

import blue.BlueSystem;
import blue.score.ScoreObject;
import java.awt.Color;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class SetColorEdit
extends AbstractUndoableEdit {
    private final ScoreObject sObj;
    private final Color oldColor;
    private final Color newColor;
    private SetColorEdit nextEdit = null;

    public SetColorEdit(ScoreObject sObj, Color oldColor, Color newColor) {
        this.sObj = sObj;
        this.oldColor = oldColor;
        this.newColor = newColor;
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.sObj.setBackgroundColor(this.newColor);
        if (this.nextEdit != null) {
            this.nextEdit.redo();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.sObj.setBackgroundColor(this.oldColor);
        if (this.nextEdit != null) {
            this.nextEdit.undo();
        }
    }

    @Override
    public String getPresentationName() {
        return BlueSystem.getString((String)"Set ScoreObject Color");
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof SetColorEdit) {
            if (this.nextEdit == null) {
                this.nextEdit = (SetColorEdit)anEdit;
                return true;
            }
            return this.nextEdit.addEdit(anEdit);
        }
        return false;
    }
}

