/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.net;

import de.sciss.net.OSCBidi;
import de.sciss.net.OSCListener;
import de.sciss.net.OSCPacket;
import de.sciss.net.OSCPacketCodec;
import de.sciss.net.OSCReceiver;
import de.sciss.net.OSCTransmitter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class OSCClient
implements OSCBidi {
    private final OSCReceiver rcv;
    private final OSCTransmitter trns;
    private int bufSize = 8192;
    private final String protocol;

    private OSCClient(OSCReceiver rcv, OSCTransmitter trns, String protocol) {
        this.rcv = rcv;
        this.trns = trns;
        this.protocol = protocol;
    }

    public static OSCClient newUsing(String protocol) throws IOException {
        return OSCClient.newUsing(OSCPacketCodec.getDefaultCodec(), protocol);
    }

    public static OSCClient newUsing(OSCPacketCodec c, String protocol) throws IOException {
        return OSCClient.newUsing(c, protocol, 0);
    }

    public static OSCClient newUsing(String protocol, int port) throws IOException {
        return OSCClient.newUsing(OSCPacketCodec.getDefaultCodec(), protocol, port);
    }

    public static OSCClient newUsing(OSCPacketCodec c, String protocol, int port) throws IOException {
        return OSCClient.newUsing(c, protocol, port, false);
    }

    public static OSCClient newUsing(String protocol, int port, boolean loopBack) throws IOException {
        return OSCClient.newUsing(OSCPacketCodec.getDefaultCodec(), protocol, port, loopBack);
    }

    public static OSCClient newUsing(OSCPacketCodec c, String protocol, int port, boolean loopBack) throws IOException {
        OSCReceiver rcv = OSCReceiver.newUsing(c, protocol, port, loopBack);
        OSCTransmitter trns = OSCTransmitter.newUsing(c, protocol, port, loopBack);
        return new OSCClient(rcv, trns, protocol);
    }

    public static OSCClient newUsing(String protocol, InetSocketAddress localAddress) throws IOException {
        OSCReceiver rcv = OSCReceiver.newUsing(protocol, localAddress);
        OSCTransmitter trns = OSCTransmitter.newUsing(protocol, localAddress);
        return new OSCClient(rcv, trns, protocol);
    }

    public static OSCClient newUsing(OSCPacketCodec c, String protocol, InetSocketAddress localAddress) throws IOException {
        OSCReceiver rcv = OSCReceiver.newUsing(c, protocol, localAddress);
        OSCTransmitter trns = OSCTransmitter.newUsing(c, protocol, localAddress);
        return new OSCClient(rcv, trns, protocol);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public InetSocketAddress getLocalAddress() throws IOException {
        return this.rcv.getLocalAddress();
    }

    public void setTarget(SocketAddress target) {
        this.rcv.setTarget(target);
        this.trns.setTarget(target);
    }

    public void setCodec(OSCPacketCodec c) {
        this.rcv.setCodec(c);
        this.trns.setCodec(c);
    }

    public OSCPacketCodec getCodec() {
        return this.rcv.getCodec();
    }

    public void connect() throws IOException {
        this.trns.connect();
    }

    public boolean isConnected() {
        return this.trns.isConnected();
    }

    public void send(OSCPacket p) throws IOException {
        this.trns.send(p);
    }

    public void addOSCListener(OSCListener listener) {
        this.rcv.addOSCListener(listener);
    }

    public void removeOSCListener(OSCListener listener) {
        this.rcv.removeOSCListener(listener);
    }

    public void start() throws IOException {
        if (!this.trns.isConnected()) {
            this.trns.connect();
            this.rcv.setChannel(this.trns.getChannel());
        }
        this.rcv.startListening();
    }

    public boolean isActive() {
        return this.rcv.isListening();
    }

    public void stop() throws IOException {
        this.rcv.stopListening();
    }

    public void setBufferSize(int size) {
        this.bufSize = size;
        this.rcv.setBufferSize(size);
        this.trns.setBufferSize(size);
    }

    public int getBufferSize() {
        return this.bufSize;
    }

    public void dumpOSC(int mode, PrintStream stream) {
        this.dumpIncomingOSC(mode, stream);
        this.dumpOutgoingOSC(mode, stream);
    }

    public void dumpIncomingOSC(int mode, PrintStream stream) {
        this.rcv.dumpOSC(mode, stream);
    }

    public void dumpOutgoingOSC(int mode, PrintStream stream) {
        this.trns.dumpOSC(mode, stream);
    }

    public void dispose() {
        this.rcv.dispose();
        this.trns.dispose();
    }
}

