/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.editor.clojure;

import blue.ui.editor.clojure.ClojureTokenId;
import blue.ui.editor.support.OffsetRange;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;

class ClojureLexUtilities {
    ClojureLexUtilities() {
    }

    public static TokenSequence<ClojureTokenId> getClojureTokenSequence(Document doc, int offset) {
        TokenSequence ts;
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence tokenSequence = ts = th == null ? null : th.tokenSequence(ClojureTokenId.language());
        if (ts == null) {
            List list = th.embeddedTokenSequences(offset, true);
            for (TokenSequence t : list) {
                if (t.language() != ClojureTokenId.language()) continue;
                ts = t;
                break;
            }
            if (ts == null) {
                list = th.embeddedTokenSequences(offset, false);
                for (TokenSequence t : list) {
                    if (t.language() != ClojureTokenId.language()) continue;
                    ts = t;
                    break;
                }
            }
        }
        return ts;
    }

    public static OffsetRange findFwd(BaseDocument doc, TokenSequence<? extends ClojureTokenId> ts, char up, char down) {
        int balance = 0;
        while (ts.moveNext()) {
            Token token = ts.token();
            if (ClojureLexUtilities.textEquals(token.text(), up)) {
                ++balance;
                continue;
            }
            if (!ClojureLexUtilities.textEquals(token.text(), down)) continue;
            if (balance == 0) {
                return new OffsetRange(ts.offset(), ts.offset() + token.length());
            }
            --balance;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findFwd(TokenSequence<? extends ClojureTokenId> ts, int up, int down) {
        int balance = 0;
        while (ts.moveNext()) {
            Token token = ts.token();
            if (((ClojureTokenId)token.id()).ordinal() == up) {
                ++balance;
                continue;
            }
            if (((ClojureTokenId)token.id()).ordinal() != down) continue;
            if (balance == 0) {
                return new OffsetRange(ts.offset(), ts.offset() + token.length());
            }
            --balance;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBwd(TokenSequence<? extends ClojureTokenId> ts, int up, int down) {
        int balance = 0;
        while (ts.movePrevious()) {
            Token token = ts.token();
            TokenId id = token.id();
            if (((ClojureTokenId)token.id()).ordinal() == up) {
                if (balance == 0) {
                    return new OffsetRange(ts.offset(), ts.offset() + token.length());
                }
                ++balance;
                continue;
            }
            if (((ClojureTokenId)token.id()).ordinal() != down) continue;
            --balance;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBwd(BaseDocument doc, TokenSequence<? extends ClojureTokenId> ts, char up, char down) {
        int balance = 0;
        while (ts.movePrevious()) {
            Token token = ts.token();
            TokenId id = token.id();
            if (ClojureLexUtilities.textEquals(token.text(), up)) {
                if (balance == 0) {
                    return new OffsetRange(ts.offset(), ts.offset() + token.length());
                }
                ++balance;
                continue;
            }
            if (!ClojureLexUtilities.textEquals(token.text(), down)) continue;
            --balance;
        }
        return OffsetRange.NONE;
    }

    public static boolean textEquals(CharSequence text1, char ... text2) {
        int len = text1.length();
        if (len == text2.length) {
            for (int i = len - 1; i >= 0; --i) {
                if (text1.charAt(i) == text2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

