/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.editor.csound.orc;

import blue.ui.editor.csound.orc.CsoundOrcCompletionDocumentation;
import blue.ui.editor.csound.orc.OpcodeDocumentation;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.net.URL;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringEscapeUtils;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;

public class CsoundOrcCompletionItem
implements CompletionItem {
    private static String RIGHT_LABEL = "opcode";
    private final String opName;
    private final String signature;

    public CsoundOrcCompletionItem(String opName, String signature) {
        this.opName = StringEscapeUtils.escapeHtml4((String)opName);
        this.signature = signature;
    }

    public void defaultAction(JTextComponent component) {
        this.replaceWordBeforeCaret(this.signature, component);
        Completion.get().hideAll();
    }

    protected void replaceWordBeforeCaret(String replacementText, JTextComponent jtc) {
        int index1;
        int index2 = index1 = Math.max(jtc.getCaretPosition() - 1, 0);
        String text = jtc.getText();
        int len = text.length();
        while (index1 > 0) {
            if (!Character.isLetter(text.charAt(index1))) {
                ++index1;
                break;
            }
            --index1;
        }
        while (index2 < len && !Character.isWhitespace(text.charAt(index2))) {
            ++index2;
        }
        try {
            jtc.getDocument().remove(index1, index2 - index1);
            jtc.getDocument().insertString(index1, replacementText, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void processKeyEvent(KeyEvent evt) {
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.opName, (String)RIGHT_LABEL, (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml(null, (String)this.opName, (String)RIGHT_LABEL, (Graphics)g, (Font)defaultFont, (Color)(selected ? Color.orange : Color.white), (int)width, (int)height, (boolean)selected);
    }

    public CompletionTask createDocumentationTask() {
        return new AsyncCompletionTask(new AsyncCompletionQuery(){

            protected void query(CompletionResultSet completionResultSet, Document document, int i) {
                String doc = OpcodeDocumentation.getOpcodeDocumentation(CsoundOrcCompletionItem.this.opName);
                URL url = OpcodeDocumentation.getOpcodeDocumentationUrl(CsoundOrcCompletionItem.this.opName);
                if (doc != null) {
                    completionResultSet.setDocumentation((CompletionDocumentation)new CsoundOrcCompletionDocumentation(doc, url));
                }
                completionResultSet.finish();
            }
        });
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent component) {
        return false;
    }

    public int getSortPriority() {
        return 0;
    }

    public CharSequence getSortText() {
        return this.opName;
    }

    public CharSequence getInsertPrefix() {
        return this.opName;
    }
}

