/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import blue.plaf.BlueLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToggleButtonUI;

public class BlueToggleButtonUI
extends MetalToggleButtonUI {
    int cachedWidth = -1;
    int cachedHeight = -1;
    int pressedCachedWidth = -1;
    int pressedCachedHeight = -1;
    GradientPaint gp = null;
    GradientPaint pressedGp = null;

    public static ComponentUI createUI(JComponent c) {
        return new BlueToggleButtonUI();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        Graphics2D g2d = (Graphics2D)g;
        Dimension size = c.getSize();
        Color bgColor = c.getBackground();
        if (bgColor == null) {
            bgColor = BlueLookAndFeel.getControl();
        }
        if (this.gp == null || !this.gp.getColor2().equals(bgColor) || this.cachedWidth != size.width || this.cachedHeight != size.height) {
            this.gp = new GradientPaint(0.0f, 0.0f, bgColor.brighter(), 0.0f, size.height / 2, bgColor);
            this.cachedWidth = size.width;
            this.cachedHeight = size.height;
        }
        Paint p = g2d.getPaint();
        g2d.setPaint(this.gp);
        g2d.fillRect(0, 0, size.width, size.height);
        g2d.setPaint(p);
        this.paint(g, c);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        g.setColor(BlueLookAndFeel.getFocusColor());
        Dimension size = b.getSize();
        g.drawLine(1, 1, size.width - 2, 1);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            Graphics2D g2d = (Graphics2D)g;
            Dimension size = b.getSize();
            if (this.pressedGp == null || this.pressedCachedWidth != size.width || this.pressedCachedHeight != size.height) {
                Color c = (Color)b.getClientProperty("BlueToggleButton.selectColorOverride");
                if (c == null) {
                    c = this.getSelectColor();
                }
                this.pressedGp = new GradientPaint(0.0f, 0.0f, c.brighter(), 0.0f, size.height / 2, c);
                this.pressedCachedWidth = size.width;
                this.pressedCachedHeight = size.height;
            }
            Paint p = g2d.getPaint();
            g2d.setPaint(this.pressedGp);
            g2d.fillRect(0, 0, size.width, size.height);
            g2d.setPaint(p);
        }
    }
}

