/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import blue.plaf.Gradient;
import blue.plaf.GradientInfo;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.WeakHashMap;

public class FastGradientPaintContext
implements PaintContext {
    private static WeakHashMap<GradientInfo, WeakReference<Gradient>> gradientCache = new WeakHashMap();
    private static LinkedList<GradientInfo> recentInfos = new LinkedList();
    private GradientInfo info = new GradientInfo();
    private int parallelDevicePos;
    private Gradient gradient;

    public FastGradientPaintContext(ColorModel cm, Rectangle r, int sc, int ec, boolean ver, boolean asc) {
        this.info.isAscending = asc;
        this.info.model = ((sc & ec) >> 24 & 0xFF) != 255 ? ColorModel.getRGBdefault() : cm;
        this.info.startColor = sc;
        this.info.endColor = ec;
        if (this.info.isVertical == ver) {
            this.parallelDevicePos = r.y;
            this.info.parallelLength = r.height;
        } else {
            this.parallelDevicePos = r.x;
            this.info.parallelLength = r.width;
        }
        recentInfos.remove(this.info);
        recentInfos.add(0, this.info);
        if (recentInfos.size() > 16) {
            recentInfos.removeLast();
        }
        WeakReference<Gradient> ref = gradientCache.get(this.info);
        Gradient temp = null;
        if (ref != null) {
            temp = (Gradient)ref.get();
        }
        if (temp != null) {
            this.gradient = temp;
        } else {
            this.gradient = new Gradient(this.info);
            gradientCache.put(this.info, new WeakReference<Gradient>(this.gradient));
        }
    }

    @Override
    public void dispose() {
        this.gradient.dispose();
    }

    @Override
    public ColorModel getColorModel() {
        return this.info.model;
    }

    @Override
    public synchronized Raster getRaster(int x, int y, int w, int h) {
        if (this.info.isVertical) {
            return this.gradient.getRaster(y - this.parallelDevicePos, w, h);
        }
        return this.gradient.getRaster(x - this.parallelDevicePos, h, w);
    }
}

