/*
 * Decompiled with CFR 0.152.
 */
package blue.projects.actions;

import blue.BlueData;
import blue.BlueSystem;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.settings.GeneralSettings;
import blue.ui.utilities.FileChooserManager;
import blue.utility.CSDUtility;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javafx.stage.FileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.windows.WindowManager;

public final class ImportCsdAction
implements ActionListener {
    public ImportCsdAction() {
        FileChooserManager fcm = FileChooserManager.getDefault();
        fcm.setMultiSelectionEnabled(this.getClass(), false);
        fcm.addFilter(this.getClass(), new FileChooser.ExtensionFilter("CSD File", new String[]{"*.csd"}));
        fcm.setSelectedFile(this.getClass(), GeneralSettings.getInstance().getDefaultDirectory());
        fcm.setDialogTitle(this.getClass(), "Select CSD File");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(this::importCsdAction);
    }

    protected void importCsdAction() {
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        List rValue = FileChooserManager.getDefault().showOpenDialog(this.getClass(), (Component)mainWindow);
        if (rValue.size() > 0) {
            BlueData tempData;
            File temp = (File)rValue.get(0);
            if (!temp.getName().trim().toLowerCase().endsWith(".csd")) {
                String errorMessage = BlueSystem.getString((String)"message.file.incorrectEnding") + " .csd";
                JOptionPane.showMessageDialog(mainWindow, errorMessage, "Error", 0);
            }
            Object[] values = new Object[]{BlueSystem.getString((String)"csd.import1"), BlueSystem.getString((String)"csd.import2"), BlueSystem.getString((String)"csd.import3")};
            Object selectedValue = JOptionPane.showInputDialog(mainWindow, BlueSystem.getString((String)"csd.importMethod.message"), BlueSystem.getString((String)"csd.importMethod.title"), 1, null, values, values[0]);
            if (selectedValue == null) {
                return;
            }
            int modeType = 0;
            for (int i = 0; i < values.length; ++i) {
                if (selectedValue != values[i]) continue;
                modeType = i;
                break;
            }
            if ((tempData = CSDUtility.convertCSDtoBlue((File)temp, (int)modeType)) != null) {
                BlueProject project = new BlueProject(tempData, null);
                BlueProjectManager.getInstance().setCurrentProject(project);
            } else {
                JOptionPane.showMessageDialog(mainWindow, BlueSystem.getString((String)"message.file.couldNotImport"), BlueSystem.getString((String)"message.error"), 0);
            }
        }
    }
}

