/*
 * Decompiled with CFR 0.152.
 */
package blue.projects.actions;

import blue.BlueData;
import blue.BlueSystem;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.settings.GeneralSettings;
import blue.soundObject.NoteParseException;
import blue.soundObject.PolyObject;
import blue.ui.utilities.FileChooserManager;
import blue.utility.midi.MidiImportUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javafx.stage.FileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.windows.WindowManager;

public final class ImportMidiAction
implements ActionListener {
    public ImportMidiAction() {
        FileChooserManager fcm = FileChooserManager.getDefault();
        fcm.setMultiSelectionEnabled(this.getClass(), false);
        fcm.addFilter(this.getClass(), new FileChooser.ExtensionFilter("MIDI File (*.mid, *.midi)", new String[]{"*.mid", "*.midi"}));
        fcm.setSelectedFile(this.getClass(), GeneralSettings.getInstance().getDefaultDirectory());
        fcm.setDialogTitle(this.getClass(), "Select MIDI File");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(this::importMidiFile);
    }

    public void importMidiFile() {
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        List rValue = FileChooserManager.getDefault().showOpenDialog(this.getClass(), (Component)mainWindow);
        if (rValue.size() == 0) {
            StatusDisplayer.getDefault().setStatusText(BlueSystem.getString((String)"message.actionCancelled"));
            return;
        }
        File midiFile = (File)rValue.get(0);
        BlueData tempData = new BlueData();
        try {
            PolyObject pObj = MidiImportUtilities.convertMidiFile(mainWindow, midiFile);
            if (pObj == null) {
                JOptionPane.showMessageDialog(mainWindow, BlueSystem.getString((String)"message.file.couldNotImport"), BlueSystem.getString((String)"message.error"), 0);
                return;
            }
            tempData.getScore().clear();
            tempData.getScore().add((Object)pObj);
        }
        catch (NoteParseException e) {
            JOptionPane.showMessageDialog(mainWindow, BlueSystem.getString((String)"message.file.couldNotImport"), BlueSystem.getString((String)"message.error"), 0);
            return;
        }
        BlueProject project = new BlueProject(tempData, null);
        BlueProjectManager.getInstance().setCurrentProject(project);
    }
}

