/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.ArrayUtil;
import electric.util.Lex;
import electric.util.Node;
import electric.xml.Element;
import electric.xml.NamespaceException;
import electric.xml.Text;
import java.io.IOException;
import java.io.Writer;

public final class Attribute
extends Node {
    Element element;
    String prefix;
    String namespace;
    String name;
    String value;
    boolean isNamespace;
    boolean isId;
    boolean raw;

    public Attribute(String string, String string2) {
        this.name = string;
        this.value = string2;
        this.initialize();
    }

    public Attribute(String string, String string2, String string3) {
        this.prefix = string;
        this.name = string2;
        this.value = string3;
        this.initialize();
    }

    public Attribute(Attribute attribute) {
        this.prefix = attribute.prefix;
        this.namespace = attribute.namespace;
        this.name = attribute.name;
        this.value = attribute.value;
        this.isNamespace = attribute.isNamespace;
        this.raw = attribute.raw;
    }

    Attribute(String string, String string2, boolean bl) {
        this.name = string;
        this.value = string2;
        this.isNamespace = bl;
    }

    Attribute(Lex lex, Element element) throws IOException {
        this.name = lex.readToken();
        if (lex.peek() == 58) {
            this.prefix = this.name;
            lex.read();
            this.name = lex.readToken();
        }
        lex.readChar(61);
        lex.skipWhitespace();
        int n = lex.read();
        if (n == 34) {
            this.value = lex.readToPattern("\"", 66);
        } else if (n == 39) {
            this.value = lex.readToPattern("'", 66);
        } else {
            throw new IOException("missing quote at start of attribute");
        }
        this.initialize();
    }

    public boolean equals(Object object) {
        return object instanceof Attribute && ((Attribute)object).name.equals(this.name) && ((Attribute)object).value.equals(this.value) && ArrayUtil.equals(((Attribute)object).namespace, this.namespace);
    }

    public int hashCode() {
        return this.name.hashCode() + this.value.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isNamespace) {
            stringBuffer.append("xmlns");
            if (this.name.length() > 0) {
                stringBuffer.append(':').append(this.name);
            }
        } else {
            if (this.prefix != null) {
                stringBuffer.append(this.prefix).append(':');
            }
            stringBuffer.append(this.name);
        }
        stringBuffer.append("='").append(this.value).append('\'');
        return stringBuffer.toString();
    }

    public Object clone() {
        return new Attribute(this);
    }

    public String getName() {
        return this.name;
    }

    public String getQName() {
        return this.namespace == null ? this.name : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.namespace))).append(":").append(this.name)));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getValue() {
        return this.value;
    }

    void initialize() {
        if ("xmlns".equals(this.name)) {
            this.isNamespace = true;
            this.name = "";
        } else if ("xmlns".equals(this.prefix)) {
            this.isNamespace = true;
            this.prefix = null;
        } else if ("id".equals(this.name)) {
            this.isId = true;
        }
    }

    void resolve(Element element) throws NamespaceException {
        this.element = element;
        if (this.prefix != null && !this.prefix.equals("xml")) {
            this.namespace = element.getNamespace(this.prefix);
            if (this.namespace == null) {
                throw new NamespaceException("could not find namespace with prefix ".concat(String.valueOf(String.valueOf(this.prefix))));
            }
        }
    }

    public boolean hasName(String string, String string2) {
        if (!this.name.equals(string2)) {
            return false;
        }
        if (string == null) {
            return true;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.namespace.equals(string);
    }

    public boolean isNamespace() {
        return this.isNamespace;
    }

    public Element getElement() {
        return this.element;
    }

    public void setRaw(boolean bl) {
        this.raw = bl;
    }

    public boolean getRaw() {
        return this.raw;
    }

    public void write(Writer writer, int n) throws IOException {
        if (this.isNamespace) {
            writer.write("xmlns");
            if (this.name.length() > 0) {
                writer.write(58);
                writer.write(this.name);
            }
        } else {
            if (this.prefix != null) {
                writer.write(this.prefix);
                writer.write(58);
            }
            writer.write(this.name);
        }
        writer.write("='");
        if (this.value == null) {
            writer.write("null");
        } else if (this.raw) {
            writer.write(this.value);
        } else {
            Text.writeWithSubstitution(writer, this.value);
        }
        writer.write(39);
    }
}

