/*
 * Decompiled with CFR 0.152.
 */
package de.congrace.exp4j;

import de.congrace.exp4j.Calculable;
import de.congrace.exp4j.CalculationToken;
import de.congrace.exp4j.Token;
import java.util.List;
import java.util.Map;
import java.util.Stack;

class RPNExpression
implements Calculable {
    final List<Token> tokens;
    final String expression;
    final Map<String, Double> variables;

    public RPNExpression(List<Token> tokens, String expression, Map<String, Double> variables) {
        this.tokens = tokens;
        this.expression = expression;
        this.variables = variables;
    }

    @Override
    public double calculate(double ... values) throws IllegalArgumentException {
        if (this.variables.size() == 0 && values != null) {
            throw new IllegalArgumentException("there are no variables to set values");
        }
        if (values != null && values.length != this.variables.size()) {
            throw new IllegalArgumentException("The are an unequal number of variables and arguments");
        }
        int i = 0;
        if (this.variables.size() > 0 && values != null) {
            for (Map.Entry<String, Double> entry : this.variables.entrySet()) {
                entry.setValue(values[i++]);
            }
        }
        Stack<Double> stack = new Stack<Double>();
        for (Token t : this.tokens) {
            ((CalculationToken)t).mutateStackForCalculation(stack, this.variables);
        }
        return (Double)stack.pop();
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public void setVariable(String name, double value) {
        this.variables.put(name, value);
    }

    @Override
    public double calculate() {
        return this.calculate(null);
    }
}

