;
; "Transit"
; by Steven Yi
;
; "Transit" was inspired by listening to the music of Terry Riley to
; create a work that involved long feedback delay lines. I began with a mental
; image of performers in a space working with electronics and worked to develop a
; virtual system to mimic what I had in mind. Once the setup was developed, I
; experimented with improvising material live and notating what felt right.  I
; then continued this cycle of improvisation and notation to extend and develop
; the work.
; 
; Completed: August 9, 2016
; 
; 
;
; Generated by blue 2.6.0 (http://blue.kunstmusik.com)
;

<CsoundSynthesizer>

<CsInstruments>
sr=44100
ksmps=1
nchnls=2
0dbfs=1


ga_bluemix_0_0	init	0
ga_bluemix_0_1	init	0
ga_bluemix_1_0	init	0
ga_bluemix_1_1	init	0
ga_bluemix_2_0	init	0
ga_bluemix_2_1	init	0
ga_bluemix_3_0	init	0
ga_bluemix_3_1	init	0
ga_bluemix_4_0	init	0
ga_bluemix_4_1	init	0
ga_bluesub_DelayLine_0	init	0
ga_bluesub_DelayLine_1	init	0
ga_bluesub_Master_0	init	0
ga_bluesub_Master_1	init	0


gk_blue_auto0 init 6.747130394
gk_blue_auto1 init 4.038790226
gk_blue_auto2 init 0.0500000007
gk_blue_auto3 init 0.0580700003
gk_blue_auto4 init 1
gk_blue_auto5 init 1.5
gk_blue_auto6 init 2097.8701171875
gk_blue_auto7 init 4400.3701171875
gk_blue_auto8 init 345.5130004883
gk_blue_auto9 init 60
gk_blue_auto10 init 0.19912
gk_blue_auto11 init 0.1800500005
gk_blue_auto12 init 1
gk_blue_auto13 init 0.5037900209
gk_blue_auto14 init 1.3781100512
gk_blue_auto15 init 1.0199700594
gk_blue_auto16 init 1.3939100504
gk_blue_auto17 init 0.1000000015
gk_blue_auto18 init 0.4136300087
gk_blue_auto19 init 0.3683300018
gk_blue_auto20 init 0.1000000015
gk_blue_auto21 init 0.2638800144
gk_blue_auto22 init 1
gk_blue_auto23 init 3
gk_blue_auto24 init 2
gk_blue_auto25 init 0.3780100048
gk_blue_auto26 init 3
gk_blue_auto27 init 3
gk_blue_auto28 init 0
gk_blue_auto29 init 0.9215000272
gk_blue_auto30 init 0.9960600138
gk_blue_auto31 init 0
gk_blue_auto32 init 1
gk_blue_auto33 init 0.4276400208
gk_blue_auto34 init 0.0250000004
gk_blue_auto35 init 0.7106400132
gk_blue_auto36 init 0.926880002
gk_blue_auto37 init 0
gk_blue_auto38 init 0
gk_blue_auto39 init 0.4370000064
gk_blue_auto40 init 0.3499900103
gk_blue_auto41 init 0.2465000004
gk_blue_auto42 init 0.2132100016
gk_blue_auto43 init 0.1460900009
gk_blue_auto44 init 0.1460900009
gk_blue_auto45 init 0.9809200168
gk_blue_auto46 init 0.950330019
gk_blue_auto47 init 1
gk_blue_auto48 init 0.2979100049
gk_blue_auto49 init 0.4479100108
gk_blue_auto50 init 0.0199900009
gk_blue_auto51 init 0.0500000007
gk_blue_auto52 init 87.6380004883
gk_blue_auto53 init 317.0570068359
gk_blue_auto54 init 130.5650024414
gk_blue_auto55 init 1200
gk_blue_auto56 init 1100.3100585938
gk_blue_auto57 init 2286.6201171875
gk_blue_auto58 init 1
gk_blue_auto59 init 3
gk_blue_auto60 init 1
gk_blue_auto61 init 1
gk_blue_auto62 init 2
gk_blue_auto63 init 3
gk_blue_auto64 init 0.3366900086
gk_blue_auto65 init 0.21875
gk_blue_auto66 init 0.1479000002
gk_blue_auto67 init 0.25
gk_blue_auto68 init 0
gk_blue_auto69 init 0
gk_blue_auto70 init 0
gk_blue_auto71 init 0.4616700113
gk_blue_auto72 init 0.9409700036
gk_blue_auto73 init 1
gk_blue_auto74 init 5
gk_blue_auto75 init 2
gk_blue_auto76 init 0
gk_blue_auto77 init 0.8999900818
gk_blue_auto78 init 3460.2800292969
gk_blue_auto79 init 0.2382600009
gk_blue_auto80 init -0.0001
gk_blue_auto81 init 1.5
gk_blue_auto82 init 0.0001
gk_blue_auto83 init 0.0835900009
gk_blue_auto84 init 0.6188200116
gk_blue_auto85 init 0.0373000018
gk_blue_auto86 init 0
gk_blue_auto87 init 0.0834700018
gk_blue_auto88 init 0.0901800022
gk_blue_auto89 init 0
gk_blue_auto90 init 1
gk_blue_auto91 init 1
gk_blue_auto92 init 0.5074800253
gk_blue_auto93 init 0.0040600002
gk_blue_auto94 init 0.7876700163
gk_blue_auto95 init 0.4884800017
gk_blue_auto96 init 0.9346600175
gk_blue_auto97 init 0.8465300798
gk_blue_auto98 init 0
gk_blue_auto99 init 0.5304200053
gk_blue_auto100 init 1
gk_blue_auto101 init 0
gk_blue_auto102 init 4
gk_blue_auto103 init 0.7249100208
gk_blue_auto104 init 0.1559800059
gk_blue_auto105 init 0.3113600016
gk_blue_auto106 init 2
gk_blue_auto107 init 9.5811004639
gk_blue_auto108 init 1
gk_blue_auto109 init 1
gk_blue_auto110 init 0
gk_blue_auto111 init 2
gk_blue_auto112 init 0
gk_blue_auto113 init 4
gk_blue_auto114 init 0.0730000064
gk_blue_auto115 init 6.747130394
gk_blue_auto116 init 4.038790226
gk_blue_auto117 init 0.0500000007
gk_blue_auto118 init 0.0580700003
gk_blue_auto119 init 1
gk_blue_auto120 init 1.5
gk_blue_auto121 init 2097.8701171875
gk_blue_auto122 init 4400.3701171875
gk_blue_auto123 init 345.5130004883
gk_blue_auto124 init 60
gk_blue_auto125 init 0.19912
gk_blue_auto126 init 0.1800500005
gk_blue_auto127 init 1
gk_blue_auto128 init 0.5037900209
gk_blue_auto129 init 1.3781100512
gk_blue_auto130 init 1.0199700594
gk_blue_auto131 init 1.3939100504
gk_blue_auto132 init 0.1000000015
gk_blue_auto133 init 0.4136300087
gk_blue_auto134 init 0.3683300018
gk_blue_auto135 init 0.1000000015
gk_blue_auto136 init 0.2638800144
gk_blue_auto137 init 1
gk_blue_auto138 init 3
gk_blue_auto139 init 2
gk_blue_auto140 init 0.6779900193
gk_blue_auto141 init 3
gk_blue_auto142 init 3
gk_blue_auto143 init 0
gk_blue_auto144 init 0.9215000272
gk_blue_auto145 init 0.9960600138
gk_blue_auto146 init 0
gk_blue_auto147 init 1
gk_blue_auto148 init 0.4276400208
gk_blue_auto149 init 0.0250000004
gk_blue_auto150 init 0.7106400132
gk_blue_auto151 init 0.926880002
gk_blue_auto152 init 0
gk_blue_auto153 init 0
gk_blue_auto154 init 0.4370000064
gk_blue_auto155 init 0.3499900103
gk_blue_auto156 init 0.2465000004
gk_blue_auto157 init 0.2132100016
gk_blue_auto158 init 0.1460900009
gk_blue_auto159 init 0.1460900009
gk_blue_auto160 init 0.9809200168
gk_blue_auto161 init 0.950330019
gk_blue_auto162 init 0
gk_blue_auto163 init 1
gk_blue_auto164 init -7.4000000954
gk_blue_auto165 init 0.5
gk_blue_auto166 init 55
gk_blue_auto167 init 0.6999999881
gk_blue_auto168 init 4
gk_blue_auto169 init 0.5
gk_blue_auto170 init 3.8499999046
gk_blue_auto171 init 0.5
gk_blue_auto172 init 4000
gk_blue_auto173 init 0.9150000215
gk_blue_auto174 init 0.400000006
gk_blue_auto175 init -8
gk_blue_auto176 init 0
gk_blue_auto177 init 0.5
gk_blue_auto178 init 55
gk_blue_auto179 init 0.6999800205
gk_blue_auto180 init 4
gk_blue_auto181 init 0.5
gk_blue_auto182 init 0
gk_blue_auto183 init 8000
gk_blue_auto184 init 0.8769699931
gk_blue_auto185 init 0.8485521078
gk_blue_auto186 init 0


giphaseshape_1	ftgen 0, 0, 65537, -7, 0.0, 59560.35546875, 0.1081081033, 5976.64453125, 1
giphaseshape2_1	ftgen 0, 0, 65537, -7, 0.0, 3091.3679199219, 0.5472972989, 62445.6328125, 1
gi_sine	ftgen 0, 0, 65537, 10, 1

giphaseshape_4	ftgen 0, 0, 65537, -7, 0.0, 59560.35546875, 0.1081081033, 5976.64453125, 1
giphaseshape2_4	ftgen 0, 0, 65537, -7, 0.0, 3091.3679199219, 0.5472972989, 62445.6328125, 1


	opcode tie_status,i,0

itie tival

if (itie == 0 && p3 < 0) ithen
    ; this is an initial note within a group of tied notes
    itiestatus = 0
       
elseif (p3 < 0 && itie == 1) ithen
    ; this is a middle note within a group of tied notes 
    itiestatus = 1

elseif (p3 > 0 && itie == 1) ithen
    ; this is an end note out of a group of tied notes
    itiestatus = 2

elseif (p3 > 0 && itie == 0) ithen
    ; this note is a standalone note
    itiestatus = -1

endif  

	xout	itiestatus



	endop
	opcode getFrequency,i,i

ipch 	xin

if (ipch < 15) then
	iout cps2pch ipch, 12
else
	iout = ipch
endif

	xout	iout


	endop
	opcode ADSD,k,iiiiK

 imax,iatt,idec,isus,ktrig    xin 

 ktime init 0
 kv init 0
 iper = 1/kr

 itie tival

 if (ktrig == 1) then
   ktime = ktime + iper
   if ktime < iatt then
     kt  = iatt / 4
     kv = imax
   else 
     kt = idec / 4
     kv = isus
   endif
 else
   kv = 0
   kt = idec / 4
   ktime = 0
 endif

 kenv  portk  kv, kt, -itie
            xout  kenv



	endop
	opcode yi_env_orch,k,ioooooo

ienvType, iattack, idecay, isus, irel, iOldAmp, iNewAmp	xin

kenvtype init ienvType
itie	tival
ktie 	init itie
idur = abs(p3)
imindur = iattack + idecay

if(idur < imindur) then
  idur = imindur
  p3 = idur
endif

;iEndAmp = iNewAmp / iOldAmp

if (kenvtype == 0) then
	;kenv	madsr	iattack, idecay, isus, irel
	kenv	linsegr	0, iattack, 1, idecay, isus, irel, 0
elseif (kenvtype == 1) then	
        idur2 = idur - .02
	kenv 	linseg	0, idur2 * .5, 1, .02, 1, idur2 * .5, 0
	kenv logcurve kenv, 1.5

elseif (kenvtype == 2) then	
	kenv	linseg 	0, idur - .1, 1, .1, 0	

elseif (kenvtype == 3) then

    if (ktie == 0 && p3 < 0) then
        ; this is an initial note within a group of tied notes
        kenv	linseg	0, .2, 1,  .2, 1
       
    elseif (p3 > 0 && ktie == 1) then
        ; this is an end note out of a group of tied notes
	kenv linsegr	1, .01, 1, irel, 0
 
    elseif (p3 > 0 && ktie == 0) then
        ; this is a stand alone note
	kenv	madsr	iattack, idecay, isus, irel
    else
        ; this is a middle note within a group of tied notes (p3 < 0 && itie == 1)
        kenv = 1
    endif  

endif

	xout 	kenv


	endop
	opcode yi_env_midi,k,iiiii

itype, iattack, idecay, isustain, irelease xin
setksmps 1
ktype init itype

if (ktype == 0) then

kout transegr 0, iattack, 0, 1, idecay, -2, isustain, irelease, -2, 0

else

krel release

kout ADSD 1, iattack, idecay, isustain, 1 - krel
xtratim idecay + .05

endif

	xout kout


	endop
	opcode yi_tie_amp,k,i

itie 	tie_status
ktie	init itie
idur 	init abs(p3)

iampval xin

if(itie < 1) then
	iamp  	= ampdbfs(iampval)
	kamp	init iamp
else
	iamp1 	= iamp 
	iamp	= ampdbfs(iampval)
endif

if(ktie >= 1) then
	kamp 	linseg iamp1, idur, iamp
endif

	xout kamp

	endop
	opcode yi_env,k,iiiii

ienvType, iattack, idecay, isustain, irelease xin

ipcount pcount
kpcount init ipcount

idur 	= abs(p3)

iampval 	init 0

if (ipcount == 5) then
    
else
    ienvType    init p8

endif

if (kpcount == 5) then ; MIDI-Style Note

    kenv yi_env_midi ienvType, iattack, idecay, isustain, irelease

else ; SYi Orch Note

    kenv yi_env_orch ienvType, iattack, idecay, isustain, irelease

endif

	xout kenv

	endop
	opcode yi_amp_val,k,0

ipcount pcount
kpcount init ipcount

iampval 	init 0

if (ipcount == 5) then
    iampval     init p5
else
    iampval     init p6
endif

kamp 	yi_tie_amp iampval

	xout kamp

	endop
	opcode yi_pch_line,k,0

ipcount pcount
kpcount init ipcount

if (ipcount == 5) then
    ipch        getFrequency p4
    kpchline    init ipch
else
    ipch        getFrequency p4
    ipch2       getFrequency p5
endif

if (kpcount != 5) then ; SYi Orch Note
    kpchline    line ipch, abs(p3), ipch2
endif

	xout kpchline

	endop
	opcode sigMix,a,kaa

kmix, asig1, asig2 xin

xout (asig1 * (1 - kmix)) + (asig2 * kmix)

	endop
	opcode sigMixRing,a,kaa

kmix, asig1, asig2 xin

xout (asig1 * (1 - kmix)) * (asig2 * kmix)

	endop
	opcode rangeValue,k,kkk

kfreq, kmin, kmax	xin

if (kfreq <= kmin) then
	kval = 1
elseif (kfreq >= kmax) then
	kval = 0
else
	krange = kmax - kmin
	kval = 1 - ((kfreq - kmin) / krange)
endif

	xout kval



	endop
	opcode noiseModulate,a,a

asig xin

arnd random 0,1

	xout	asig * arnd

	endop
	opcode yi_instr_gen,kkkk,iiiiiK

ienvType, iattack, idecay, isustain, irelease, kspace xin

ipcount pcount
kpcount init ipcount

idur 	= abs(p3)

iampval 	init 0

if (ipcount == 5) then
    ipch        getFrequency p4
    kpchline    init ipch
    iampval     init p5
    kspaceOut   = kspace

else

    ipch        getFrequency p4
    ipch2       getFrequency p5
    iampval     init p6
    ienvType    init p8
    kspaceOut   init (p7 * .5) + .5

endif

if (kpcount == 5) then ; MIDI-Style Note

    kenv yi_env_midi ienvType, iattack, idecay, isustain, irelease

else ; SYi Orch Note

    kpchline    line ipch, idur, ipch2
    kenv        yi_env_orch ienvType, iattack, idecay, isustain, irelease

endif

kamp 	yi_tie_amp iampval

	xout kpchline, kamp, kenv, kspaceOut

	endop
	opcode multiOscil,a,KKK

kwaveform, kpch, kpulsewidth xin

aout = 0
kcount = 0

itie tival


if (kwaveform == 7) then
	aout 	noise 1, 0
	kcount = 1
endif

if (kwaveform == 0 || kwaveform == 3 || kwaveform == 4 || kwaveform == 6) then
	aout 	vco2 	1, kpch, (itie == 0 ? 12 : 1)

	kcount = 1
endif

if (kwaveform == 1 || kwaveform == 3 || kwaveform == 6) then
	atemp 	vco2 	1, kpch, itie
	aout = aout + atemp
	kcount = kcount + 1
endif

if (kwaveform == 2 || kwaveform == 4 || kwaveform == 5 || kwaveform == 6) then
	atemp 	vco2 	1, kpch, (itie == 0 ? 2 : 1), kpulsewidth
	aout = aout + atemp
	kcount = kcount + 1
endif

aout = aout / kcount

xout aout

	endop
	opcode simpleMultiFilter,a,aKKK

ain, ktype, kfreq, kbandwidth xin

ktypeAdj = ktype - 1

iskip 	tival 

if (ktypeAdj < 0) then
	aout = ain
elseif (ktypeAdj == 0) then
	aout butterlp ain, kfreq, iskip
elseif (ktypeAdj == 1) then
	aout butterhp ain, kfreq, iskip
elseif (ktypeAdj == 2) then
	aout butterbp ain, kfreq, kbandwidth, iskip
endif

xout aout

	endop
	opcode tekno_lpf4,a,aKK

asig, kfco, krez xin

idistortiontab chnget "lpf4.disttab"

if(idistortiontab == 0) then

idistortiontab	ftgen 0, 0, 65537, 8, 1, 8193, .99, 8192, .96, 8192, .9, 4096, -.8, 8192, -.8, 4096, -.9, 8192, -.96, 8192, -.99, 8192, -1
chnset idistortiontab, "lpf4.disttab"

endif


krez = krez * 4.999 + .001

ifqcadj  =      .149659863*sr
;iband = 0

; Resonant Lowpass Filter (4 Pole)
kcl    =        ifqcadj/kfco
krez2  =        krez/(1+exp(kfco/11000))
//krez2l =        2.0/(1+exp(kfco/11000))
ka1l   =        kcl/krez2 - 1 ;-(1+krez2*iband)
kasql  =        kcl*kcl
kbl    =        1+ka1l+kasql

ka = (ka1l+2*kasql)/kbl
kb = -kasql/kbl

asig   nlfilt   asig/kbl, ka, kb, 0, 0, 1
asig2  nlfilt   asig/kbl, ka, kb, 0, 0, 1

arez   =       (asig2-asig)*.5

aclip  tablei  arez, idistortiontab, 1, .5
aout   =       (aclip * .5) + asig


xout asig2

	endop
	opcode yiMultiLpf,a,aKKKK

aout, kfilterType, kcutoff, kresonance, kdistortion xin

itie tival

if (kfilterType == 0) then

	aout	moogladder		aout, kcutoff, kresonance, itie

elseif (kfilterType == 1) then

	aout	moogvcf		aout, kcutoff, kresonance, 0, itie

elseif (kfilterType == 2) then

	aout	lpf18		aout, kcutoff, kresonance, kdistortion, itie

elseif (kfilterType == 3) then

	aout	butterlp		aout, kcutoff, itie

elseif (kfilterType == 4) then

	aout	tekno_lpf4		aout, kcutoff, kresonance

elseif (kfilterType == 5) then

	aout	moogvcf2		aout, kcutoff, kresonance, 0, itie

endif



xout aout

	endop
	opcode chorus,aa,aaK

ain1, ain2, kwet xin

setksmps 1

; CHORUS

isin		ftgentmp	0, 0, 65536, 10, 1

ilevl		=		0.3		; Output level
idelay		=		0.01		; Delay in ms
idpth		=		0.002		; Depth in ms
imax		=		0.25		; Maximum LFO rate
imin		=		0.5		; Minimum LFO rate
iwave		=		isin		; LFO waveform

ain             =               ain1 + ain2 * .5
ain             =               ain * ilevl

i01             =               rnd(imax)
i02             =               rnd(imax)
i03             =               rnd(imax)
i04             =               rnd(imax)
i05             =               rnd(imax)
i06             =               rnd(imax)
i07             =               rnd(imax)
i08             =               rnd(imax)
i09             =               rnd(imax)
i10             =               rnd(imax)
i11             =               rnd(imax)
i12             =               rnd(imax)

alfo01          oscil           idpth, i01 + imin, iwave
alfo02          oscil           idpth, i02 + imin, iwave, .08
alfo03          oscil           idpth, i03 + imin, iwave, .17
alfo04          oscil           idpth, i04 + imin, iwave, .25
alfo05          oscil           idpth, i05 + imin, iwave, .33
alfo06          oscil           idpth, i06 + imin, iwave, .42
alfo07          oscil           idpth, i07 + imin, iwave, .50
alfo08          oscil           idpth, i08 + imin, iwave, .58
alfo09          oscil           idpth, i09 + imin, iwave, .67
alfo10          oscil           idpth, i10 + imin, iwave, .75
alfo11          oscil           idpth, i11 + imin, iwave, .83
alfo12          oscil           idpth, i12 + imin, iwave, .92

atemp           delayr          idelay + idpth +.1
a01             deltapi         idelay + alfo01
a02             deltapi         idelay + alfo02
a03             deltapi         idelay + alfo03
a04             deltapi         idelay + alfo04
a05             deltapi         idelay + alfo05
a06             deltapi         idelay + alfo06
a07             deltapi         idelay + alfo07
a08             deltapi         idelay + alfo08
a09             deltapi         idelay + alfo09
a10             deltapi         idelay + alfo10
a11             deltapi         idelay + alfo11
a12             deltapi         idelay + alfo12
                delayw          ain

achorusl        sum		a01, a02, a03, a04, a05, a06
achorusr        sum             a07, a08, a09, a10, a11, a12

aout1		=		ain1 * (1-kwet) + achorusl * kwet
aout2		=		ain2 * (1-kwet) + achorusr * kwet

xout	aout1, aout2

	endop
	opcode uniqueUDO0,k,ioooooo

ienvType, iattack, idecay, isus, irel, iOldAmp, iNewAmp	xin

kenvtype init ienvType
itie	tival
ktie 	init itie
idur = abs(p3)
imindur = iattack + idecay
print ienvType
if(idur < imindur) then
  idur = imindur
  p3 = idur
endif

;iEndAmp = iNewAmp / iOldAmp

if (kenvtype == 0) then
	;kenv	madsr	iattack, idecay, isus, irel
	kenv	linsegr	0, iattack, 1, idecay, isus, irel, 0
elseif (kenvtype == 1) then	
        idur2 = idur - .02
	kenv 	linseg	0, idur2 * .5, 1, .02, 1, idur2 * .5, 0
	kenv logcurve kenv, 1.5

elseif (kenvtype == 2) then	
	kenv	linseg 	0, idur - .1, 1, .1, 0	

elseif (kenvtype == 3) then

    if (ktie == 0 && p3 < 0) then
        ; this is an initial note within a group of tied notes
        kenv	linseg	0, .2, 1,  .2, 1
       
    elseif (p3 > 0 && ktie == 1) then
        ; this is an end note out of a group of tied notes
	kenv linsegr	1, .01, 1, irel, 0
 
    elseif (p3 > 0 && ktie == 0) then
        ; this is a stand alone note
	kenv	madsr	iattack, idecay, isus, irel
    else
        ; this is a middle note within a group of tied notes (p3 < 0 && itie == 1)
        kenv = 1
    endif  

endif

	xout 	kenv


	endop
	opcode uniqueUDO1,kkkk,iiiiiK

ienvType, iattack, idecay, isustain, irelease, kspace xin

ipcount pcount
kpcount init ipcount

idur 	= abs(p3)

iampval 	init 0

if (ipcount == 5) then
    ipch        getFrequency p4
    kpchline    init ipch
    iampval     init p5
    kspaceOut   = kspace

else

    ipch        getFrequency p4
    ipch2       getFrequency p5
    iampval     init p6
    ienvType    init p8
    kspaceOut   init (p7 * .5) + .5

endif

if (kpcount == 5) then ; MIDI-Style Note

    kenv yi_env_midi ienvType, iattack, idecay, isustain, irelease

else ; SYi Orch Note

    kpchline    line ipch, idur, ipch2
    kenv        uniqueUDO0 ienvType, iattack, idecay, isustain, irelease

endif

kamp 	yi_tie_amp iampval

	xout kpchline, kamp, kenv, kspaceOut

	endop
	opcode lfo2,k,kko

kcps, ktype, iskip xin

iSineTable	chnget	"lfo2_sine"

if (iSineTable == 0) then
	iSineTable	ftgen 	0, 0, 65536, 10, 1 ; sine wave
	chnset	iSineTable, "lfo2_sine"
endif

kout init 0

if (ktype == 0) then ;SINE
	kout 	oscil3 1, kcps, iSineTable, iskip * -1

elseif (ktype == 1) then ;TRIANGLE
	aout	vco2 1, kcps, 12, iskip
	kout downsamp aout

elseif (ktype == 2) then ;SQUARE (BI-POLAR)
	aout	vco2 1, kcps, 10, iskip
	kout downsamp aout

elseif (ktype == 3) then ;SQUARE (UNI-POLAR)
	aout	vco2 1, kcps, 10, iskip
	kout downsamp aout
	kout = (kout + 1) / 2

elseif (ktype == 4) then ;SAW TOOTH (UP)
	aout	vco2 1, kcps, 0, iskip
	kout downsamp aout


elseif (ktype == 5) then ;SAW TOOTH (DOWN)
	aout	vco2 1, kcps, 0, iskip
	kout downsamp aout
	kout = kout * -1

endif

xout kout

	endop
	opcode distortion,a,a

ain xin

idistortiontab chnget "lpf4.disttab"

if(idistortiontab == 0) then

idistortiontab	ftgen 0, 0, 65537, 8, 1, 8193, .99, 8192, .96, 8192, .9, 4096, -.8, 8192, -.8, 4096, -.9, 8192, -.96, 8192, -.99, 8192, -1
chnset idistortiontab, "lpf4.disttab"

endif

aclip  tablei  ain, idistortiontab, 1, .5
aout   =       (aclip * .5) + ain

xout aout

	endop
	opcode tokbox,a,akk

ain, kvoice, kformi xin

itables chnget "tokbox.tables"
iformamp0 chnget "tokbox.formamp0"
iformamp1 chnget "tokbox.formamp1"
iformamp2 chnget "tokbox.formamp2"


if(itables == 0) then

; Formants 0="ee", 1="i", 2="e", 3="ae", 4="ah", 5="aw", 6="u^", 7="oo", 8="u", 9="er"

	; Male Formants Spoken
imale0	ftgen 0, 0, 16, -2, 270, 390, 530, 660, 730, 570, 440, 300, 640, 490
imale1	ftgen 0, 0, 16, -2, 2290, 1990, 1840, 1720, 1090, 840, 1020, 870, 1190, 1350
imale2	ftgen 0, 0, 16, -2, 3010, 2550, 2480, 2410, 2440, 2410, 2240, 2240, 2390, 1690

	; Male Formants Sung
imalesung0	ftgen 0, 0, 16, -2, 300, 375, 530, 620, 700, 610, 400, 350, 500, 400
imalesung1	ftgen 0, 0, 16, -2, 1950, 1810, 1500, 1490, 1200, 1000, 720, 640, 1200, 1150
imalesung2	ftgen 0, 0, 16, -2, 2750, 2500, 2500, 2250, 2600, 2600, 2500, 2550, 2675, 2500



	; Female Formants Spoken
ifemale0	ftgen 0, 0, 16, -2, 310, 430, 610, 860, 850, 590, 470, 370, 760, 500
ifemale1	ftgen 0, 0, 16, -2, 2790, 2480, 2330, 2050, 1220, 920, 1160, 950, 1400, 1640
ifemale2	ftgen 0, 0, 16, -2, 3310, 3070, 2990, 2850, 2810, 2710, 2680, 2670, 2780, 1960

	; Female Formants Sung
ifemalesung0	ftgen 0, 0, 16, -2, 400, 475, 550, 600, 700, 625, 425, 400, 550, 450
ifemalesung1	ftgen 0, 0, 16, -2, 2250, 2100, 1750, 1650, 1300, 1240, 900, 800, 1300, 1350
ifemalesung2	ftgen 0, 0, 16, -2, 3300, 3450, 3250, 3000, 3250, 3250, 3375, 3250, 3250, 3050



	; Child Formants Spoken
ichild0	ftgen 0, 0, 16, -2, 370, 530, 690, 1010, 1030, 680, 560, 430, 850, 560
ichild1	ftgen 0, 0, 16, -2, 3200, 2730, 2610, 2320, 1370, 1060, 1410, 1170, 1590, 1820
ichild2	ftgen 0, 0, 16, -2, 3730, 3600, 3570, 3320, 3170, 3180, 3310, 3260, 3360, 2160

; Formant Amplitudes
iformamp0	ftgen 0, 0, 16, -2, -4, -3, -2, -1, -1, -.001, -1, -3, -1, -5
iformamp1	ftgen 0, 0, 16, -2, -24, -23, -17, -12, -5, -7, -12, -19, -10, -15
iformamp2	ftgen 0, 0, 16, -2, -28, -27, -24, -22, -28, -34, -34, -43, -27, -20


itables		ftgen 0, 0, 16, -2, imale0, imale1, imale2, imalesung0, imalesung1, imalesung2, \
				    ifemale0, ifemale1, ifemale2, ifemalesung0, ifemalesung1, ifemalesung2, \
				    ichild0, ichild1, ichild2, 0
chnset itables, "tokbox.tables"

chnset iformamp0, "tokbox.formamp0"
chnset iformamp1, "tokbox.formamp1"
chnset iformamp2, "tokbox.formamp2"

endif

ibw = 8
kvoiceindex = kvoice * 3
iptime = .5

kfmtab1 tablekt kvoiceindex, itables
kfmtab2 tablekt kvoiceindex + 1, itables
kfmtab3 tablekt kvoiceindex + 2, itables
	
;kformi   oscil   1, 1/idur, ixtab        ; Read the formant index table

kform1   tablekt   kformi, kfmtab1         ; Read the first formant frequency
kdb1     table   kformi, iformamp0          ; Read the first formant dB's
kamp1    =       dbfsamp(kdb1)          ; Convert from decibels to amplitude
kform2   tablekt   kformi, kfmtab2         ; Read the second formant frequency
kdb2     table   kformi, iformamp1          ; Read the second formant dB's
kamp2    =       dbfsamp(kdb2)          ; Convert dB to amp
kform3   tablekt   kformi, kfmtab3         ; Read the third formant frequency
kdb3     table   kformi, iformamp2          ; Read the third formnat dB's
kamp3    =       dbfsamp(kdb3)          ; Convert dB to amp

kfrm1p   port    kform1, iptime, 300     ; Portamento to the next formant
kamp1p   port    kamp1,  iptime, .15     ; Portamento to the next amplitude
kfrm2p   port    kform2, iptime, 2000    ; Repeat for second
kamp2p   port    kamp2,  iptime, .15
kfrm3p   port    kform3, iptime, 4000    ; and again for the third
kamp3p   port    kamp3,  iptime, .15

;adist    =       tanh(ain/4000)*8000
adist = ain
aform1   butterbp adist, kfrm1p, kfrm1p/ibw  ; Compute the three resonances
aform2   butterbp adist, kfrm2p, kfrm2p/ibw
aform3   butterbp adist, kfrm3p, kfrm3p/ibw

aout     =       (aform1*kamp1p+aform2*kamp2p+aform3*kamp3p)/5  ; Scale and sum

xout aout

	endop
	opcode blueEffect0,aa,aa ; ReverbSC

ain1,ain2	xin
aout1, aout2  reverbsc ain1, ain2, gk_blue_auto173, gk_blue_auto172

aout1 = (ain1 * gk_blue_auto174) + (aout1 * (1 - gk_blue_auto174))
aout2 = (ain2 * gk_blue_auto174) + (aout2 * (1 - gk_blue_auto174))


xout	aout1,aout2


	endop
	opcode blueEffect1,aa,aa ; Tempo-Sync Stereo Delay

ain1,ain2	xin
kbpm = gk_blue_auto178
knl = gk_blue_auto180

kfb = gk_blue_auto179
kdel = ( 1/(kbpm/60) * knl ) * 1000

aleft init 0
aright init 0


if ( 0 == 0 ) then
	ado1 = aleft + ain1
	ado2 = aright + ain2
else
	ado1 = aright + ( .5 * (ain1 + ain2) )
	ado2 = aleft
endif

aleft vdelay ado1 * kfb, kdel, 8000
aright vdelay ado2 * kfb, kdel, 8000

if ( 0 == 1 ) then
	aout1 = aright
	aout2 = aleft
else
	aout1 = aleft
	aout2 = aright
endif

aout1 = ( aout1 * ( 1 - gk_blue_auto177 )  ) * 2
aout2 = ( aout2 * gk_blue_auto177 ) * 2

aout1 = (ain1 * gk_blue_auto181) + (aout1 * (1 - gk_blue_auto181))
aout2 = (ain2 * gk_blue_auto181) + (aout2 * (1 - gk_blue_auto181))
xout	aout1,aout2


	endop
	opcode blueEffect2,aa,aa ; ReverbSC

ain1,ain2	xin
aout1, aout2  reverbsc ain1, ain2, gk_blue_auto184, gk_blue_auto183

aout1 = (ain1 * gk_blue_auto185) + (aout1 * (1 - gk_blue_auto185))
aout2 = (ain2 * gk_blue_auto185) + (aout2 * (1 - gk_blue_auto185))


xout	aout1,aout2


	endop


	instr 1	;PhaseShaper - Orch
imaxpfield = p8 // dummy statement to get Csound to assume up to max pfields of 8
kenv yi_env 0, i(gk_blue_auto0), i(gk_blue_auto2), i(gk_blue_auto29), i(gk_blue_auto26)
kenv2 yi_env 0, i(gk_blue_auto1), i(gk_blue_auto3), i(gk_blue_auto30), i(gk_blue_auto27)
kamp yi_amp_val

kpchline 	yi_pch_line

icount 	pcount

iSpace	= (icount == 5) ? 0 : p7


kmix = gk_blue_auto24
kwavemin = gk_blue_auto41
kwavemax = gk_blue_auto39
kwaverange = kwavemin - kwavemax

kwavemin2 = gk_blue_auto42
kwavemax2 = gk_blue_auto40
kwaverange2 = kwavemax2 - kwavemin2

kfollowWaveLow = gk_blue_auto12
kfollowWaveHigh = gk_blue_auto10
kfollowWaveRange = kfollowWaveHigh - kfollowWaveHigh

kfollowWaveLow2 = gk_blue_auto13
kfollowWaveHigh2 = gk_blue_auto11
kfollowWaveRange2 = kfollowWaveHigh2 - kfollowWaveHigh2

ilfoType = i(gk_blue_auto22) - 1
klfoAmp = gk_blue_auto14
klfoFreq = gk_blue_auto18
ilfoDelay = i(gk_blue_auto16)
ilfoRise = i(gk_blue_auto20)

if (gk_blue_auto23 == 0) then
	ilfoType2 = ilfoType
	klfoAmp2 = gk_blue_auto14
	klfoFreq2 = gk_blue_auto18
	ilfoDelay2 = ilfoDelay
	ilfoRise2 = ilfoRise
else
	ilfoType2 = i(gk_blue_auto23) - 2
	klfoAmp2 = gk_blue_auto15
	klfoFreq2 = gk_blue_auto19
	ilfoDelay2 = i(gk_blue_auto17)
	ilfoRise2 = i(gk_blue_auto21)
endif

/* SOUND GENERATION CODE */

if (gk_blue_auto22 == 0) then
	alfo = 0
else
	alfo 	lfo	 klfoAmp, klfoFreq, (ilfoType < 0 ? 0 : ilfoType)
	alfodelay linseg 0, ilfoDelay + .0001, 0, ilfoRise + .0001, 1, .1, 1
	alfo = alfodelay * alfo
endif

andx	phasor kpchline + alfo

; Oscilator 1
if (kmix == 1) kgoto skipOscil1
andx2	table3	andx, giphaseshape_1, 1


if (gk_blue_auto31 == 1)  then
	kwaveenv = kenv
else 
	kwaveenv 	yi_env 0, i(gk_blue_auto33), i(gk_blue_auto35), i(gk_blue_auto45), i(gk_blue_auto43)
endif
kwaveenv = (kwaveenv * kwaverange) + kwavemin
if (gk_blue_auto37 == 1) then
	kwaverange rangeValue kpchline, gk_blue_auto8, gk_blue_auto6
	kwaverange = (kwaverange * kfollowWaveRange) + kfollowWaveHigh
	kwaveenv = kwaverange * kwaveenv
endif
andx2 	sigMix	kwaveenv, andx, andx2

aout	table3  andx2, gi_sine, 1

; Osilator 1'
if (kmix != 3) kgoto skipOscil1
andxdetune phasor (kpchline * gk_blue_auto4) + alfo
andx2	table3	andxdetune, giphaseshape_1, 1


if (gk_blue_auto31 == 1)  then
	kwaveenv = kenv
else 
	kwaveenv yi_env 0, i(gk_blue_auto33), i(gk_blue_auto35), i(gk_blue_auto45), i(gk_blue_auto43)
endif
kwaveenv = (kwaveenv * kwaverange) + kwavemin
if (gk_blue_auto37 == 1) then
	; kwaverange calculated in Oscilator 1
	kwaveenv = kwaverange * kwaveenv
endif
andx2 	sigMix	kwaveenv, andxdetune, andx2

aout_detune	table3  andx2, gi_sine, 1

skipOscil1:


/* OSCILATOR 2 */
if (kmix == 0 || kmix == 3) kgoto skipOscil2
if (gk_blue_auto23 == 0) then
	alfo2 = alfo
elseif (gk_blue_auto23 == 1) then
        alfo2 = 0
else
	alfo2 	lfo	 klfoAmp2, klfoFreq2, (ilfoType2 < 0 ? 0 : ilfoType2)
	alfodelay2 linseg 0, ilfoDelay2 + .0001, 0, ilfoRise2 + .0001, 1, .1, 1
	alfo2 = alfodelay2 * alfo2
endif

andx	phasor kpchline + alfo2


; Oscilator 2
if (kmix != 1) kgoto skipOscil2
andx2	table3	andx, giphaseshape2_1, 1

if (gk_blue_auto32 == 1) then
	kwaveenv2 = kenv2
else 
        kwaveenv2    yi_env  0, i(gk_blue_auto34), i(gk_blue_auto36), i(gk_blue_auto46), i(gk_blue_auto44)
endif
kwaveenv2 = (kwaveenv2 * kwaverange2) + kwavemin2
if (gk_blue_auto38 == 1) then
	kwaverange2 rangeValue kpchline, gk_blue_auto9, gk_blue_auto7
	kwaverange2 = (kwaverange2 * kfollowWaveRange2) + kfollowWaveLow2
	kwaveenv2 = kwaverange2 * kwaveenv2
endif
andx2 	sigMix	kwaveenv2, andx, andx2

aout2	table3  andx2, gi_sine, 1

skipOscil2:

; Osilator 2'
if (kmix != 2) kgoto skipOscil2end
andxdetune2 phasor (kpchline * gk_blue_auto5) + alfo2
andx2	table3	andxdetune2, giphaseshape2_1, 1

if (gk_blue_auto32 == 1) then
	kwaveenv2 = kenv2
else 
	kwaveenv2	yi_env 0, i(gk_blue_auto34), i(gk_blue_auto36), i(gk_blue_auto46), i(gk_blue_auto44)
endif
kwaveenv2 = (kwaveenv2 * kwaverange2) + kwavemin2
if (gk_blue_auto38 == 1) then
	;kwaverange calculated in Oscilator 2
	kwaveenv2 = kwaverange2 * kwaveenv2
endif
andx2 	sigMix	kwaveenv2, andxdetune2, andx2

aout2_detune	table3  andx2, gi_sine, 1

skipOscil2end:

aout = aout * kenv 
aout_detune = aout_detune * kenv
aout2 = aout2 * kenv2
aout2_detune = aout2_detune * kenv2

if (kmix == 1) then
	aout = aout2
elseif (kmix == 2) then
	if (gk_blue_auto28 == 1) then
		aout 	sigMixRing	gk_blue_auto25, aout, aout2_detune
	else 
		aout 	sigMix		gk_blue_auto25, aout, aout2_detune
	endif
elseif (kmix == 3) then
	if (gk_blue_auto28 == 1) then
		aout 	sigMixRing	gk_blue_auto25, aout, aout_detune
	else 
		aout 	sigMix		gk_blue_auto25, aout, aout_detune
	endif
endif

aout	= aout * kamp 

aLeft, aRight	pan2	aout, (iSpace * .5) + .5


ga_bluemix_0_0 +=  aLeft
ga_bluemix_0_1 +=  aRight

	endin

	instr 2	;b64 v2

imaxpfield = p8 // dummy statement to get Csound to assume up to max pfields of 8
kpchline, kamp, kenv, kspace yi_instr_gen 0, i(gk_blue_auto50), i(gk_blue_auto51), i(gk_blue_auto72), i(gk_blue_auto67), gk_blue_auto71 


; SOUND GENERATION CODE

aout1 	multiOscil gk_blue_auto73, kpchline * gk_blue_auto61, gk_blue_auto64
aout2 	multiOscil gk_blue_auto74, kpchline * gk_blue_auto62, gk_blue_auto65
aout3 	multiOscil gk_blue_auto75, kpchline * gk_blue_auto63, gk_blue_auto66

aout1 	simpleMultiFilter	aout1 * gk_blue_auto47, gk_blue_auto58, gk_blue_auto55, gk_blue_auto52
aout2 	simpleMultiFilter	aout2 * gk_blue_auto48, gk_blue_auto59, gk_blue_auto56, gk_blue_auto53
aout3 	simpleMultiFilter	aout3 * gk_blue_auto49, gk_blue_auto60, gk_blue_auto57, gk_blue_auto54

aout = 0

if (gk_blue_auto68 == 1) then
	atemp = aout1 * aout3
	aout = atemp
else
	aout = aout1
endif

if (gk_blue_auto69 == 1) then
	atemp = aout2 * aout1
	aout = aout + atemp
else
	aout = aout + aout2
endif


if (gk_blue_auto70 == 1) then
	atemp = aout3 * aout2
	aout = aout + atemp
else
	aout = aout + aout3
endif

aout	dcblock aout

aout = aout * kamp * kenv / (gk_blue_auto47 + gk_blue_auto48 + gk_blue_auto49)

; END SOUND GENERATION CODE

aLeft, aRight	pan2	aout, kspace

ga_bluemix_1_0 +=  aLeft
ga_bluemix_1_1 +=  aRight

	endin

	instr 3	;Alpha v2
ipcount pcount
kpcount init ipcount

idur 	= abs(p3)
iskip 	tival

imaxpfield = p8 // dummy statement to get Csound to assume up to max pfields of 8
kpchline, kamp, kenv, kspace uniqueUDO1 i(gk_blue_auto76), i(gk_blue_auto77), i(gk_blue_auto79), i(gk_blue_auto100), i(gk_blue_auto97), gk_blue_auto99 

iamprel = i(gk_blue_auto97)
ivcfrel = i(gk_blue_auto107)

iminrelease = (iamprel < ivcfrel) ? iamprel : ivcfrel


if (gk_blue_auto106 == 0) then
	kcutoff = 1
elseif (gk_blue_auto106 == 1 && kpcount == 5) then

	if (gk_blue_auto107 == 10) then
		kcutoff linseg 0, i(gk_blue_auto103), 1, i(gk_blue_auto104), i(gk_blue_auto108), iminrelease, i(gk_blue_auto108)
	else
		kcutoff linsegr 0, i(gk_blue_auto103), 1, i(gk_blue_auto104), i(gk_blue_auto108), iminrelease, 0
	endif
else
	kcutoff = kenv
endif

kcutoff logcurve kcutoff, 1.5

kcutoffMin = gk_blue_auto78 * (1 - gk_blue_auto105)
kcutoffRange = gk_blue_auto78 - kcutoffMin

kcutoff = kcutoffMin + (kcutoff * kcutoffRange)

if (gk_blue_auto86 != 0) then

klfo 	lfo2	gk_blue_auto84, gk_blue_auto86 - 1, iskip

kenv = kenv + (kenv * (klfo * gk_blue_auto87) * .25)
kpchline = kpchline * (1 + (klfo * gk_blue_auto85) * .0625)
kcutoff = kcutoff + (kcutoff * (klfo * gk_blue_auto88) * .25)

endif

iwaveform1	= (iskip == 0) ? i(gk_blue_auto111) * 2 : iskip
iwaveform2 	= (iskip == 0) ? i(gk_blue_auto112) * 2 : iskip
iwaveform3 	= (iskip == 0) ? i(gk_blue_auto113) * 2 : iskip

kamp1		= gk_blue_auto91
kamp2		= gk_blue_auto92
kamp3		= gk_blue_auto93
kampnoise	= gk_blue_auto89

kdetune1	= gk_blue_auto80 * kpchline
kdetune2	= gk_blue_auto81 * kpchline
kdetune3        = gk_blue_auto82 * kpchline

/* SOUND GENERATION CODE */
a1	vco2	1, kpchline + kdetune1, iwaveform1, gk_blue_auto94
a2	vco2	1, kpchline + kdetune2, iwaveform2, gk_blue_auto95
a3	vco2	1, kpchline + kdetune3, iwaveform3, gk_blue_auto96

if (gk_blue_auto90 == 0) then
	anoise 	noise	 1, 0
else
	anoise 	pinkish 1
endif

anoise  butterhp anoise, kpchline

aout	= (a1 * kamp1) + (a2 * kamp2) + (a3 * kamp3) + (anoise * kampnoise)

aout	= aout / (kamp1 + kamp2 + kamp3 + kampnoise)

aout	yiMultiLpf	aout, gk_blue_auto109,  kcutoff, gk_blue_auto98, gk_blue_auto83

aout	balance 	aout, a1, 10, iskip

;aout	dcblock aout

aout	= aout * kamp * kenv 

; PANNING

aLeft, aRight 	pan2 aout, kspace

ga_bluemix_2_0 +=  aLeft
ga_bluemix_2_1 +=  aRight

	endin

	instr 4	;PhaseShaper - Orch
imaxpfield = p8 // dummy statement to get Csound to assume up to max pfields of 8
kenv yi_env 0, i(gk_blue_auto115), i(gk_blue_auto117), i(gk_blue_auto144), i(gk_blue_auto141)
kenv2 yi_env 0, i(gk_blue_auto116), i(gk_blue_auto118), i(gk_blue_auto145), i(gk_blue_auto142)
kamp yi_amp_val

kpchline 	yi_pch_line

icount 	pcount

iSpace	= (icount == 5) ? 0 : p7


kmix = gk_blue_auto139
kwavemin = gk_blue_auto156
kwavemax = gk_blue_auto154
kwaverange = kwavemin - kwavemax

kwavemin2 = gk_blue_auto157
kwavemax2 = gk_blue_auto155
kwaverange2 = kwavemax2 - kwavemin2

kfollowWaveLow = gk_blue_auto127
kfollowWaveHigh = gk_blue_auto125
kfollowWaveRange = kfollowWaveHigh - kfollowWaveHigh

kfollowWaveLow2 = gk_blue_auto128
kfollowWaveHigh2 = gk_blue_auto126
kfollowWaveRange2 = kfollowWaveHigh2 - kfollowWaveHigh2

ilfoType = i(gk_blue_auto137) - 1
klfoAmp = gk_blue_auto129
klfoFreq = gk_blue_auto133
ilfoDelay = i(gk_blue_auto131)
ilfoRise = i(gk_blue_auto135)

if (gk_blue_auto138 == 0) then
	ilfoType2 = ilfoType
	klfoAmp2 = gk_blue_auto129
	klfoFreq2 = gk_blue_auto133
	ilfoDelay2 = ilfoDelay
	ilfoRise2 = ilfoRise
else
	ilfoType2 = i(gk_blue_auto138) - 2
	klfoAmp2 = gk_blue_auto130
	klfoFreq2 = gk_blue_auto134
	ilfoDelay2 = i(gk_blue_auto132)
	ilfoRise2 = i(gk_blue_auto136)
endif

/* SOUND GENERATION CODE */

if (gk_blue_auto137 == 0) then
	alfo = 0
else
	alfo 	lfo	 klfoAmp, klfoFreq, (ilfoType < 0 ? 0 : ilfoType)
	alfodelay linseg 0, ilfoDelay + .0001, 0, ilfoRise + .0001, 1, .1, 1
	alfo = alfodelay * alfo
endif

andx	phasor kpchline + alfo

; Oscilator 1
if (kmix == 1) kgoto skipOscil1
andx2	table3	andx, giphaseshape_4, 1


if (gk_blue_auto146 == 1)  then
	kwaveenv = kenv
else 
	kwaveenv 	yi_env 0, i(gk_blue_auto148), i(gk_blue_auto150), i(gk_blue_auto160), i(gk_blue_auto158)
endif
kwaveenv = (kwaveenv * kwaverange) + kwavemin
if (gk_blue_auto152 == 1) then
	kwaverange rangeValue kpchline, gk_blue_auto123, gk_blue_auto121
	kwaverange = (kwaverange * kfollowWaveRange) + kfollowWaveHigh
	kwaveenv = kwaverange * kwaveenv
endif
andx2 	sigMix	kwaveenv, andx, andx2

aout	table3  andx2, gi_sine, 1

; Osilator 1'
if (kmix != 3) kgoto skipOscil1
andxdetune phasor (kpchline * gk_blue_auto119) + alfo
andx2	table3	andxdetune, giphaseshape_4, 1


if (gk_blue_auto146 == 1)  then
	kwaveenv = kenv
else 
	kwaveenv yi_env 0, i(gk_blue_auto148), i(gk_blue_auto150), i(gk_blue_auto160), i(gk_blue_auto158)
endif
kwaveenv = (kwaveenv * kwaverange) + kwavemin
if (gk_blue_auto152 == 1) then
	; kwaverange calculated in Oscilator 1
	kwaveenv = kwaverange * kwaveenv
endif
andx2 	sigMix	kwaveenv, andxdetune, andx2

aout_detune	table3  andx2, gi_sine, 1

skipOscil1:


/* OSCILATOR 2 */
if (kmix == 0 || kmix == 3) kgoto skipOscil2
if (gk_blue_auto138 == 0) then
	alfo2 = alfo
elseif (gk_blue_auto138 == 1) then
        alfo2 = 0
else
	alfo2 	lfo	 klfoAmp2, klfoFreq2, (ilfoType2 < 0 ? 0 : ilfoType2)
	alfodelay2 linseg 0, ilfoDelay2 + .0001, 0, ilfoRise2 + .0001, 1, .1, 1
	alfo2 = alfodelay2 * alfo2
endif

andx	phasor kpchline + alfo2


; Oscilator 2
if (kmix != 1) kgoto skipOscil2
andx2	table3	andx, giphaseshape2_4, 1

if (gk_blue_auto147 == 1) then
	kwaveenv2 = kenv2
else 
        kwaveenv2    yi_env  0, i(gk_blue_auto149), i(gk_blue_auto151), i(gk_blue_auto161), i(gk_blue_auto159)
endif
kwaveenv2 = (kwaveenv2 * kwaverange2) + kwavemin2
if (gk_blue_auto153 == 1) then
	kwaverange2 rangeValue kpchline, gk_blue_auto124, gk_blue_auto122
	kwaverange2 = (kwaverange2 * kfollowWaveRange2) + kfollowWaveLow2
	kwaveenv2 = kwaverange2 * kwaveenv2
endif
andx2 	sigMix	kwaveenv2, andx, andx2

aout2	table3  andx2, gi_sine, 1

skipOscil2:

; Osilator 2'
if (kmix != 2) kgoto skipOscil2end
andxdetune2 phasor (kpchline * gk_blue_auto120) + alfo2
andx2	table3	andxdetune2, giphaseshape2_4, 1

if (gk_blue_auto147 == 1) then
	kwaveenv2 = kenv2
else 
	kwaveenv2	yi_env 0, i(gk_blue_auto149), i(gk_blue_auto151), i(gk_blue_auto161), i(gk_blue_auto159)
endif
kwaveenv2 = (kwaveenv2 * kwaverange2) + kwavemin2
if (gk_blue_auto153 == 1) then
	;kwaverange calculated in Oscilator 2
	kwaveenv2 = kwaverange2 * kwaveenv2
endif
andx2 	sigMix	kwaveenv2, andxdetune2, andx2

aout2_detune	table3  andx2, gi_sine, 1

skipOscil2end:

aout = aout * kenv 
aout_detune = aout_detune * kenv
aout2 = aout2 * kenv2
aout2_detune = aout2_detune * kenv2

if (kmix == 1) then
	aout = aout2
elseif (kmix == 2) then
	if (gk_blue_auto143 == 1) then
		aout 	sigMixRing	gk_blue_auto140, aout, aout2_detune
	else 
		aout 	sigMix		gk_blue_auto140, aout, aout2_detune
	endif
elseif (kmix == 3) then
	if (gk_blue_auto143 == 1) then
		aout 	sigMixRing	gk_blue_auto140, aout, aout_detune
	else 
		aout 	sigMix		gk_blue_auto140, aout, aout_detune
	endif
endif

aout	= aout * kamp 

aLeft, aRight	pan2	aout, (iSpace * .5) + .5


ga_bluemix_3_0 +=  aLeft
ga_bluemix_3_1 +=  aRight

	endin

	instr 5	;VoxHumana
ipch = cps2pch(p4,12)
iamp = ampdbfs(p5)
;aenv = linsegr:a(0, 0.453, 1, 4.942, 0)
aenv = transegr:a(0, 0.453, 1, 1.0, 2.242, -1, 0)

klfo_pulse_width = lfo(0.125, 5.72, 1)
klfo_saw = lfo(0.021, 5.04, 1)
klfo_pulse = lfo(0.013, 3.5, 1)

asaw = vco2(iamp, ipch * (1 + klfo_saw))
apulse = vco2(iamp, ipch * (1.00004 + klfo_pulse), 2, 0.625 + klfo_pulse_width)

aout = sum(asaw, apulse) * 0.5 * aenv

ikeyfollow = 1 + exp( (ipch - 50) / 10000)

;aout = asaw * aenv
;aout moogladder aout, 1986 * ikeyfollow, 0
aout = butterlp(aout, 1986 * ikeyfollow) * .5
;ahp,aout,abp,abr statevar aout, 1986 * ikeyfollow, 1.0

aLeft, aRight pan2 aout, (gk_blue_auto162 * .5) + .5

ga_bluemix_4_0 +=  aout
ga_bluemix_4_1 +=  aout

	endin

	instr 6	;untitled
aLeft = ga_bluemix_2_0
 aRight = ga_bluemix_2_1

;aout	moogladder		aout, gk_blue_auto78, gk_blue_auto98


if (gk_blue_auto101 == 1) then
    aLeft tokbox aLeft, gk_blue_auto110, gk_blue_auto102
    aRight tokbox aRight, gk_blue_auto110, gk_blue_auto102
endif


; CHORUS

;if (<chorusEnabled> == 1) then
	aLeft, aRight 	chorus aLeft, aRight, gk_blue_auto114
;endif

aLeft dcblock aLeft
aRight dcblock aRight


; OUTPUT

ga_bluemix_2_0 =  aLeft
ga_bluemix_2_1 =  aRight

	endin

	instr 7	;Blue Mixer Instrument
ktempdb = ampdb(gk_blue_auto170)
ga_bluemix_1_0 *= ktempdb
ga_bluemix_1_1 *= ktempdb
ga_bluesub_DelayLine_0	+=	ga_bluemix_1_0
ga_bluesub_DelayLine_1	+=	ga_bluemix_1_1
ktempdb = ampdb(gk_blue_auto171)
ga_bluemix_2_0 *= ktempdb
ga_bluemix_2_1 *= ktempdb
ga_bluesub_DelayLine_0	+=	ga_bluemix_2_0
ga_bluesub_DelayLine_1	+=	ga_bluemix_2_1
ktempdb = ampdb(gk_blue_auto164)
ga_bluemix_0_0 *= ktempdb
ga_bluemix_0_1 *= ktempdb
ga_bluesub_DelayLine_0	+=	(ga_bluemix_0_0 * 0.8000000119)
ga_bluesub_DelayLine_1	+=	(ga_bluemix_0_1 * 0.8000000119)
ga_bluesub_Master_0	+=	ga_bluemix_0_0
ga_bluesub_Master_1	+=	ga_bluemix_0_1
ktempdb = ampdb(gk_blue_auto175)
ga_bluemix_3_0 *= ktempdb
ga_bluemix_3_1 *= ktempdb
ga_bluemix_3_0, ga_bluemix_3_1	blueEffect0	ga_bluemix_3_0, ga_bluemix_3_1
ga_bluesub_Master_0	+=	ga_bluemix_3_0
ga_bluesub_Master_1	+=	ga_bluemix_3_1
ktempdb = ampdb(gk_blue_auto176)
ga_bluemix_4_0 *= ktempdb
ga_bluemix_4_1 *= ktempdb
ga_bluesub_Master_0	+=	ga_bluemix_4_0
ga_bluesub_Master_1	+=	ga_bluemix_4_1
ktempdb = ampdb(gk_blue_auto182)
ga_bluesub_DelayLine_0 *= ktempdb
ga_bluesub_DelayLine_1 *= ktempdb
ga_bluesub_DelayLine_0, ga_bluesub_DelayLine_1	blueEffect1	ga_bluesub_DelayLine_0, ga_bluesub_DelayLine_1
ga_bluesub_Master_0	+=	ga_bluesub_DelayLine_0
ga_bluesub_Master_1	+=	ga_bluesub_DelayLine_1
ga_bluesub_Master_0, ga_bluesub_Master_1	blueEffect2	ga_bluesub_Master_0, ga_bluesub_Master_1
ktempdb = ampdb(gk_blue_auto186)
ga_bluesub_Master_0 *= ktempdb
ga_bluesub_Master_1 *= ktempdb
outc ga_bluesub_Master_0, ga_bluesub_Master_1
ga_bluemix_0_0 = 0
ga_bluemix_0_1 = 0
ga_bluemix_1_0 = 0
ga_bluemix_1_1 = 0
ga_bluemix_2_0 = 0
ga_bluemix_2_1 = 0
ga_bluemix_3_0 = 0
ga_bluemix_3_1 = 0
ga_bluemix_4_0 = 0
ga_bluemix_4_1 = 0
ga_bluesub_DelayLine_0 = 0
ga_bluesub_DelayLine_1 = 0
ga_bluesub_Master_0 = 0
ga_bluesub_Master_1 = 0

	endin

	instr 8	;Param: Volume
if (p4 == p5) then
gk_blue_auto186 init p4
turnoff
else
gk_blue_auto186 line p4, p3, p5
endif
	endin


</CsInstruments>

<CsScore>




t 0 76.0







i3	31.0	4	261.62558	261.62558	-18	0	1
i3	52.0	4	391.99545	391.99545	-18	0	1
i3	72.0	4	391.99545	391.99545	-18	0	1
i3	76.0	4	466.1638	466.1638	-18	0	1
i3	80.0	4	440.00003	440.00003	-18	0	1
i3	100.0	4	261.62558	261.62558	-18	0	1
i3	124.0	4	391.99545	391.99545	-18	0	1
i2	24.0	4	783.9909	783.9909	-14	0	0
i2	40.0	4	783.9909	783.9909	-14	0	0
i2	44.0	4	880.00006	880.00006	-14	0	0
i2	56.0	4	932.3276	932.3276	-14	0	0
i2	60.0	4	783.9909	783.9909	-14	0	0
i2	64.0	4	880.00006	880.00006	-14	0	0
i2	76.0	4	932.3276	932.3276	-14	0	0
i2	80.0	4	783.9909	783.9909	-14	0	0
i2	84.0	4	880.00006	880.00006	-14	0	0
i2	116.0	4	783.9909	783.9909	-14	0	0
i2	120.0	4	880.00006	880.00006	-14	0	0
i2	145.0	4	783.9909	783.9909	-14	0	0
i2	0.0	0.125	6.00	6.00	-12	0	0
i2	0.125	0.125	6.07	6.07	-12	0	0
i2	0.25	0.125	7.00	7.00	-12	0	0
i2	0.375	0.125	6.07	6.07	-12	0	0
i2	0.5	0.125	6.00	6.00	-12	0	0
i2	0.625	0.125	6.07	6.07	-12	0	0
i2	0.75	0.125	7.00	7.00	-12	0	0
i2	0.875	0.125	6.07	6.07	-12	0	0
i2	1.0	0.125	6.00	6.00	-12	0	0
i2	1.125	0.125	6.07	6.07	-12	0	0
i2	1.25	0.125	7.00	7.00	-12	0	0
i2	1.375	0.125	6.07	6.07	-12	0	0
i2	1.5	0.125	6.00	6.00	-12	0	0
i2	1.625	0.125	6.07	6.07	-12	0	0
i2	1.75	0.125	7.00	7.00	-12	0	0
i2	1.875	0.125	6.07	6.07	-12	0	0
i2	20.0	0.125	6.00	6.00	-12	0	0
i2	20.125	0.125	6.07	6.07	-12	0	0
i2	20.25	0.125	7.00	7.00	-12	0	0
i2	20.375	0.125	6.07	6.07	-12	0	0
i2	20.5	0.125	6.00	6.00	-12	0	0
i2	20.625	0.125	6.07	6.07	-12	0	0
i2	20.75	0.125	7.00	7.00	-12	0	0
i2	20.875	0.125	6.07	6.07	-12	0	0
i2	21.0	0.125	6.00	6.00	-12	0	0
i2	21.125	0.125	6.07	6.07	-12	0	0
i2	21.25	0.125	7.00	7.00	-12	0	0
i2	21.375	0.125	6.07	6.07	-12	0	0
i2	21.5	0.125	6.00	6.00	-12	0	0
i2	21.625	0.125	6.07	6.07	-12	0	0
i2	21.75	0.125	7.00	7.00	-12	0	0
i2	21.875	0.125	6.07	6.07	-12	0	0
i2	48.0	0.125	6.00	6.00	-12	0	0
i2	48.125	0.125	6.07	6.07	-12	0	0
i2	48.25	0.125	7.00	7.00	-12	0	0
i2	48.375	0.125	6.07	6.07	-12	0	0
i2	48.5	0.125	6.00	6.00	-12	0	0
i2	48.625	0.125	6.07	6.07	-12	0	0
i2	48.75	0.125	7.00	7.00	-12	0	0
i2	48.875	0.125	6.07	6.07	-12	0	0
i2	49.0	0.125	6.00	6.00	-12	0	0
i2	49.125	0.125	6.07	6.07	-12	0	0
i2	49.25	0.125	7.00	7.00	-12	0	0
i2	49.375	0.125	6.07	6.07	-12	0	0
i2	49.5	0.125	6.00	6.00	-12	0	0
i2	49.625	0.125	6.07	6.07	-12	0	0
i2	49.75	0.125	7.00	7.00	-12	0	0
i2	49.875	0.125	6.07	6.07	-12	0	0
i2	68.0	0.125	6.00	6.00	-12	0	0
i2	68.125	0.125	6.07	6.07	-12	0	0
i2	68.25	0.125	7.00	7.00	-12	0	0
i2	68.375	0.125	6.07	6.07	-12	0	0
i2	68.5	0.125	6.00	6.00	-12	0	0
i2	68.625	0.125	6.07	6.07	-12	0	0
i2	68.75	0.125	7.00	7.00	-12	0	0
i2	68.875	0.125	6.07	6.07	-12	0	0
i2	69.0	0.125	6.00	6.00	-12	0	0
i2	69.125	0.125	6.07	6.07	-12	0	0
i2	69.25	0.125	7.00	7.00	-12	0	0
i2	69.375	0.125	6.07	6.07	-12	0	0
i2	69.5	0.125	6.00	6.00	-12	0	0
i2	69.625	0.125	6.07	6.07	-12	0	0
i2	69.75	0.125	7.00	7.00	-12	0	0
i2	69.875	0.125	6.07	6.07	-12	0	0
i2	96.0	0.125	6.00	6.00	-12	0	0
i2	96.125	0.125	6.07	6.07	-12	0	0
i2	96.25	0.125	7.00	7.00	-12	0	0
i2	96.375	0.125	6.07	6.07	-12	0	0
i2	96.5	0.125	6.00	6.00	-12	0	0
i2	96.625	0.125	6.07	6.07	-12	0	0
i2	96.75	0.125	7.00	7.00	-12	0	0
i2	96.875	0.125	6.07	6.07	-12	0	0
i2	97.0	0.125	6.00	6.00	-12	0	0
i2	97.125	0.125	6.07	6.07	-12	0	0
i2	97.25	0.125	7.00	7.00	-12	0	0
i2	97.375	0.125	6.07	6.07	-12	0	0
i2	97.5	0.125	6.00	6.00	-12	0	0
i2	97.625	0.125	6.07	6.07	-12	0	0
i2	97.75	0.125	7.00	7.00	-12	0	0
i2	97.875	0.125	6.07	6.07	-12	0	0
i2	121.0	0.125	6.00	6.00	-12	0	0
i2	121.125	0.125	6.07	6.07	-12	0	0
i2	121.25	0.125	7.00	7.00	-12	0	0
i2	121.375	0.125	6.07	6.07	-12	0	0
i2	121.5	0.125	6.00	6.00	-12	0	0
i2	121.625	0.125	6.07	6.07	-12	0	0
i2	121.75	0.125	7.00	7.00	-12	0	0
i2	121.875	0.125	6.07	6.07	-12	0	0
i2	122.0	0.125	6.00	6.00	-12	0	0
i2	122.125	0.125	6.07	6.07	-12	0	0
i2	122.25	0.125	7.00	7.00	-12	0	0
i2	122.375	0.125	6.07	6.07	-12	0	0
i2	122.5	0.125	6.00	6.00	-12	0	0
i2	122.625	0.125	6.07	6.07	-12	0	0
i2	122.75	0.125	7.00	7.00	-12	0	0
i2	122.875	0.125	6.07	6.07	-12	0	0
i2	142.0	0.125	6.00	6.00	-12	0	0
i2	142.125	0.125	6.07	6.07	-12	0	0
i2	142.25	0.125	7.00	7.00	-12	0	0
i2	142.375	0.125	6.07	6.07	-12	0	0
i2	142.5	0.125	6.00	6.00	-12	0	0
i2	142.625	0.125	6.07	6.07	-12	0	0
i2	142.75	0.125	7.00	7.00	-12	0	0
i2	142.875	0.125	6.07	6.07	-12	0	0
i2	143.0	0.125	6.00	6.00	-12	0	0
i2	143.125	0.125	6.07	6.07	-12	0	0
i2	143.25	0.125	7.00	7.00	-12	0	0
i2	143.375	0.125	6.07	6.07	-12	0	0
i2	143.5	0.125	6.00	6.00	-12	0	0
i2	143.625	0.125	6.07	6.07	-12	0	0
i2	143.75	0.125	7.00	7.00	-12	0	0
i2	143.875	0.125	6.07	6.07	-12	0	0
i1	2.0	0.5	8.00	8.00	-20	0	0
i1	3.0	0.5	8.031	8.031	-20	0	0
i1	4.0	0.5	8.0702	8.0702	-20	0	0
i1	24.0	0.5	7.10	7.10	-20	0	0
i1	25.0	0.5	8.021	8.021	-20	0	0
i1	26.0	0.5	8.0702	8.0702	-20	0	0
i1	26.0	0.5	8.10	8.10	-20	0	0
i1	48.0	0.5	8.00	8.00	-20	0	0
i1	49.0	0.5	8.031	8.031	-20	0	0
i1	50.0	0.5	8.0702	8.0702	-20	0	0
i1	100.0	0.5	7.10	7.10	-20	0	0
i1	101.0	0.5	8.021	8.021	-20	0	0
i1	102.0	0.5	8.0702	8.0702	-20	0	0
i1	102.0	0.5	8.10	8.10	-20	0	0
i1	145.0	0.5	8.00	8.00	-20	0	0
i1	146.0	0.5	8.031	8.031	-20	0	0
i1	147.0	0.5	8.0702	8.0702	-20	0	0
i4	1.0	8	6.00	6.00	-6	0	1
i4	12.0	8	6.00	6.00	-6	0	1
i4	32.0	8	6.00	6.00	-6	0	1
i4	43.0	8	6.00	6.00	-6	0	1
i4	56.0	8	6.00	6.00	-6	0	1
i4	68.0	8	6.00	6.00	-6	0	1
i4	81.0	8	6.00	6.00	-6	0	1
i4	93.0	8	6.00	6.00	-6	0	1
i4	132.0	8	6.00	6.00	-6	0	1
i4	144.0	8	6.00	6.00	-6	0	1
i6	0	208	
i7	0	208	
i8	0	0.0001	0	0
i8	186	17	0	-12
i8	203	1	-12	-96
i8	204	0.0001	-96	-96
e

</CsScore>

</CsoundSynthesizer>