#!/hint/bash

# usage: vcsSetup
# Do any test-suite setup.
#
# Count on $TMP and $DBSCRIPTS_CONFIG being set, but not much else
# being done.  Notably $DBSCRIPTS_CONFIG hasn't been loaded yet (so
# that we have a chance to edit it).
vcsSetup() {
	:
}

# usage: vcsDirOfPKGBUILD $pkgbase
#
# Print the path to the directory storing the "trunk"/"master" working
# copy of the PKGBUILD for the given $pkgbase.
vcsDirOfPKGBUILD() {
	local pkgbase=$1

	echo "${TMP}/vcs-none/${pkgbase}"
}

# usage: vcsInitFixture $pkgbase
#
# Initialize from the test fixtures the "trunk"/"master" working copy
# of the PKGBUILD for the given $pkgbase.
vcsInitFixture() {
	local pkgbase=$1

	mkdir -p "${TMP}/vcs-none/${pkgbase}"
	cp "fixtures/${pkgbase}"/* "${TMP}/vcs-none/${pkgbase}"
}

# usage: vcsCommit $msg
# Commit changes to the PKGBUILD in the current directory
vcsCommit() {
	local msg=$1
	:
}

# usage: vcsRelease $repo
# Run from the "trunk"/"master" PKGBUILD directory.
#
# This is a cheap imitation of the `archrelease` program that is part
# of the `devtools` package.
vcsRelease() {
	local repo=$1
	:
}

# usage: vcsCheckPackage $repo $pkgbase $pkgver
#
# Verify that the PKGBUILD for the given $pkgbase is tagged as
# existing in $repo, and has the correct $pkgver.
vcsCheckPackage() {
	local repo=$1
	local pkgbase=$2
	local pkgver=$3
	:
}

# usage: vcsCheckRemovedPackage $repo $pkgbase
#
# Verify that no PKGBUILD for the given $pkgbase is tagged as existing
# in $repo.
vcsCheckRemovedPackage() {
	local repo=$1
	local pkgbase=$2
	:
}
