/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Array;

public final class ArgumentToString {
    private ArgumentToString() {
    }

    public static void appendArgument(Object object, StringBuffer stringBuffer) {
        if (object == null) {
            stringBuffer.append("null");
        } else if (object instanceof String) {
            stringBuffer.append("\"");
            stringBuffer.append(object);
            stringBuffer.append("\"");
        } else if (object instanceof Character) {
            stringBuffer.append("'");
            stringBuffer.append(object);
            stringBuffer.append("'");
        } else if (object.getClass().isArray()) {
            stringBuffer.append("[");
            for (int i = 0; i < Array.getLength(object); ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                ArgumentToString.appendArgument(Array.get(object, i), stringBuffer);
            }
            stringBuffer.append("]");
        } else {
            stringBuffer.append(object);
        }
    }

    public static String argumentToString(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        ArgumentToString.appendArgument(object, stringBuffer);
        return stringBuffer.toString();
    }

    public static String argumentsToString(Object ... objectArray) {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(ArgumentToString.argumentToString(objectArray[i]));
        }
        return stringBuilder.toString();
    }
}

