/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.easymock.ConstructorArgs;
import org.easymock.IAnswer;
import org.easymock.IExpectationSetters;
import org.easymock.IMocksControl;
import org.easymock.internal.AssertionErrorWrapper;
import org.easymock.internal.ClassProxyFactory;
import org.easymock.internal.EasyMockProperties;
import org.easymock.internal.IMocksBehavior;
import org.easymock.internal.IMocksControlState;
import org.easymock.internal.IProxyFactory;
import org.easymock.internal.JavaProxyFactory;
import org.easymock.internal.LastControl;
import org.easymock.internal.MockInvocationHandler;
import org.easymock.internal.MocksBehavior;
import org.easymock.internal.ObjectMethodsFilter;
import org.easymock.internal.Range;
import org.easymock.internal.RecordState;
import org.easymock.internal.ReplayState;
import org.easymock.internal.RuntimeExceptionWrapper;

public class MocksControl
implements IMocksControl,
IExpectationSetters<Object>,
Serializable {
    private static final long serialVersionUID = 443604921336702014L;
    public static final Range ONCE = new Range(1);
    public static final Range AT_LEAST_ONCE = new Range(1, Integer.MAX_VALUE);
    public static final Range ZERO_OR_MORE = new Range(0, Integer.MAX_VALUE);
    private static IProxyFactory classProxyFactory;
    private static final IProxyFactory interfaceProxyFactory;
    private IMocksControlState state;
    private IMocksBehavior behavior;
    private org.easymock.MockType type;

    public MocksControl(org.easymock.MockType mockType) {
        this.type = mockType;
        this.reset();
    }

    public MocksControl(MockType mockType) {
        this.type = mockType.realType;
        this.reset();
    }

    public org.easymock.MockType getType() {
        return this.type;
    }

    public IMocksControlState getState() {
        return this.state;
    }

    @Override
    public <T> T createMock(Class<T> clazz) {
        return this.createMock(null, clazz, null, null);
    }

    @Override
    public <T> T createMock(String string, Class<T> clazz) {
        return this.createMock(string, clazz, null, null);
    }

    @Override
    public <T> T createMock(String string, Class<T> clazz, ConstructorArgs constructorArgs, Method ... methodArray) {
        if (clazz.isInterface() && methodArray != null) {
            throw new IllegalArgumentException("Partial mocking doesn't make sense for interface");
        }
        try {
            this.state.assertRecordState();
            IProxyFactory iProxyFactory = clazz.isInterface() ? interfaceProxyFactory : MocksControl.getClassProxyFactory();
            try {
                return iProxyFactory.createProxy(clazz, new ObjectMethodsFilter(clazz, new MockInvocationHandler(this), string), methodArray, constructorArgs);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new RuntimeExceptionWrapper(new RuntimeException("Class mocking requires to have objenesis library in the classpath", noClassDefFoundError));
            }
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    public static IProxyFactory getProxyFactory(Object object) {
        return Proxy.isProxyClass(object.getClass()) ? new JavaProxyFactory() : MocksControl.getClassProxyFactory();
    }

    private static IProxyFactory getClassProxyFactory() {
        String string = EasyMockProperties.getInstance().getProperty("easymock.disableClassMocking");
        if (Boolean.valueOf(string).booleanValue()) {
            throw new IllegalArgumentException("Class mocking is currently disabled. Change easymock.disableClassMocking to true do modify this behavior");
        }
        IProxyFactory iProxyFactory = classProxyFactory;
        if (iProxyFactory != null) {
            return iProxyFactory;
        }
        classProxyFactory = new ClassProxyFactory();
        return classProxyFactory;
    }

    public static MocksControl getControl(Object object) {
        try {
            IProxyFactory iProxyFactory = MocksControl.getProxyFactory(object);
            ObjectMethodsFilter objectMethodsFilter = (ObjectMethodsFilter)iProxyFactory.getInvocationHandler(object);
            return objectMethodsFilter.getDelegate().getControl();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Not a mock: " + object.getClass().getName());
        }
    }

    public static InvocationHandler getInvocationHandler(Object object) {
        return MocksControl.getClassProxyFactory().getInvocationHandler(object);
    }

    public static <T, V extends T> Class<T> getMockedType(V v) {
        if (Proxy.isProxyClass(v.getClass())) {
            return v.getClass().getInterfaces()[0];
        }
        return v.getClass().getSuperclass();
    }

    @Override
    public final void reset() {
        this.behavior = new MocksBehavior(this.type == org.easymock.MockType.NICE);
        this.behavior.checkOrder(this.type == org.easymock.MockType.STRICT);
        this.state = new RecordState(this.behavior);
        LastControl.reportLastControl(null);
    }

    @Override
    public void resetToNice() {
        this.type = org.easymock.MockType.NICE;
        this.reset();
    }

    @Override
    public void resetToDefault() {
        this.type = org.easymock.MockType.DEFAULT;
        this.reset();
    }

    @Override
    public void resetToStrict() {
        this.type = org.easymock.MockType.STRICT;
        this.reset();
    }

    @Override
    public void replay() {
        try {
            this.state.replay();
            this.state = new ReplayState(this.behavior);
            LastControl.reportLastControl(null);
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void verify() {
        try {
            this.state.verify();
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
        catch (AssertionErrorWrapper assertionErrorWrapper) {
            throw (AssertionError)((Object)((Throwable)((Object)assertionErrorWrapper.getAssertionError())).fillInStackTrace());
        }
    }

    @Override
    public void checkOrder(boolean bl) {
        try {
            this.state.checkOrder(bl);
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void makeThreadSafe(boolean bl) {
        try {
            this.state.makeThreadSafe(bl);
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void checkIsUsedInOneThread(boolean bl) {
        try {
            this.state.checkIsUsedInOneThread(bl);
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> andReturn(Object object) {
        try {
            this.state.andReturn(object);
            return this;
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> andThrow(Throwable throwable) {
        try {
            this.state.andThrow(throwable);
            return this;
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> andAnswer(IAnswer<? extends Object> iAnswer) {
        try {
            this.state.andAnswer(iAnswer);
            return this;
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> andDelegateTo(Object object) {
        try {
            this.state.andDelegateTo(object);
            return this;
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> andVoid() {
        try {
            this.state.andVoid();
            return this;
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void andStubReturn(Object object) {
        try {
            this.state.andStubReturn(object);
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void andStubThrow(Throwable throwable) {
        try {
            this.state.andStubThrow(throwable);
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void andStubAnswer(IAnswer<? extends Object> iAnswer) {
        try {
            this.state.andStubAnswer(iAnswer);
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void andStubDelegateTo(Object object) {
        try {
            this.state.andStubDelegateTo(object);
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void asStub() {
        try {
            this.state.asStub();
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> times(int n) {
        try {
            this.state.times(new Range(n));
            return this;
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> times(int n, int n2) {
        try {
            this.state.times(new Range(n, n2));
            return this;
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> once() {
        try {
            this.state.times(ONCE);
            return this;
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> atLeastOnce() {
        try {
            this.state.times(AT_LEAST_ONCE);
            return this;
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> anyTimes() {
        try {
            this.state.times(ZERO_OR_MORE);
            return this;
        }
        catch (RuntimeExceptionWrapper runtimeExceptionWrapper) {
            throw (RuntimeException)runtimeExceptionWrapper.getRuntimeException().fillInStackTrace();
        }
    }

    static {
        interfaceProxyFactory = new JavaProxyFactory();
    }

    @Deprecated
    public static enum MockType {
        NICE(org.easymock.MockType.NICE),
        DEFAULT(org.easymock.MockType.DEFAULT),
        STRICT(org.easymock.MockType.STRICT);

        public org.easymock.MockType realType;

        private MockType(org.easymock.MockType mockType) {
            this.realType = mockType;
        }
    }
}

