/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.easymock.internal.ErrorMessage;
import org.easymock.internal.ExpectedInvocation;
import org.easymock.internal.ExpectedInvocationAndResults;
import org.easymock.internal.Invocation;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.Results;

public class UnorderedBehavior
implements Serializable {
    private static final long serialVersionUID = 2185791334636597469L;
    private final List<ExpectedInvocationAndResults> results = new ArrayList<ExpectedInvocationAndResults>();
    private final boolean checkOrder;

    public UnorderedBehavior(boolean bl) {
        this.checkOrder = bl;
    }

    public void addExpected(ExpectedInvocation expectedInvocation, Result result, Range range) {
        for (ExpectedInvocationAndResults expectedInvocationAndResults : this.results) {
            if (!expectedInvocationAndResults.getExpectedInvocation().equals(expectedInvocation)) continue;
            expectedInvocationAndResults.getResults().add(result, range);
            return;
        }
        Results results = new Results();
        results.add(result, range);
        this.results.add(new ExpectedInvocationAndResults(expectedInvocation, results));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result addActual(Invocation invocation) {
        for (ExpectedInvocationAndResults expectedInvocationAndResults : this.results) {
            try {
                if (!expectedInvocationAndResults.getResults().hasResults() || !expectedInvocationAndResults.getExpectedInvocation().matches(invocation)) continue;
                Result result = expectedInvocationAndResults.getResults().next();
                invocation.validateCaptures();
                Result result2 = result;
                return result2;
            }
            finally {
                invocation.clearCaptures();
            }
        }
        return null;
    }

    public boolean verify() {
        for (ExpectedInvocationAndResults expectedInvocationAndResults : this.results) {
            if (expectedInvocationAndResults.getResults().hasValidCallCount()) continue;
            return false;
        }
        return true;
    }

    public List<ErrorMessage> getMessages(Invocation invocation) {
        ArrayList<ErrorMessage> arrayList = new ArrayList<ErrorMessage>(this.results.size());
        for (ExpectedInvocationAndResults expectedInvocationAndResults : this.results) {
            boolean bl;
            boolean bl2 = !this.checkOrder;
            boolean bl3 = expectedInvocationAndResults.getResults().hasValidCallCount();
            boolean bl4 = bl = invocation != null && expectedInvocationAndResults.getExpectedInvocation().matches(invocation);
            if (bl2 && bl3 && !bl) continue;
            ErrorMessage errorMessage = new ErrorMessage(bl, expectedInvocationAndResults.toString(), expectedInvocationAndResults.getResults().getCallCount());
            arrayList.add(errorMessage);
        }
        return arrayList;
    }

    public boolean allowsExpectedInvocation(ExpectedInvocation expectedInvocation, boolean bl) {
        if (this.checkOrder != bl) {
            return false;
        }
        if (this.results.isEmpty() || !this.checkOrder) {
            return true;
        }
        ExpectedInvocation expectedInvocation2 = this.results.get(this.results.size() - 1).getExpectedInvocation();
        return expectedInvocation2.equals(expectedInvocation);
    }
}

