/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CmapTable;
import org.apache.fontbox.ttf.TTFDataStream;

public class CmapSubtable {
    private static final Log LOG = LogFactory.getLog(CmapSubtable.class);
    private static final long LEAD_OFFSET = 55232L;
    private static final long SURROGATE_OFFSET = -56613888L;
    private int platformId;
    private int platformEncodingId;
    private long subTableOffset;
    private int[] glyphIdToCharacterCode;
    private Map<Integer, List<Integer>> glyphIdToCharacterCodeMultiple = new HashMap<Integer, List<Integer>>();
    private Map<Integer, Integer> characterCodeToGlyphId;

    public void initData(TTFDataStream tTFDataStream) throws IOException {
        this.platformId = tTFDataStream.readUnsignedShort();
        this.platformEncodingId = tTFDataStream.readUnsignedShort();
        this.subTableOffset = tTFDataStream.readUnsignedInt();
    }

    public void initSubtable(CmapTable cmapTable, int n, TTFDataStream tTFDataStream) throws IOException {
        tTFDataStream.seek(cmapTable.getOffset() + this.subTableOffset);
        int n2 = tTFDataStream.readUnsignedShort();
        if (n2 < 8) {
            long l = tTFDataStream.readUnsignedShort();
            long l2 = tTFDataStream.readUnsignedShort();
        } else {
            tTFDataStream.readUnsignedShort();
            long l = tTFDataStream.readUnsignedInt();
            long l3 = tTFDataStream.readUnsignedInt();
        }
        switch (n2) {
            case 0: {
                this.processSubtype0(tTFDataStream);
                break;
            }
            case 2: {
                this.processSubtype2(tTFDataStream, n);
                break;
            }
            case 4: {
                this.processSubtype4(tTFDataStream, n);
                break;
            }
            case 6: {
                this.processSubtype6(tTFDataStream, n);
                break;
            }
            case 8: {
                this.processSubtype8(tTFDataStream, n);
                break;
            }
            case 10: {
                this.processSubtype10(tTFDataStream, n);
                break;
            }
            case 12: {
                this.processSubtype12(tTFDataStream, n);
                break;
            }
            case 13: {
                this.processSubtype13(tTFDataStream, n);
                break;
            }
            case 14: {
                this.processSubtype14(tTFDataStream, n);
                break;
            }
            default: {
                throw new IOException("Unknown cmap format:" + n2);
            }
        }
    }

    protected void processSubtype8(TTFDataStream tTFDataStream, int n) throws IOException {
        int[] nArray = tTFDataStream.readUnsignedByteArray(8192);
        long l = tTFDataStream.readUnsignedInt();
        if (l > 65536L) {
            throw new IOException("CMap ( Subtype8 ) is invalid");
        }
        this.glyphIdToCharacterCode = this.newGlyphIdToCharacterCode(n);
        this.characterCodeToGlyphId = new HashMap<Integer, Integer>(n);
        for (long i = 0L; i < l; ++i) {
            long l2 = tTFDataStream.readUnsignedInt();
            long l3 = tTFDataStream.readUnsignedInt();
            long l4 = tTFDataStream.readUnsignedInt();
            if (l2 > l3 || 0L > l2) {
                throw new IOException("Range invalid");
            }
            for (long j = l2; j <= l3; ++j) {
                long l5;
                int n2;
                if (j > Integer.MAX_VALUE) {
                    throw new IOException("[Sub Format 8] Invalid Character code");
                }
                if ((nArray[(int)j / 8] & 1 << (int)j % 8) == 0) {
                    n2 = (int)j;
                } else {
                    l5 = 55232L + (j >> 10);
                    long l6 = 56320L + (j & 0x3FFL);
                    long l7 = (l5 << 10) + l6 + -56613888L;
                    if (l7 > Integer.MAX_VALUE) {
                        throw new IOException("[Sub Format 8] Invalid Character code");
                    }
                    n2 = (int)l7;
                }
                l5 = l4 + (j - l2);
                if (l5 > (long)n || l5 > Integer.MAX_VALUE) {
                    throw new IOException("CMap contains an invalid glyph index");
                }
                this.glyphIdToCharacterCode[(int)l5] = n2;
                this.characterCodeToGlyphId.put(n2, (int)l5);
            }
        }
    }

    protected void processSubtype10(TTFDataStream tTFDataStream, int n) throws IOException {
        long l = tTFDataStream.readUnsignedInt();
        long l2 = tTFDataStream.readUnsignedInt();
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("Invalid number of Characters");
        }
        if (l < 0L || l > 0x10FFFFL || l + l2 > 0x10FFFFL || l + l2 >= 55296L && l + l2 <= 57343L) {
            throw new IOException("Invalid Characters codes");
        }
    }

    protected void processSubtype12(TTFDataStream tTFDataStream, int n) throws IOException {
        long l = tTFDataStream.readUnsignedInt();
        this.glyphIdToCharacterCode = this.newGlyphIdToCharacterCode(n);
        this.characterCodeToGlyphId = new HashMap<Integer, Integer>(n);
        block0: for (long i = 0L; i < l; ++i) {
            long l2 = tTFDataStream.readUnsignedInt();
            long l3 = tTFDataStream.readUnsignedInt();
            long l4 = tTFDataStream.readUnsignedInt();
            if (l2 < 0L || l2 > 0x10FFFFL || l2 >= 55296L && l2 <= 57343L) {
                throw new IOException("Invalid characters codes");
            }
            if (l3 > 0L && l3 < l2 || l3 > 0x10FFFFL || l3 >= 55296L && l3 <= 57343L) {
                throw new IOException("Invalid characters codes");
            }
            for (long j = 0L; j <= l3 - l2; ++j) {
                long l5 = l4 + j;
                if (l5 >= (long)n) {
                    LOG.warn((Object)"Format 12 cmap contains an invalid glyph index");
                    continue block0;
                }
                if (l2 + j > 0x10FFFFL) {
                    LOG.warn((Object)"Format 12 cmap contains character beyond UCS-4");
                }
                this.glyphIdToCharacterCode[(int)l5] = (int)(l2 + j);
                this.characterCodeToGlyphId.put((int)(l2 + j), (int)l5);
            }
        }
    }

    protected void processSubtype13(TTFDataStream tTFDataStream, int n) throws IOException {
        long l = tTFDataStream.readUnsignedInt();
        this.characterCodeToGlyphId = new HashMap<Integer, Integer>(n);
        for (long i = 0L; i < l; ++i) {
            long l2 = tTFDataStream.readUnsignedInt();
            long l3 = tTFDataStream.readUnsignedInt();
            long l4 = tTFDataStream.readUnsignedInt();
            if (l4 > (long)n) {
                LOG.warn((Object)"Format 13 cmap contains an invalid glyph index");
                break;
            }
            if (l2 < 0L || l2 > 0x10FFFFL || l2 >= 55296L && l2 <= 57343L) {
                throw new IOException("Invalid Characters codes");
            }
            if (l3 > 0L && l3 < l2 || l3 > 0x10FFFFL || l3 >= 55296L && l3 <= 57343L) {
                throw new IOException("Invalid Characters codes");
            }
            for (long j = 0L; j <= l3 - l2; ++j) {
                if (l2 + j > Integer.MAX_VALUE) {
                    throw new IOException("Character Code greater than Integer.MAX_VALUE");
                }
                if (l2 + j > 0x10FFFFL) {
                    LOG.warn((Object)"Format 13 cmap contains character beyond UCS-4");
                }
                this.glyphIdToCharacterCode[(int)l4] = (int)(l2 + j);
                this.characterCodeToGlyphId.put((int)(l2 + j), (int)l4);
            }
        }
    }

    protected void processSubtype14(TTFDataStream tTFDataStream, int n) throws IOException {
        LOG.warn((Object)"Format 14 cmap table is not supported and will be ignored");
    }

    protected void processSubtype6(TTFDataStream tTFDataStream, int n) throws IOException {
        int n2 = tTFDataStream.readUnsignedShort();
        int n3 = tTFDataStream.readUnsignedShort();
        if (n3 == 0) {
            return;
        }
        this.characterCodeToGlyphId = new HashMap<Integer, Integer>(n);
        int[] nArray = tTFDataStream.readUnsignedShortArray(n3);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            n4 = Math.max(n4, nArray[i]);
            this.characterCodeToGlyphId.put(n2 + i, nArray[i]);
        }
        this.buildGlyphIdToCharacterCodeLookup(n4);
    }

    protected void processSubtype4(TTFDataStream tTFDataStream, int n) throws IOException {
        int n2 = tTFDataStream.readUnsignedShort();
        int n3 = n2 / 2;
        int n4 = tTFDataStream.readUnsignedShort();
        int n5 = tTFDataStream.readUnsignedShort();
        int n6 = tTFDataStream.readUnsignedShort();
        int[] nArray = tTFDataStream.readUnsignedShortArray(n3);
        int n7 = tTFDataStream.readUnsignedShort();
        int[] nArray2 = tTFDataStream.readUnsignedShortArray(n3);
        int[] nArray3 = tTFDataStream.readUnsignedShortArray(n3);
        long l = tTFDataStream.getCurrentPosition();
        int[] nArray4 = tTFDataStream.readUnsignedShortArray(n3);
        this.characterCodeToGlyphId = new HashMap<Integer, Integer>(n);
        int n8 = 0;
        for (int i = 0; i < n3; ++i) {
            int n9 = nArray2[i];
            int n10 = nArray[i];
            int n11 = nArray3[i];
            int n12 = nArray4[i];
            long l2 = l + (long)(i * 2) + (long)n12;
            if (n9 == 65535 || n10 == 65535) continue;
            for (int j = n9; j <= n10; ++j) {
                if (n12 == 0) {
                    int n13 = j + n11 & 0xFFFF;
                    n8 = Math.max(n13, n8);
                    this.characterCodeToGlyphId.put(j, n13);
                    continue;
                }
                long l3 = l2 + (long)((j - n9) * 2);
                tTFDataStream.seek(l3);
                int n14 = tTFDataStream.readUnsignedShort();
                if (n14 == 0) continue;
                n14 = n14 + n11 & 0xFFFF;
                n8 = Math.max(n14, n8);
                this.characterCodeToGlyphId.put(j, n14);
            }
        }
        if (this.characterCodeToGlyphId.isEmpty()) {
            LOG.warn((Object)"cmap format 4 subtable is empty");
            return;
        }
        this.buildGlyphIdToCharacterCodeLookup(n8);
    }

    private void buildGlyphIdToCharacterCodeLookup(int n) {
        this.glyphIdToCharacterCode = this.newGlyphIdToCharacterCode(n + 1);
        for (Map.Entry<Integer, Integer> entry : this.characterCodeToGlyphId.entrySet()) {
            if (this.glyphIdToCharacterCode[entry.getValue()] == -1) {
                this.glyphIdToCharacterCode[entry.getValue().intValue()] = entry.getKey();
                continue;
            }
            List<Integer> list = this.glyphIdToCharacterCodeMultiple.get(entry.getValue());
            if (list == null) {
                list = new ArrayList<Integer>();
                this.glyphIdToCharacterCodeMultiple.put(entry.getValue(), list);
                list.add(this.glyphIdToCharacterCode[entry.getValue()]);
                this.glyphIdToCharacterCode[entry.getValue().intValue()] = Integer.MIN_VALUE;
            }
            list.add(entry.getKey());
        }
    }

    protected void processSubtype2(TTFDataStream tTFDataStream, int n) throws IOException {
        int n2;
        int n3;
        int[] nArray = new int[256];
        int n4 = 0;
        for (int i = 0; i < 256; ++i) {
            nArray[i] = tTFDataStream.readUnsignedShort();
            n4 = Math.max(n4, nArray[i] / 8);
        }
        SubHeader[] subHeaderArray = new SubHeader[n4 + 1];
        for (int i = 0; i <= n4; ++i) {
            int n5 = tTFDataStream.readUnsignedShort();
            n3 = tTFDataStream.readUnsignedShort();
            short s = tTFDataStream.readSignedShort();
            n2 = tTFDataStream.readUnsignedShort() - (n4 + 1 - i - 1) * 8 - 2;
            subHeaderArray[i] = new SubHeader(n5, n3, s, n2);
        }
        long l = tTFDataStream.getCurrentPosition();
        this.glyphIdToCharacterCode = this.newGlyphIdToCharacterCode(n);
        this.characterCodeToGlyphId = new HashMap<Integer, Integer>(n);
        for (n3 = 0; n3 <= n4; ++n3) {
            SubHeader subHeader = subHeaderArray[n3];
            n2 = subHeader.getFirstCode();
            int n6 = subHeader.getIdRangeOffset();
            short s = subHeader.getIdDelta();
            int n7 = subHeader.getEntryCount();
            tTFDataStream.seek(l + (long)n6);
            for (int i = 0; i < n7; ++i) {
                int n8 = n3;
                n8 = (n8 << 8) + (n2 + i);
                int n9 = tTFDataStream.readUnsignedShort();
                if (n9 > 0) {
                    n9 = (n9 + s) % 65536;
                }
                if (n9 >= n) {
                    LOG.warn((Object)("glyphId " + n9 + " for charcode " + n8 + " ignored, numGlyphs is " + n));
                    continue;
                }
                this.glyphIdToCharacterCode[n9] = n8;
                this.characterCodeToGlyphId.put(n8, n9);
            }
        }
    }

    protected void processSubtype0(TTFDataStream tTFDataStream) throws IOException {
        byte[] byArray = tTFDataStream.read(256);
        this.glyphIdToCharacterCode = this.newGlyphIdToCharacterCode(256);
        this.characterCodeToGlyphId = new HashMap<Integer, Integer>(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            this.glyphIdToCharacterCode[n] = i;
            this.characterCodeToGlyphId.put(i, n);
        }
    }

    private int[] newGlyphIdToCharacterCode(int n) {
        int[] nArray = new int[n];
        Arrays.fill(nArray, -1);
        return nArray;
    }

    public int getPlatformEncodingId() {
        return this.platformEncodingId;
    }

    public void setPlatformEncodingId(int n) {
        this.platformEncodingId = n;
    }

    public int getPlatformId() {
        return this.platformId;
    }

    public void setPlatformId(int n) {
        this.platformId = n;
    }

    public int getGlyphId(int n) {
        Integer n2 = this.characterCodeToGlyphId.get(n);
        return n2 == null ? 0 : n2;
    }

    public Integer getCharacterCode(int n) {
        List<Integer> list;
        int n2 = this.getCharCode(n);
        if (n2 == -1) {
            return null;
        }
        if (n2 == Integer.MIN_VALUE && (list = this.glyphIdToCharacterCodeMultiple.get(n)) != null) {
            return list.get(0);
        }
        return n2;
    }

    private int getCharCode(int n) {
        if (n < 0 || n >= this.glyphIdToCharacterCode.length) {
            return -1;
        }
        return this.glyphIdToCharacterCode[n];
    }

    public List<Integer> getCharCodes(int n) {
        int n2 = this.getCharCode(n);
        if (n2 == -1) {
            return null;
        }
        ArrayList<Integer> arrayList = null;
        if (n2 == Integer.MIN_VALUE) {
            List<Integer> list = this.glyphIdToCharacterCodeMultiple.get(n);
            if (list != null) {
                arrayList = new ArrayList<Integer>(list);
                Collections.sort(arrayList);
            }
        } else {
            arrayList = new ArrayList<Integer>(1);
            arrayList.add(n2);
        }
        return arrayList;
    }

    public String toString() {
        return "{" + this.getPlatformId() + " " + this.getPlatformEncodingId() + "}";
    }

    private static class SubHeader {
        private final int firstCode;
        private final int entryCount;
        private final short idDelta;
        private final int idRangeOffset;

        private SubHeader(int n, int n2, short s, int n3) {
            this.firstCode = n;
            this.entryCount = n2;
            this.idDelta = s;
            this.idRangeOffset = n3;
        }

        private int getFirstCode() {
            return this.firstCode;
        }

        private int getEntryCount() {
            return this.entryCount;
        }

        private short getIdDelta() {
            return this.idDelta;
        }

        private int getIdRangeOffset() {
            return this.idRangeOffset;
        }
    }
}

