/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.slots;

import com.db4o.DTrace;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.slots.ReferencedSlot;
import com.db4o.internal.slots.Slot;

public class SlotChange
extends TreeInt {
    private int _action;
    private Slot _newSlot;
    private ReferencedSlot _shared;
    private static final int FREE_ON_COMMIT_BIT = 1;
    private static final int FREE_ON_ROLLBACK_BIT = 2;
    private static final int SET_POINTER_BIT = 3;
    private static final int FREE_POINTER_ON_COMMIT_BIT = 4;
    private static final int FREE_POINTER_ON_ROLLBACK_BIT = 5;
    private static final int FREESPACE_BIT = 6;

    public SlotChange(int id) {
        super(id);
    }

    @Override
    public Object shallowClone() {
        SlotChange sc = new SlotChange(0);
        sc._action = this._action;
        sc._newSlot = this._newSlot;
        sc._shared = this._shared;
        return super.shallowCloneInternal(sc);
    }

    private final void doFreeOnCommit() {
        this.setBit(1);
    }

    private final void doFreeOnRollback() {
        this.setBit(2);
    }

    private final void doFreePointerOnCommit() {
        this.setBit(4);
    }

    private final void doFreePointerOnRollback() {
        this.setBit(5);
    }

    private final void doSetPointer() {
        this.setBit(3);
    }

    public void freeDuringCommit(LocalObjectContainer file, boolean forFreespace) {
        if (this.isFreeOnCommit() && this.isForFreeSpace() == forFreespace) {
            file.freeDuringCommit(this._shared, this._newSlot);
        }
    }

    public final void freeOnCommit(LocalObjectContainer file, Slot slot) {
        if (this._shared != null) {
            file.free(slot);
            return;
        }
        this.doFreeOnCommit();
        ReferencedSlot refSlot = file.produceFreeOnCommitEntry(this._key);
        if (refSlot.addReferenceIsFirst()) {
            refSlot.pointTo(slot);
        }
        this._shared = refSlot;
    }

    public void freeOnRollback(Slot slot) {
        this.doFreeOnRollback();
        this._newSlot = slot;
    }

    public void freeOnRollbackSetPointer(Slot slot) {
        this.doSetPointer();
        this.freeOnRollback(slot);
    }

    public void freePointerOnCommit() {
        this.doFreePointerOnCommit();
    }

    public void freePointerOnRollback() {
        this.doFreePointerOnRollback();
    }

    private final boolean isBitSet(int bitPos) {
        return (this._action | 1 << bitPos) == this._action;
    }

    public boolean isDeleted() {
        return this.isSetPointer() && this._newSlot.address() == 0;
    }

    public boolean isNew() {
        return this.isFreePointerOnRollback();
    }

    private final boolean isForFreeSpace() {
        return this.isBitSet(6);
    }

    private final boolean isFreeOnCommit() {
        return this.isBitSet(1);
    }

    private final boolean isFreeOnRollback() {
        return this.isBitSet(2);
    }

    public final boolean isSetPointer() {
        return this.isBitSet(3);
    }

    public final boolean isFreePointerOnRollback() {
        return this.isBitSet(5);
    }

    public Slot newSlot() {
        return this._newSlot;
    }

    public Slot oldSlot() {
        if (this._shared == null) {
            return null;
        }
        return this._shared.slot();
    }

    @Override
    public Object read(ByteArrayBuffer reader) {
        SlotChange change = new SlotChange(reader.readInt());
        change._newSlot = new Slot(reader.readInt(), reader.readInt());
        change.doSetPointer();
        return change;
    }

    public void rollback(LocalObjectContainer yapFile) {
        if (this._shared != null) {
            yapFile.reduceFreeOnCommitReferences(this._shared);
        }
        if (this.isFreeOnRollback()) {
            yapFile.free(this._newSlot);
        }
        if (this.isFreePointerOnRollback()) {
            if (DTrace.enabled) {
                DTrace.FREE_POINTER_ON_ROLLBACK.logLength(this._key, 8L);
            }
            yapFile.free(this._key, 8);
        }
    }

    private final void setBit(int bitPos) {
        this._action |= 1 << bitPos;
    }

    public void setPointer(Slot slot) {
        this.doSetPointer();
        this._newSlot = slot;
    }

    @Override
    public void write(ByteArrayBuffer writer) {
        if (this.isSetPointer()) {
            writer.writeInt(this._key);
            writer.writeInt(this._newSlot.address());
            writer.writeInt(this._newSlot.length());
        }
    }

    public final void writePointer(LocalTransaction trans) {
        if (this.isSetPointer()) {
            trans.writePointer(this._key, this._newSlot);
        }
    }

    public void forFreespace(boolean flag) {
        if (flag) {
            this.setBit(6);
        }
    }
}

