/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.support.api.Bucket;
import freenet.support.io.StorageFormatException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class ReadOnlyFileSliceBucket
implements Bucket,
Serializable {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final long startAt;
    private final long length;
    static final int MAGIC = 161371332;
    static final int VERSION = 1;

    private ReadOnlyFileSliceBucket() {
        this.startAt = 0L;
        this.length = 0L;
        this.file = null;
    }

    public ReadOnlyFileSliceBucket(File f, long startAt, long length) {
        this.file = new File(f.getPath());
        this.startAt = startAt;
        this.length = length;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Bucket is read-only");
    }

    @Override
    public OutputStream getOutputStreamUnbuffered() throws IOException {
        throw new IOException("Bucket is read-only");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(this.getInputStreamUnbuffered());
    }

    @Override
    public InputStream getInputStreamUnbuffered() throws IOException {
        return new MyInputStream();
    }

    @Override
    public String getName() {
        return "ROFS:" + this.file.getAbsolutePath() + ':' + this.startAt + ':' + this.length;
    }

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly() {
    }

    @Override
    public void free() {
    }

    @Override
    public Bucket createShadow() {
        String fnam = this.file.getPath();
        File newFile = new File(fnam);
        return new ReadOnlyFileSliceBucket(newFile, this.startAt, this.length);
    }

    @Override
    public void onResume(ClientContext context) {
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(161371332);
        dos.writeInt(1);
        dos.writeUTF(this.file.toString());
        dos.writeLong(this.startAt);
        dos.writeLong(this.length);
    }

    protected ReadOnlyFileSliceBucket(DataInputStream dis) throws StorageFormatException, IOException {
        int version = dis.readInt();
        if (version != 1) {
            throw new StorageFormatException("Bad version");
        }
        this.file = new File(dis.readUTF());
        this.startAt = dis.readLong();
        if (this.startAt < 0L) {
            throw new StorageFormatException("Bad start at");
        }
        this.length = dis.readLong();
        if (this.length < 0L) {
            throw new StorageFormatException("Bad length");
        }
        if (!this.file.exists()) {
            throw new StorageFormatException("File does not exist any more");
        }
        if (this.file.length() < this.startAt + this.length) {
            throw new StorageFormatException("Slice does not fit in file");
        }
    }

    public static class ReadOnlyFileSliceBucketException
    extends IOException {
        private static final long serialVersionUID = -1L;

        public ReadOnlyFileSliceBucketException(FileNotFoundException e) {
            super("File not found: " + e.getMessage());
            this.initCause(e);
        }

        public ReadOnlyFileSliceBucketException(String string) {
            super(string);
        }
    }

    private class MyInputStream
    extends InputStream {
        private RandomAccessFile f;
        private long ptr;

        MyInputStream() throws IOException {
            try {
                this.f = new RandomAccessFile(ReadOnlyFileSliceBucket.this.file, "r");
                this.f.seek(ReadOnlyFileSliceBucket.this.startAt);
                if (this.f.length() < ReadOnlyFileSliceBucket.this.startAt + ReadOnlyFileSliceBucket.this.length) {
                    throw new ReadOnlyFileSliceBucketException("File truncated? Length " + this.f.length() + " but start at " + ReadOnlyFileSliceBucket.this.startAt + " for " + ReadOnlyFileSliceBucket.this.length + " bytes");
                }
                this.ptr = 0L;
            }
            catch (FileNotFoundException e) {
                throw new ReadOnlyFileSliceBucketException(e);
            }
        }

        @Override
        public int read() throws IOException {
            if (this.ptr >= ReadOnlyFileSliceBucket.this.length) {
                return -1;
            }
            int x = this.f.read();
            if (x != -1) {
                ++this.ptr;
            }
            return x;
        }

        @Override
        public int read(byte[] buf, int offset, int len) throws IOException {
            if (this.ptr >= ReadOnlyFileSliceBucket.this.length) {
                return -1;
            }
            len = (int)Math.min((long)len, ReadOnlyFileSliceBucket.this.length - this.ptr);
            int x = this.f.read(buf, offset, len);
            this.ptr += (long)x;
            return x;
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        @Override
        public void close() throws IOException {
            this.f.close();
        }
    }
}

