/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.P1HashElement;
import com.db4o.P1ListElement;
import com.db4o.P2HashMap;
import java.util.Iterator;

class P2HashMapIterator
implements Iterator {
    private P1HashElement i_current;
    private final P2HashMap i_map;
    private int i_nextIndex;
    private P1HashElement i_previous;

    P2HashMapIterator(P2HashMap a_map) {
        this.i_map = a_map;
        this.i_nextIndex = -1;
        this.getNextCurrent();
    }

    private int currentIndex() {
        if (this.i_current == null) {
            return -1;
        }
        return this.i_current.i_hashCode & this.i_map.i_mask;
    }

    private void getNextCurrent() {
        this.i_previous = this.i_current;
        this.i_current = (P1HashElement)this.nextElement();
        if (this.i_current != null) {
            this.i_current.checkActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Object object = this.i_map.streamLock();
        synchronized (object) {
            return this.i_current != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next() {
        Object object = this.i_map.streamLock();
        synchronized (object) {
            this.i_map.checkActive();
            Object ret = null;
            if (this.i_current != null) {
                ret = this.i_current.activatedKey(this.i_map.elementActivationDepth());
            }
            this.getNextCurrent();
            return ret;
        }
    }

    private P1ListElement nextElement() {
        if (this.i_current != null && this.i_current.i_next != null) {
            return this.i_current.i_next;
        }
        if (this.i_nextIndex <= this.currentIndex()) {
            this.searchNext();
        }
        if (this.i_nextIndex >= 0) {
            return this.i_map.i_table[this.i_nextIndex];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        Object object = this.i_map.streamLock();
        synchronized (object) {
            this.i_map.checkActive();
            if (this.i_previous != null) {
                int index = this.i_previous.i_hashCode & this.i_map.i_mask;
                if (index >= 0 && index < this.i_map.i_table.length) {
                    P1HashElement last = null;
                    P1HashElement phe = this.i_map.i_table[index];
                    while (phe != this.i_previous && phe != null) {
                        phe.checkActive();
                        last = phe;
                        phe = (P1HashElement)phe.i_next;
                    }
                    if (phe != null) {
                        --this.i_map.i_size;
                        if (last == null) {
                            this.i_map.i_table[index] = (P1HashElement)phe.i_next;
                        } else {
                            last.i_next = phe.i_next;
                            last.update();
                        }
                        this.i_map.modified();
                        phe.delete(this.i_map.i_deleteRemoved);
                    }
                }
                this.i_previous = null;
            }
        }
    }

    private void searchNext() {
        if (this.i_nextIndex > -2) {
            while (++this.i_nextIndex < this.i_map.i_tableSize) {
                if (this.i_map.i_table[this.i_nextIndex] == null) continue;
                return;
            }
            this.i_nextIndex = -2;
        }
    }
}

