/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.HashtableIntEntry;
import com.db4o.foundation.Iterator4;

public class HashtableIterator
implements Iterator4 {
    private final HashtableIntEntry[] _table;
    private HashtableIntEntry _currentEntry;
    private int _currentIndex;

    public HashtableIterator(HashtableIntEntry[] table) {
        this._table = table;
        this.reset();
    }

    private void checkInvalidTable() {
        if (this._table == null || this._table.length == 0) {
            this.positionBeyondLast();
        }
    }

    @Override
    public Object current() {
        if (this._currentEntry == null) {
            throw new IllegalStateException();
        }
        return this._currentEntry;
    }

    @Override
    public boolean moveNext() {
        if (this.isBeyondLast()) {
            return false;
        }
        if (this._currentEntry != null) {
            this._currentEntry = this._currentEntry._next;
        }
        while (this._currentEntry == null) {
            if (this._currentIndex >= this._table.length) {
                this.positionBeyondLast();
                return false;
            }
            this._currentEntry = this._table[this._currentIndex++];
        }
        return true;
    }

    @Override
    public void reset() {
        this._currentEntry = null;
        this._currentIndex = 0;
        this.checkInvalidTable();
    }

    private boolean isBeyondLast() {
        return this._currentIndex == -1;
    }

    private void positionBeyondLast() {
        this._currentIndex = -1;
    }
}

