/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.foundation.Coercion4;
import com.db4o.foundation.PreparedComparison;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteContext;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.Reflector;

public final class ByteHandler
extends PrimitiveHandler {
    static final int LENGTH = 1;
    private static final Byte DEFAULTVALUE = new Byte(0);

    @Override
    public Object coerce(Reflector reflector, ReflectClass claxx, Object obj) {
        return Coercion4.toSByte(obj);
    }

    @Override
    public Object defaultValue() {
        return DEFAULTVALUE;
    }

    @Override
    public int linkLength() {
        return 1;
    }

    @Override
    public Class primitiveJavaClass() {
        return Byte.TYPE;
    }

    @Override
    Object read1(ByteArrayBuffer a_bytes) {
        byte ret = a_bytes.readByte();
        return new Byte(ret);
    }

    @Override
    public void write(Object a_object, ByteArrayBuffer a_bytes) {
        a_bytes.writeByte((Byte)a_object);
    }

    @Override
    public Object read(ReadContext context) {
        byte byteValue = context.readByte();
        return new Byte(byteValue);
    }

    @Override
    public void write(WriteContext context, Object obj) {
        context.writeByte((Byte)obj);
    }

    @Override
    public PreparedComparison internalPrepareComparison(Object source) {
        final byte sourceByte = (Byte)source;
        return new PreparedComparison(){

            @Override
            public int compareTo(Object target) {
                if (target == null) {
                    return 1;
                }
                byte targetByte = (Byte)target;
                return sourceByte == targetByte ? 0 : (sourceByte < targetByte ? -1 : 1);
            }
        };
    }
}

