/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.tools;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ext.StoredClass;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.io.File4;
import com.db4o.internal.ReflectPlatform;
import com.db4o.types.SecondClass;
import java.io.File;
import java.lang.reflect.Modifier;

public class Defragment {
    private static Hashtable4 _secondClassNames;

    public static void main(String[] args) {
        Db4o.configure().messageLevel(-1);
        if (args != null && args.length > 0) {
            boolean forceBackupDelete = args.length > 1 && "!".equals(args[1]);
            new Defragment().run(args[0], forceBackupDelete);
        } else {
            System.out.println("Usage: java com.db4o.tools.Defragment <database filename>");
        }
    }

    public static void setSecondClass(String className) {
        if (_secondClassNames == null) {
            _secondClassNames = new Hashtable4();
        }
        _secondClassNames.put(className, (Object)className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String filename, boolean forceBackupDelete) {
        File file = new File(filename);
        if (file.exists()) {
            boolean canRun = true;
            File backupTest = new File(file.getAbsolutePath() + ".bak");
            if (backupTest.exists()) {
                if (forceBackupDelete) {
                    backupTest.delete();
                } else {
                    canRun = false;
                    System.out.println("A backup file with the name ");
                    System.out.println("'" + backupTest.getAbsolutePath() + "'");
                    System.out.println("already exists.");
                    System.out.println("Remove this file before calling 'Defragment'.");
                }
            }
            if (canRun) {
                file.renameTo(backupTest);
                try {
                    this.configureDb4o();
                    ObjectContainer readFrom = Db4o.openFile(backupTest.getAbsolutePath());
                    ObjectContainer writeTo = Db4o.openFile(file.getAbsolutePath());
                    writeTo.ext().migrateFrom(readFrom);
                    this.migrate(readFrom, writeTo);
                    readFrom.close();
                    writeTo.close();
                    System.out.println("Defragment operation completed successfully.");
                }
                catch (Exception e) {
                    System.out.println("Defragment operation failed.");
                    e.printStackTrace();
                    try {
                        new File(filename).delete();
                        File4.copy(backupTest.getAbsolutePath(), filename);
                    }
                    catch (Exception ex) {
                        System.out.println("Restore failed.");
                        System.out.println("Please use the backup file:");
                        System.out.println("'" + backupTest.getAbsolutePath() + "'");
                        return;
                    }
                    System.out.println("The original file was restored.");
                    try {
                        new File(backupTest.getAbsolutePath()).delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    this.restoreConfiguration();
                }
            }
        } else {
            System.out.println("File '" + file.getAbsolutePath() + "' does not exist.");
        }
    }

    private void configureDb4o() {
        Db4o.configure().activationDepth(0);
        Db4o.configure().callbacks(false);
        Db4o.configure().classActivationDepthConfigurable(false);
        Db4o.configure().weakReferences(false);
    }

    private void restoreConfiguration() {
        Db4o.configure().activationDepth(5);
        Db4o.configure().callbacks(true);
        Db4o.configure().classActivationDepthConfigurable(true);
        Db4o.configure().weakReferences(true);
    }

    private void migrate(ObjectContainer origin, ObjectContainer destination) throws ClassNotFoundException {
        StoredClass[] classes = origin.ext().storedClasses();
        this.removeUnavailableSecondAndAbstractClasses(classes);
        this.removeSubclasses(classes);
        this.migrateClasses(origin, destination, classes);
    }

    private void migrateClasses(ObjectContainer origin, ObjectContainer destination, StoredClass[] classes) {
        int i;
        for (i = 0; i < classes.length; ++i) {
            if (!this.migrateClass(origin, destination, classes[i], true)) continue;
            classes[i] = null;
        }
        if (_secondClassNames != null) {
            for (i = 0; i < classes.length; ++i) {
                this.migrateClass(origin, destination, classes[i], false);
            }
        }
    }

    private boolean migrateClass(ObjectContainer origin, ObjectContainer destination, StoredClass clazz, boolean firstClassPass) {
        if (clazz == null) {
            return false;
        }
        if (firstClassPass && _secondClassNames != null && _secondClassNames.get(clazz.getName()) != null) {
            return false;
        }
        long[] ids = clazz.getIDs();
        origin.ext().purge();
        destination.commit();
        destination.ext().purge();
        for (int j = 0; j < ids.length; ++j) {
            Object obj = origin.ext().getByID(ids[j]);
            if (!firstClassPass && !destination.ext().isStored(obj)) continue;
            origin.activate(obj, 1);
            origin.deactivate(obj, 2);
            origin.activate(obj, 3);
            destination.store(obj);
            origin.deactivate(obj, 1);
            destination.deactivate(obj, 1);
        }
        return true;
    }

    private void removeSubclasses(StoredClass[] classes) throws ClassNotFoundException {
        block0: for (int i = 0; i < classes.length; ++i) {
            if (classes[i] == null) continue;
            Class<?> javaClass = Class.forName(classes[i].getName());
            for (int j = 0; j < classes.length; ++j) {
                Class<?> superClass;
                if (classes[j] == null || classes[i] == classes[j] || !(superClass = Class.forName(classes[j].getName())).isAssignableFrom(javaClass)) continue;
                classes[i] = null;
                continue block0;
            }
        }
    }

    private void removeUnavailableSecondAndAbstractClasses(StoredClass[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            Class javaClass = ReflectPlatform.forName(classes[i].getName());
            if (javaClass != null && !SecondClass.class.isAssignableFrom(javaClass) && !Modifier.isAbstract(javaClass.getModifiers())) continue;
            classes[i] = null;
        }
    }
}

