/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JoiningInputStream
extends FilterInputStream {
    InputStream first;
    InputStream second;

    public JoiningInputStream(InputStream first, InputStream second) {
        super(first);
        if (first == null || second == null) {
            throw new NullPointerException();
        }
        this.first = first;
        this.second = second;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int c = this.in.read(b, off, len);
        if (c == -1 && this.in == this.first) {
            this.in = this.second;
            return this.in.read(b, off, len);
        }
        return c;
    }

    @Override
    public void close() throws IOException {
        this.first.close();
        this.second.close();
    }
}

